/*
 * Decompiled with CFR 0.152.
 */
package fing.model;

import fing.model.FEdge;
import fing.model.FingEdgeDepot;
import giny.model.Edge;
import giny.model.RootGraph;

final class EdgeDepository
implements FingEdgeDepot {
    private static final int INITIAL_CAPACITY = 11;
    private Edge[] m_edgeStack = new Edge[11];
    private int m_size = 0;

    EdgeDepository() {
    }

    public Edge getEdge(RootGraph root, int index, String id) {
        FEdge returnThis = this.m_size == 0 ? new FEdge() : (FEdge)this.m_edgeStack[--this.m_size];
        returnThis.m_rootGraph = root;
        returnThis.m_rootGraphIndex = index;
        returnThis.m_identifier = id;
        return returnThis;
    }

    public void recycleEdge(Edge edge) {
        if (edge == null) {
            return;
        }
        try {
            this.m_edgeStack[this.m_size] = edge;
            ++this.m_size;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int newArrSize = (int)Math.min(Integer.MAX_VALUE, (long)this.m_edgeStack.length * 2L + 1L);
            if (newArrSize == this.m_edgeStack.length) {
                throw new IllegalStateException("unable to allocate large enough array");
            }
            Edge[] newArr = new Edge[newArrSize];
            System.arraycopy(this.m_edgeStack, 0, newArr, 0, this.m_edgeStack.length);
            this.m_edgeStack = newArr;
            this.m_edgeStack[this.m_size++] = edge;
        }
    }
}

