/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.continuous;

import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class PointTextListener
extends FocusAdapter {
    private JTextField textField;
    private int index;
    private ContinuousMapping cm;
    private JDialog parent;

    public PointTextListener(JTextField textField, ContinuousMapping cm, JDialog parent, int index) {
        this.textField = textField;
        this.cm = cm;
        this.parent = parent;
        this.index = index;
    }

    public void focusLost(FocusEvent e) {
        ContinuousMappingPoint point = this.cm.getPoint(this.index);
        try {
            this.validate(point);
        }
        catch (IllegalArgumentException arge) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(6);
            String textValue = numberFormat.format(point.getValue());
            this.textField.setText(textValue);
            JOptionPane.showMessageDialog(this.parent, arge.getMessage() + " Please try again.", "Data Validation Error", 2);
        }
    }

    private void validate(ContinuousMappingPoint point) {
        double newValue = this.getNewValue();
        this.checkPreviousPoint(newValue);
        this.checkNextPoint(newValue);
        point.setValue(newValue);
    }

    private double getNewValue() {
        double newValue;
        String number = this.textField.getText();
        try {
            newValue = Double.parseDouble(number);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("This is not a number:  " + number + ".");
        }
        return newValue;
    }

    private void checkNextPoint(double newValue) {
        try {
            ContinuousMappingPoint nextPoint = this.cm.getPoint(this.index + 1);
            double nextValue = nextPoint.getValue();
            if (newValue > nextValue) {
                throw new IllegalArgumentException(newValue + " must be greater than " + "next point:  " + nextValue + ".");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private boolean checkPreviousPoint(double newValue) {
        boolean errorFlag = false;
        try {
            ContinuousMappingPoint prevPoint = this.cm.getPoint(this.index - 1);
            double previousValue = prevPoint.getValue();
            if (newValue < previousValue) {
                throw new IllegalArgumentException(newValue + " must be less than " + "previous point:  " + previousValue + ".");
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        return errorFlag;
    }
}

