/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.CyAttributesReader;
import cytoscape.giny.CytoscapeRootGraph;
import cytoscape.util.FileUtil;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.LineStyle;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.NodeShape;
import cytoscape.visual.TestNodeView;
import cytoscape.visual.VisualPropertyDependencyImpl;
import cytoscape.visual.VisualPropertyType;
import giny.model.Node;
import java.awt.Color;
import java.awt.Font;
import java.io.FileReader;
import java.util.Properties;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class NodeAppearanceCalculatorTest
extends TestCase {
    CyNetwork cyNet;
    CyNode a;
    CyNode b;
    CyNode c;
    CyEdge ab;
    CalculatorCatalog catalog;
    Properties props;

    public NodeAppearanceCalculatorTest(String name) {
        super(name);
    }

    public void setUp() {
        System.out.println("setup begin");
        this.cyNet = Cytoscape.createNetworkFromFile("testData/small.sif");
        this.a = Cytoscape.getCyNode("a");
        this.b = Cytoscape.getCyNode("b");
        this.c = Cytoscape.getCyNode("c");
        this.ab = Cytoscape.getCyEdge(this.a, this.b, "interaction", "pp", false);
        this.props = new Properties();
        try {
            CyAttributesReader.loadAttributes(Cytoscape.getNodeAttributes(), new FileReader("testData/small.nodeAttr"));
            this.props.load(FileUtil.getInputStream("testData/small.vizmap.props"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.catalog = new CalculatorCatalog();
        CalculatorIO.loadCalculators(this.props, this.catalog, true);
        System.out.println("setup end");
    }

    public void testDefaultAppearance() {
        System.out.println("begin NodeAppearanceCalculatorTest.testDefaultAppearance()");
        NodeAppearanceCalculator nac = new NodeAppearanceCalculator(new VisualPropertyDependencyImpl());
        NodeAppearance na = nac.calculateNodeAppearance(this.a, this.cyNet);
        NodeAppearanceCalculatorTest.assertTrue("a color  " + na.get(VisualPropertyType.NODE_FILL_COLOR) + " expect " + Color.WHITE.toString(), ((Color)na.get(VisualPropertyType.NODE_FILL_COLOR)).equals(Color.WHITE));
        NodeAppearanceCalculatorTest.assertTrue("a border color  " + na.get(VisualPropertyType.NODE_BORDER_COLOR) + " expect " + Color.BLACK.toString(), ((Color)na.get(VisualPropertyType.NODE_BORDER_COLOR)).equals(Color.BLACK));
        NodeAppearanceCalculatorTest.assertEquals("a lineType  ", (Object)LineStyle.SOLID, (Object)((LineStyle)((Object)na.get(VisualPropertyType.NODE_LINETYPE))));
        NodeAppearanceCalculatorTest.assertEquals("a shape  ", (Object)NodeShape.RECT, (Object)((NodeShape)((Object)na.get(VisualPropertyType.NODE_SHAPE))));
        NodeAppearanceCalculatorTest.assertEquals("a width  ", (Object)35.0, (Object)this.getWidth(na, nac));
        NodeAppearanceCalculatorTest.assertEquals("a height  ", (Object)35.0, (Object)this.getHeight(na, nac));
        NodeAppearanceCalculatorTest.assertEquals("a size  ", (Object)35.0, (Double)na.get(VisualPropertyType.NODE_SIZE));
        NodeAppearanceCalculatorTest.assertEquals("a label  ", "", (String)na.get(VisualPropertyType.NODE_LABEL));
        NodeAppearanceCalculatorTest.assertEquals("a tooltip  ", "", (String)na.get(VisualPropertyType.NODE_TOOLTIP));
        NodeAppearanceCalculatorTest.assertEquals("a font size  ", 12, ((Number)na.get(VisualPropertyType.NODE_FONT_SIZE)).intValue());
        NodeAppearanceCalculatorTest.assertEquals("a font style  ", 0, ((Font)na.get(VisualPropertyType.NODE_FONT_FACE)).getStyle());
        NodeAppearanceCalculatorTest.assertTrue("a label color  " + na.get(VisualPropertyType.NODE_LABEL_COLOR) + " expect " + Color.BLACK, ((Color)na.get(VisualPropertyType.NODE_LABEL_COLOR)).equals(Color.BLACK));
        NodeAppearance nb = nac.calculateNodeAppearance(this.b, this.cyNet);
        NodeAppearanceCalculatorTest.assertTrue("b color  " + nb.get(VisualPropertyType.NODE_FILL_COLOR) + " expect " + Color.WHITE.toString(), ((Color)nb.get(VisualPropertyType.NODE_FILL_COLOR)).equals(Color.WHITE));
        NodeAppearanceCalculatorTest.assertTrue("b border color  " + nb.get(VisualPropertyType.NODE_BORDER_COLOR) + " expect " + Color.BLACK.toString(), ((Color)nb.get(VisualPropertyType.NODE_BORDER_COLOR)).equals(Color.BLACK));
        NodeAppearanceCalculatorTest.assertEquals("b lineType  ", (Object)LineStyle.SOLID, (Object)((LineStyle)((Object)nb.get(VisualPropertyType.NODE_LINETYPE))));
        NodeAppearanceCalculatorTest.assertEquals("b shape  ", (Object)NodeShape.RECT, (Object)((NodeShape)((Object)nb.get(VisualPropertyType.NODE_SHAPE))));
        NodeAppearanceCalculatorTest.assertEquals("b width  ", (Object)35.0, (Object)this.getWidth(nb, nac));
        NodeAppearanceCalculatorTest.assertEquals("b height  ", (Object)35.0, (Object)this.getHeight(nb, nac));
        NodeAppearanceCalculatorTest.assertEquals("b size  ", (Object)35.0, (Double)nb.get(VisualPropertyType.NODE_SIZE));
        NodeAppearanceCalculatorTest.assertEquals("b label  ", "", (String)nb.get(VisualPropertyType.NODE_LABEL));
        NodeAppearanceCalculatorTest.assertEquals("b tooltip  ", "", (String)nb.get(VisualPropertyType.NODE_TOOLTIP));
        NodeAppearanceCalculatorTest.assertEquals("b font size  ", 12, ((Number)nb.get(VisualPropertyType.NODE_FONT_SIZE)).intValue());
        NodeAppearanceCalculatorTest.assertEquals("b font style  ", 0, ((Font)nb.get(VisualPropertyType.NODE_FONT_FACE)).getStyle());
        NodeAppearanceCalculatorTest.assertTrue("b label color  " + nb.get(VisualPropertyType.NODE_LABEL_COLOR) + " expect " + Color.BLACK, ((Color)nb.get(VisualPropertyType.NODE_LABEL_COLOR)).equals(Color.BLACK));
        nac.setNodeSizeLocked(false);
        NodeAppearance nc = nac.calculateNodeAppearance(this.c, this.cyNet);
        NodeAppearanceCalculatorTest.assertTrue("c color  " + nc.get(VisualPropertyType.NODE_FILL_COLOR) + " expect " + Color.WHITE.toString(), ((Color)nc.get(VisualPropertyType.NODE_FILL_COLOR)).equals(Color.WHITE));
        NodeAppearanceCalculatorTest.assertTrue("c border color  " + nc.get(VisualPropertyType.NODE_BORDER_COLOR) + " expect " + Color.BLACK.toString(), ((Color)nc.get(VisualPropertyType.NODE_BORDER_COLOR)).equals(Color.BLACK));
        NodeAppearanceCalculatorTest.assertEquals("c lineType  ", (Object)LineStyle.SOLID, (Object)((LineStyle)((Object)nc.get(VisualPropertyType.NODE_LINETYPE))));
        NodeAppearanceCalculatorTest.assertEquals("c shape  ", (Object)NodeShape.RECT, (Object)((NodeShape)((Object)nc.get(VisualPropertyType.NODE_SHAPE))));
        NodeAppearanceCalculatorTest.assertEquals("c width  ", (Object)70.0, (Object)this.getWidth(nc, nac));
        NodeAppearanceCalculatorTest.assertEquals("c height  ", (Object)30.0, (Object)this.getHeight(nc, nac));
        NodeAppearanceCalculatorTest.assertEquals("c size  ", (Object)35.0, (Double)nc.get(VisualPropertyType.NODE_SIZE));
        NodeAppearanceCalculatorTest.assertEquals("c label  ", "", (String)nc.get(VisualPropertyType.NODE_LABEL));
        NodeAppearanceCalculatorTest.assertEquals("c tooltip  ", "", (String)nc.get(VisualPropertyType.NODE_TOOLTIP));
        NodeAppearanceCalculatorTest.assertEquals("c font size  ", 12, ((Number)nc.get(VisualPropertyType.NODE_FONT_SIZE)).intValue());
        NodeAppearanceCalculatorTest.assertEquals("c font style  ", 0, ((Font)nc.get(VisualPropertyType.NODE_FONT_FACE)).getStyle());
        NodeAppearanceCalculatorTest.assertTrue("c label color  " + nc.get(VisualPropertyType.NODE_LABEL_COLOR) + " expect " + Color.BLACK, ((Color)nc.get(VisualPropertyType.NODE_LABEL_COLOR)).equals(Color.BLACK));
        NodeAppearance def = nac.getDefaultAppearance();
        def.set(VisualPropertyType.NODE_FILL_COLOR, Color.GREEN);
        def.set(VisualPropertyType.NODE_BORDER_COLOR, Color.BLUE);
        def.set(VisualPropertyType.NODE_WIDTH, 47.0);
        def.set(VisualPropertyType.NODE_HEIGHT, 23.0);
        na = nac.calculateNodeAppearance(this.a, this.cyNet);
        NodeAppearanceCalculatorTest.assertTrue("color  " + na.get(VisualPropertyType.NODE_FILL_COLOR) + " expect " + Color.GREEN.toString(), ((Color)na.get(VisualPropertyType.NODE_FILL_COLOR)).equals(Color.GREEN));
        NodeAppearanceCalculatorTest.assertTrue("border color  " + na.get(VisualPropertyType.NODE_BORDER_COLOR) + " expect " + Color.BLUE.toString(), ((Color)na.get(VisualPropertyType.NODE_BORDER_COLOR)).equals(Color.BLUE));
        NodeAppearanceCalculatorTest.assertEquals("width  ", (Object)47.0, (Object)this.getWidth(na, nac));
        NodeAppearanceCalculatorTest.assertEquals("height  ", (Object)23.0, (Object)this.getHeight(na, nac));
        nb = nac.calculateNodeAppearance(this.b, this.cyNet);
        NodeAppearanceCalculatorTest.assertTrue("color  " + nb.get(VisualPropertyType.NODE_FILL_COLOR) + " expect " + Color.GREEN.toString(), ((Color)nb.get(VisualPropertyType.NODE_FILL_COLOR)).equals(Color.GREEN));
        NodeAppearanceCalculatorTest.assertTrue("border color  " + nb.get(VisualPropertyType.NODE_BORDER_COLOR) + " expect " + Color.BLUE.toString(), ((Color)nb.get(VisualPropertyType.NODE_BORDER_COLOR)).equals(Color.BLUE));
        NodeAppearanceCalculatorTest.assertEquals("width  ", (Object)47.0, (Object)this.getWidth(nb, nac));
        NodeAppearanceCalculatorTest.assertEquals("height  ", (Object)23.0, (Object)this.getHeight(nb, nac));
        System.out.println("end NodeAppearanceCalculatorTest.testDefaultAppearance()");
    }

    public void testApplyProperties() {
        System.out.println("begin NodeAppearanceCalculatorTest.testApplyProperties()");
        NodeAppearanceCalculator nac = new NodeAppearanceCalculator(new VisualPropertyDependencyImpl());
        nac.applyProperties("homer", this.props, "nodeAppearanceCalculator.homer", this.catalog);
        System.out.println(nac.getDescription());
        nac.setNodeSizeLocked(false);
        NodeAppearance na = nac.calculateNodeAppearance(this.a, this.cyNet);
        System.out.println("NodeAppearance a\n" + na.getDescription());
        Color ca = new Color(246, 242, 103);
        NodeAppearanceCalculatorTest.assertTrue("a color  " + na.get(VisualPropertyType.NODE_FILL_COLOR) + " expect " + ca.toString(), ((Color)na.get(VisualPropertyType.NODE_FILL_COLOR)).equals(ca));
        NodeAppearanceCalculatorTest.assertTrue("a border color  " + na.get(VisualPropertyType.NODE_BORDER_COLOR) + " expect " + Color.BLACK.toString(), ((Color)na.get(VisualPropertyType.NODE_BORDER_COLOR)).equals(Color.BLACK));
        NodeAppearanceCalculatorTest.assertEquals("a lineType  ", (Object)LineStyle.SOLID, (Object)((LineStyle)((Object)na.get(VisualPropertyType.NODE_LINETYPE))));
        NodeAppearanceCalculatorTest.assertEquals("a shape  ", (Object)NodeShape.RECT, (Object)((NodeShape)((Object)na.get(VisualPropertyType.NODE_SHAPE))));
        NodeAppearanceCalculatorTest.assertEquals("a width  ", (Object)70.0, (Object)this.getWidth(na, nac));
        NodeAppearanceCalculatorTest.assertEquals("a height  ", (Object)10.0, (Object)this.getHeight(na, nac));
        NodeAppearanceCalculatorTest.assertEquals("a size  ", (Object)35.0, (Double)na.get(VisualPropertyType.NODE_SIZE));
        NodeAppearanceCalculatorTest.assertEquals("a label  ", "a", (String)na.get(VisualPropertyType.NODE_LABEL));
        NodeAppearanceCalculatorTest.assertEquals("a tooltip  ", "", (String)na.get(VisualPropertyType.NODE_TOOLTIP));
        NodeAppearanceCalculatorTest.assertEquals("a font size  ", 12, ((Number)na.get(VisualPropertyType.NODE_FONT_SIZE)).intValue());
        NodeAppearanceCalculatorTest.assertEquals("a font style  ", 0, ((Font)na.get(VisualPropertyType.NODE_FONT_FACE)).getStyle());
        NodeAppearanceCalculatorTest.assertTrue("a label color  " + na.get(VisualPropertyType.NODE_LABEL_COLOR) + " expect " + Color.BLACK, ((Color)na.get(VisualPropertyType.NODE_LABEL_COLOR)).equals(Color.BLACK));
        NodeAppearance nb = nac.calculateNodeAppearance(this.b, this.cyNet);
        System.out.println("NodeAppearance b\n" + nb.getDescription());
        Color cb = new Color(87, 25, 230);
        NodeAppearanceCalculatorTest.assertTrue("b color  " + nb.get(VisualPropertyType.NODE_FILL_COLOR) + " expect " + cb.toString(), ((Color)nb.get(VisualPropertyType.NODE_FILL_COLOR)).equals(cb));
        NodeAppearanceCalculatorTest.assertTrue("b border color  " + nb.get(VisualPropertyType.NODE_BORDER_COLOR) + " expect " + Color.BLACK, ((Color)nb.get(VisualPropertyType.NODE_BORDER_COLOR)).equals(Color.BLACK));
        NodeAppearanceCalculatorTest.assertEquals("b line width  ", Float.valueOf(1.0f), nb.get(VisualPropertyType.NODE_LINE_WIDTH));
        NodeAppearanceCalculatorTest.assertEquals("b line style  ", (Object)LineStyle.SOLID, nb.get(VisualPropertyType.NODE_LINE_STYLE));
        NodeAppearanceCalculatorTest.assertEquals("b shape  ", (Object)NodeShape.RECT, (Object)((NodeShape)((Object)nb.get(VisualPropertyType.NODE_SHAPE))));
        NodeAppearanceCalculatorTest.assertEquals("b width  ", (Object)70.0, (Object)this.getWidth(nb, nac));
        NodeAppearanceCalculatorTest.assertEquals("b height  ", (Object)30.0, (Object)this.getHeight(nb, nac));
        NodeAppearanceCalculatorTest.assertEquals("b size  ", (Object)35.0, (Double)nb.get(VisualPropertyType.NODE_SIZE));
        NodeAppearanceCalculatorTest.assertEquals("b label  ", "b", (String)nb.get(VisualPropertyType.NODE_LABEL));
        NodeAppearanceCalculatorTest.assertEquals("b tooltip  ", "", (String)nb.get(VisualPropertyType.NODE_TOOLTIP));
        NodeAppearanceCalculatorTest.assertEquals("b font size  ", 12, ((Number)nb.get(VisualPropertyType.NODE_FONT_SIZE)).intValue());
        NodeAppearanceCalculatorTest.assertEquals("b font style  ", 0, ((Font)nb.get(VisualPropertyType.NODE_FONT_FACE)).getStyle());
        NodeAppearanceCalculatorTest.assertTrue("b label color  " + nb.get(VisualPropertyType.NODE_LABEL_COLOR) + " expect " + Color.BLACK.toString(), ((Color)nb.get(VisualPropertyType.NODE_LABEL_COLOR)).equals(Color.BLACK));
        nac.setNodeSizeLocked(true);
        NodeAppearance nc = nac.calculateNodeAppearance(this.c, this.cyNet);
        System.out.println("NodeAppearance c\n" + nc.getDescription());
        Color cc = new Color(209, 205, 254);
        NodeAppearanceCalculatorTest.assertTrue("c color  " + nc.get(VisualPropertyType.NODE_FILL_COLOR) + " expect " + cc.toString(), ((Color)nc.get(VisualPropertyType.NODE_FILL_COLOR)).equals(cc));
        NodeAppearanceCalculatorTest.assertTrue("c border color  " + nc.get(VisualPropertyType.NODE_BORDER_COLOR) + " expect " + Color.BLACK, ((Color)nc.get(VisualPropertyType.NODE_BORDER_COLOR)).equals(Color.BLACK));
        NodeAppearanceCalculatorTest.assertEquals("c line Type  ", (Object)LineStyle.SOLID, nb.get(VisualPropertyType.NODE_LINE_STYLE));
        NodeAppearanceCalculatorTest.assertEquals("c line width  ", Float.valueOf(1.0f), Float.valueOf(((Number)nc.get(VisualPropertyType.NODE_LINE_WIDTH)).floatValue()));
        NodeAppearanceCalculatorTest.assertEquals("c shape  ", (Object)NodeShape.RECT, (Object)((NodeShape)((Object)nc.get(VisualPropertyType.NODE_SHAPE))));
        NodeAppearanceCalculatorTest.assertEquals("c width  ", (Object)35.0, (Object)this.getWidth(nc, nac));
        NodeAppearanceCalculatorTest.assertEquals("c height  ", (Object)35.0, (Object)this.getHeight(nc, nac));
        NodeAppearanceCalculatorTest.assertEquals("c size  ", (Object)35.0, (Double)nc.get(VisualPropertyType.NODE_SIZE));
        NodeAppearanceCalculatorTest.assertEquals("c label  ", "c", (String)nc.get(VisualPropertyType.NODE_LABEL));
        NodeAppearanceCalculatorTest.assertEquals("c tooltip  ", "", (String)nc.get(VisualPropertyType.NODE_TOOLTIP));
        NodeAppearanceCalculatorTest.assertEquals("c font size  ", 12, ((Number)nc.get(VisualPropertyType.NODE_FONT_SIZE)).intValue());
        NodeAppearanceCalculatorTest.assertEquals("c font style  ", 0, ((Font)nc.get(VisualPropertyType.NODE_FONT_FACE)).getStyle());
        NodeAppearanceCalculatorTest.assertTrue("c label color  " + nc.get(VisualPropertyType.NODE_LABEL_COLOR) + " expect " + Color.BLACK.toString(), ((Color)nc.get(VisualPropertyType.NODE_LABEL_COLOR)).equals(Color.BLACK));
        System.out.println("end NodeAppearanceCalculatorTest.testApplyProperties()");
    }

    public void testNodeSizeLock() {
        System.out.println("begin NodeAppearanceCalculatorTest.testNodeSizeLock()");
        NodeAppearanceCalculator nac = new NodeAppearanceCalculator(new VisualPropertyDependencyImpl());
        System.out.println(nac.getDescription());
        TestNodeView view = new TestNodeView();
        NodeAppearance na = null;
        nac.setNodeSizeLocked(false);
        na = nac.calculateNodeAppearance(this.a, this.cyNet);
        na.applyAppearance(view, nac.deps);
        NodeAppearanceCalculatorTest.assertEquals("height", (Object)30.0, (Object)view.getHeight());
        NodeAppearanceCalculatorTest.assertEquals("width", (Object)70.0, (Object)view.getWidth());
        nac.setNodeSizeLocked(true);
        na = nac.calculateNodeAppearance(this.a, this.cyNet);
        na.applyAppearance(view, nac.deps);
        NodeAppearanceCalculatorTest.assertEquals("height", (Object)35.0, (Object)view.getHeight());
        NodeAppearanceCalculatorTest.assertEquals("width", (Object)35.0, (Object)view.getWidth());
        nac.applyProperties("homer", this.props, "nodeAppearanceCalculator.homer", this.catalog);
        na = nac.calculateNodeAppearance(this.a, this.cyNet);
        na.applyAppearance(view, nac.deps);
        NodeAppearanceCalculatorTest.assertEquals("height", (Object)35.0, (Object)view.getHeight());
        NodeAppearanceCalculatorTest.assertEquals("width", (Object)35.0, (Object)view.getWidth());
        nac.setNodeSizeLocked(false);
        na = nac.calculateNodeAppearance(this.a, this.cyNet);
        na.applyAppearance(view, nac.deps);
        NodeAppearanceCalculatorTest.assertEquals("height", (Object)10.0, (Object)view.getHeight());
        NodeAppearanceCalculatorTest.assertEquals("width", (Object)70.0, (Object)view.getWidth());
        System.out.println("end NodeAppearanceCalculatorTest.testNodeSizeLock()");
    }

    public void testBypass() throws Exception {
        Color fillColor = new Color(63, 128, 255);
        Color borderColor = new Color(100, 100, 50);
        NodeShape shape = NodeShape.DIAMOND;
        double width = 49.0;
        double height = 79.0;
        String label = "testLabel";
        String toolTip = "testToolTip";
        Font font = new Font("SansSerif", 2, 10);
        String fontString = "SansSerif,italic,10";
        CytoscapeRootGraph graph = Cytoscape.getRootGraph();
        int index1 = graph.createNode();
        Node first = graph.getNode(index1);
        int index2 = graph.createNode();
        Node second = graph.getNode(index2);
        CyNetwork network2 = Cytoscape.createNetwork(Cytoscape.getRootGraph().getNodeIndicesArray(), Cytoscape.getRootGraph().getEdgeIndicesArray(), null);
        CyAttributes secondNodeAttr = Cytoscape.getNodeAttributes();
        String secondName = second.getIdentifier();
        secondNodeAttr.setAttribute(secondName, "node.fillColor", "63,128,255");
        secondNodeAttr.setAttribute(secondName, "node.borderColor", "100,100,50");
        secondNodeAttr.setAttribute(secondName, "node.lineType", "dashed3");
        secondNodeAttr.setAttribute(secondName, "node.shape", "diamond");
        secondNodeAttr.setAttribute(secondName, "node.width", "49.0");
        secondNodeAttr.setAttribute(secondName, "node.height", "79.0");
        secondNodeAttr.setAttribute(secondName, "node.size", "32.0");
        secondNodeAttr.setAttribute(secondName, "node.label", "testLabel");
        secondNodeAttr.setAttribute(secondName, "node.toolTip", "testToolTip");
        secondNodeAttr.setAttribute(secondName, "node.font", "SansSerif,italic,10");
        NodeAppearanceCalculator nac = new NodeAppearanceCalculator(new VisualPropertyDependencyImpl());
        nac.setNodeSizeLocked(false);
        NodeAppearance secondApp = nac.calculateNodeAppearance(second, network2);
        System.out.println("secondApp\n" + secondApp.getDescription());
        NodeAppearanceCalculatorTest.assertTrue(((Color)secondApp.get(VisualPropertyType.NODE_FILL_COLOR)).equals(fillColor));
        NodeAppearanceCalculatorTest.assertTrue(((Color)secondApp.get(VisualPropertyType.NODE_BORDER_COLOR)).equals(borderColor));
        NodeAppearanceCalculatorTest.assertTrue((NodeShape)((Object)secondApp.get(VisualPropertyType.NODE_SHAPE)) == shape);
        NodeAppearanceCalculatorTest.assertEquals("width ", this.getWidth(secondApp, nac), width, 1.0E-4);
        NodeAppearanceCalculatorTest.assertEquals("height ", this.getHeight(secondApp, nac), height, 1.0E-4);
        NodeAppearanceCalculatorTest.assertTrue(((String)secondApp.get(VisualPropertyType.NODE_LABEL)).equals(label));
        NodeAppearanceCalculatorTest.assertTrue(((String)secondApp.get(VisualPropertyType.NODE_TOOLTIP)).equals(toolTip));
        NodeAppearanceCalculatorTest.assertTrue(((Font)secondApp.get(VisualPropertyType.NODE_FONT_FACE)).equals(font));
        nac.setNodeSizeLocked(true);
        nac.calculateNodeAppearance(secondApp, second, network2);
        NodeAppearanceCalculatorTest.assertEquals("width", this.getWidth(secondApp, nac), 32.0, 1.0E-4);
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(NodeAppearanceCalculatorTest.class));
    }

    private double getWidth(NodeAppearance na, NodeAppearanceCalculator nac) {
        if (nac.getNodeSizeLocked()) {
            return (Double)na.get(VisualPropertyType.NODE_SIZE);
        }
        return (Double)na.get(VisualPropertyType.NODE_WIDTH);
    }

    private double getHeight(NodeAppearance na, NodeAppearanceCalculator nac) {
        if (nac.getNodeSizeLocked()) {
            return (Double)na.get(VisualPropertyType.NODE_SIZE);
        }
        return (Double)na.get(VisualPropertyType.NODE_HEIGHT);
    }
}

