/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.Cytoscape;
import cytoscape.data.readers.CytoscapeSessionReader;
import cytoscape.logger.CyLogger;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;

class OpenRecentAction
extends AbstractAction {
    private URL sessionFileURL;
    private CyLogger logger;

    OpenRecentAction(URL sessionFileURL) {
        super(sessionFileURL.toString());
        this.sessionFileURL = sessionFileURL;
        this.logger = CyLogger.getLogger(OpenRecentAction.class);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            CytoscapeSessionReader reader = new CytoscapeSessionReader(this.sessionFileURL);
            if (reader == null) {
                this.logger.warn("Failed to load: " + this.sessionFileURL);
                return;
            }
            try {
                reader.read();
            }
            catch (Exception ex1) {
                this.logger.warn("Failed to load: " + this.sessionFileURL);
                return;
            }
            String sessionName = this.sessionFileURL.toString();
            Cytoscape.setCurrentSessionFileName(sessionName);
            Cytoscape.getDesktop().setTitle("Cytoscape Desktop (Session Name: " + sessionName + ")");
        }
        catch (IOException ex2) {
            this.logger.warn("Failed to open session: " + this.sessionFileURL);
            System.err.println(ex2);
        }
    }
}

