/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxJList
extends JList
implements ListSelectionListener {
    private static final Color SELECTED_COLOR = new Color(0, 100, 250, 250);
    private static final Color NORMAL_COLOR = new Color(100, 100, 100, 170);
    private static Color listBackground;
    private static final Font NORMAL_FONT;
    private static final Font SELECTED_FONT;
    public static final String LIST_UPDATED = "LIST_UPDATED";
    private HashSet<Integer> selectionCache = new HashSet();

    public CheckBoxJList() {
        this.setCellRenderer(new CheckBoxListCellRenderer());
        this.addListSelectionListener(this);
    }

    public void setSelectedItems(List<String> selected) {
        ListSelectionListener[] listeners;
        for (ListSelectionListener l : listeners = this.getListSelectionListeners()) {
            this.removeListSelectionListener(l);
        }
        this.getSelectionModel().clearSelection();
        this.selectionCache.clear();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            if (!selected.contains(this.getModel().getElementAt(i))) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
            this.selectionCache.add(i);
        }
        for (ListSelectionListener l : listeners) {
            this.addListSelectionListener(l);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (!lse.getValueIsAdjusting()) {
            this.removeListSelectionListener(this);
            HashSet<Integer> newSelections = new HashSet<Integer>();
            int size = this.getModel().getSize();
            for (int i = 0; i < size; ++i) {
                if (!this.getSelectionModel().isSelectedIndex(i)) continue;
                newSelections.add(i);
            }
            for (Integer index : this.selectionCache) {
                this.getSelectionModel().addSelectionInterval(index, index);
            }
            for (Integer index : newSelections) {
                if (this.selectionCache.contains(index)) {
                    this.getSelectionModel().removeSelectionInterval(index, index);
                    continue;
                }
                this.getSelectionModel().addSelectionInterval(index, index);
            }
            this.selectionCache.clear();
            for (int i = 0; i < size; ++i) {
                if (!this.getSelectionModel().isSelectedIndex(i)) continue;
                this.selectionCache.add(i);
            }
            this.addListSelectionListener(this);
            this.firePropertyChange(LIST_UPDATED, null, null);
        }
    }

    static {
        NORMAL_FONT = new Font("SansSerif", 0, 12);
        SELECTED_FONT = new Font("SansSerif", 1, 12);
        UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
        listBackground = uid.getColor("List.background");
    }

    class CheckBoxListCellRenderer
    extends JComponent
    implements ListCellRenderer {
        private final DefaultListCellRenderer defaultComp;
        private final JCheckBox checkbox;
        private final BorderLayout layout = new BorderLayout();

        public CheckBoxListCellRenderer() {
            this.setLayout(this.layout);
            this.defaultComp = new DefaultListCellRenderer();
            this.checkbox = new JCheckBox();
            this.add((Component)this.checkbox, "West");
            this.add((Component)this.defaultComp, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.defaultComp.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.checkbox.setSelected(isSelected);
            if (isSelected) {
                this.checkbox.setFont(SELECTED_FONT);
                this.defaultComp.setFont(SELECTED_FONT);
                this.checkbox.setForeground(SELECTED_COLOR);
                this.defaultComp.setForeground(SELECTED_COLOR);
            } else {
                this.checkbox.setFont(NORMAL_FONT);
                this.defaultComp.setFont(NORMAL_FONT);
                this.checkbox.setForeground(NORMAL_COLOR);
                this.defaultComp.setForeground(NORMAL_COLOR);
            }
            Component[] comps = this.getComponents();
            int length = comps.length;
            for (int i = 0; i < length; ++i) {
                comps[i].setBackground(listBackground);
            }
            return this;
        }
    }
}

