/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.CytoscapeInit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentlyOpenedTracker {
    private static final int MAX_TRACK_COUNT = 5;
    private final String trackerFileName;
    private final LinkedList<URL> trackerURLs;

    public RecentlyOpenedTracker(String trackerFileName) throws IOException {
        String line;
        this.trackerFileName = trackerFileName;
        this.trackerURLs = new LinkedList();
        File input = new File(CytoscapeInit.getConfigVersionDirectory(), trackerFileName);
        if (!input.exists()) {
            input.createNewFile();
        }
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null && this.trackerURLs.size() < 5) {
            String newURL = line.trim();
            if (newURL.length() <= 0) continue;
            this.trackerURLs.addLast(new URL(newURL));
        }
    }

    public synchronized List<URL> getRecentlyOpenedURLs() {
        return (List)this.trackerURLs.clone();
    }

    public synchronized void add(URL newURL) {
        this.trackerURLs.remove(newURL);
        if (this.trackerURLs.size() == 5) {
            this.trackerURLs.removeLast();
        }
        this.trackerURLs.addFirst(newURL);
    }

    public void writeOut() throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(new File(CytoscapeInit.getConfigVersionDirectory(), this.trackerFileName));
        for (URL trackerURL : this.trackerURLs) {
            writer.println(trackerURL.toString());
        }
        writer.close();
    }

    public synchronized URL getMostRecentAddition() {
        if (this.trackerURLs.isEmpty()) {
            return null;
        }
        return this.trackerURLs.getFirst();
    }
}

