/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.render.stateful;

import cytoscape.render.immed.GraphGraphics;
import cytoscape.render.stateful.MeasuredLine;
import cytoscape.render.stateful.MeasuredLineCreator;
import java.awt.Font;
import java.awt.Paint;

final class TextRenderingUtils {
    private TextRenderingUtils() {
    }

    public static final void renderHorizontalText(GraphGraphics grafx, MeasuredLineCreator measuredText, Font font, double fontScaleFactor, float textXCenter, float textYCenter, byte textJustify, Paint paint, boolean textAsShape) {
        double currHeight = measuredText.getTotalHeight() / -2.0;
        double overallWidth = measuredText.getMaxLineWidth();
        for (MeasuredLine line : measuredText.getMeasuredLines()) {
            double xCenter;
            double yCenter = currHeight + (double)textYCenter + line.getHeight() / 2.0;
            if (textJustify == 64) {
                xCenter = textXCenter;
            } else if (textJustify == 65) {
                xCenter = -0.5 * (overallWidth - line.getWidth()) + (double)textXCenter;
            } else if (textJustify == 66) {
                xCenter = 0.5 * (overallWidth - line.getWidth()) + (double)textXCenter;
            } else {
                throw new IllegalStateException("textJustify value unrecognized");
            }
            grafx.drawTextFull(font, fontScaleFactor, line.getLine(), (float)xCenter, (float)yCenter, 0.0f, paint, textAsShape);
            currHeight += line.getHeight();
        }
    }
}

