/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.logger.CyLogger;
import cytoscape.plugin.Category;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.DownloadableType;
import cytoscape.plugin.PluginFileReader;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.PluginStatus;
import cytoscape.plugin.PluginXml;
import cytoscape.plugin.ThemeInfo;
import cytoscape.plugin.TrackerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginTracker {
    private static CyLogger logger = CyLogger.getLogger(PluginTracker.class);
    private Document trackerDoc;
    private File installFile;
    private HashMap<String, Element> infoObjMap;
    private Set<Element> corruptedElements;
    private boolean corruptedElementsFound = false;
    private String cytoVersTag = "cytoscapeVersion";
    private String nameTag = PluginXml.NAME.getTag();
    private String descTag = PluginXml.DESCRIPTION.getTag();
    private String classTag = PluginXml.CLASS_NAME.getTag();
    private String pluginVersTag = PluginXml.PLUGIN_VERSION.getTag();
    private String urlTag = PluginXml.URL.getTag();
    private String projUrlTag = PluginXml.PROJECT_URL.getTag();
    private String downloadUrlTag = PluginXml.DOWNLOAD_URL.getTag();
    private String categoryTag = PluginXml.CATEGORY.getTag();
    private String fileListTag = PluginXml.FILE_LIST.getTag();
    private String fileTag = PluginXml.FILE.getTag();
    private String pluginListTag = PluginXml.PLUGIN_LIST.getTag();
    private String pluginTag = PluginXml.PLUGIN.getTag();
    private String authorListTag = PluginXml.AUTHOR_LIST.getTag();
    private String authorTag = PluginXml.AUTHOR.getTag();
    private String instTag = PluginXml.INSTITUTION.getTag();
    private String uniqueIdTag = PluginXml.UNIQUE_ID.getTag();
    private String fileTypeTag = PluginXml.FILE_TYPE.getTag();
    private String licenseTag = PluginXml.LICENSE.getTag();
    private String installLocTag = PluginXml.INSTALL_LOCATION.getTag();

    protected PluginTracker(File Dir, String FileName) throws IOException, TrackerException {
        this.installFile = new File(Dir, FileName);
        this.init();
    }

    protected PluginTracker(File file) throws IOException, TrackerException {
        this.installFile = file;
        this.init();
    }

    protected File getTrackerFile() {
        return this.installFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() throws IOException, TrackerException {
        this.corruptedElements = new HashSet<Element>();
        if (PluginManager.usingWebstartManager()) {
            this.installFile.delete();
        }
        if (this.installFile.exists() && this.installFile.length() > 0L) {
            SAXBuilder Builder2 = new SAXBuilder(false);
            try {
                try {
                    block8: {
                        FileInputStream is = null;
                        try {
                            is = new FileInputStream(this.installFile);
                            this.trackerDoc = Builder2.build(is, this.installFile.toURI().toURL().toString());
                            Object var4_4 = null;
                            if (is == null) break block8;
                        }
                        catch (Throwable throwable) {
                            Object var4_5 = null;
                            if (is == null) throw throwable;
                            is.close();
                            throw throwable;
                        }
                        is.close();
                    }
                    this.removeMissingIdEntries();
                    this.write();
                    this.validateTrackerDoc();
                }
                catch (Exception jde) {
                    this.installFile.delete();
                    this.createCleanDoc();
                    throw new TrackerException("Plugin tracking file is corrupted.  Please reinstall your plugins. Deleting " + this.installFile.getAbsolutePath(), jde);
                }
                Object var6_7 = null;
                this.createPluginTable();
                return;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.createPluginTable();
                throw throwable;
            }
        }
        this.createCleanDoc();
        this.createPluginTable();
    }

    private void validateTrackerDoc() {
        for (PluginStatus ps : PluginStatus.values()) {
            Iterator iter = this.trackerDoc.getRootElement().getChild(ps.getTagName()).getChildren().iterator();
            if (iter != null) continue;
            throw new NullPointerException("corrupted tracker file");
        }
    }

    private void createCleanDoc() {
        logger.warn("Plugin tracker file: " + this.installFile.getAbsolutePath());
        this.trackerDoc = new Document();
        this.trackerDoc.setRootElement(new Element("CytoscapePlugin"));
        this.trackerDoc.getRootElement().addContent(new Element(PluginStatus.CURRENT.getTagName()));
        this.trackerDoc.getRootElement().addContent(new Element(PluginStatus.INSTALL.getTagName()));
        this.trackerDoc.getRootElement().addContent(new Element(PluginStatus.DELETE.getTagName()));
        this.write();
    }

    private void removeMissingIdEntries() {
        List Plugins2 = this.trackerDoc.getRootElement().getChild(PluginStatus.CURRENT.getTagName()).getChildren(this.pluginTag);
        ArrayList<Element> PluginsToRemove = new ArrayList<Element>();
        for (Element plugin : Plugins2) {
            if (plugin.getChild(this.uniqueIdTag) != null && plugin.getChild(this.uniqueIdTag).getTextTrim().length() > 0) continue;
            PluginsToRemove.add(plugin);
        }
        for (Element child : PluginsToRemove) {
            this.trackerDoc.getRootElement().getChild(PluginStatus.CURRENT.getTagName()).removeContent(child);
        }
    }

    protected List<PluginInfo> getPluginListByStatus(PluginStatus Status2) {
        return this.getPluginContent(this.trackerDoc.getRootElement().getChild(Status2.getTagName()));
    }

    protected List<DownloadableInfo> getDownloadableListByStatus(PluginStatus Status2) {
        return this.getDownloadableContent(this.trackerDoc.getRootElement().getChild(Status2.getTagName()));
    }

    protected List<ThemeInfo> getThemeListByStatus(PluginStatus Status2) {
        return this.getThemeContent(this.trackerDoc.getRootElement().getChild(Status2.getTagName()));
    }

    protected void addDownloadable(DownloadableInfo obj, PluginStatus Status2) {
        Element Parent2 = this.trackerDoc.getRootElement().getChild(Status2.getTagName());
        switch (obj.getType()) {
            case PLUGIN: {
                this.addPlugin((PluginInfo)obj, Status2);
                break;
            }
            case THEME: {
                this.addTheme((ThemeInfo)obj, Status2);
            }
        }
    }

    private void addTheme(ThemeInfo obj, PluginStatus Status2) {
        Element ThemeParent = this.trackerDoc.getRootElement().getChild(Status2.getTagName());
        Element Theme = this.getMatchingInfoObj(obj, Status2);
        if (Theme != null) {
            Theme = this.updateBasicElement(obj, Theme);
            Theme.getChild(PluginXml.PLUGIN_LIST.getTag()).removeChildren(PluginXml.PLUGIN.getTag());
            for (PluginInfo plugin : obj.getPlugins()) {
                Element ThemePlugin = this.getMatchingInfoObj(plugin, Status2);
                ThemePlugin = this.updatePluginElement(plugin, ThemePlugin);
                Theme.getChild(PluginXml.PLUGIN_LIST.getTag()).addContent(ThemePlugin);
            }
        } else {
            Theme = this.createThemeContent(obj);
            ThemeParent.addContent(Theme);
            this.infoObjMap.put(this.infoMapKey(obj, Status2), Theme);
            logger.info("Adding theme " + obj.getName() + " status " + Status2.name());
        }
        this.write();
    }

    private Element updateBasicElement(DownloadableInfo obj, Element element) {
        if (!obj.getCategory().equals(Category.NONE.getCategoryText())) {
            element.getChild(this.categoryTag).setText(obj.getCategory());
        }
        element.getChild(this.cytoVersTag).setText(obj.getCytoscapeVersion());
        element.getChild(this.descTag).setText(obj.getDescription());
        if (element.getChild(this.pluginVersTag) != null) {
            element.getChild(this.pluginVersTag).setText(obj.getObjectVersion());
        } else {
            Element PluginVersion = new Element(this.pluginVersTag);
            element.addContent(PluginVersion.setText(obj.getObjectVersion()));
        }
        if (element.getChild(PluginXml.RELEASE_DATE.getTag()) != null) {
            element.getChild(PluginXml.RELEASE_DATE.getTag()).setText(obj.getReleaseDate());
        } else {
            Element ReleaseDate = new Element(PluginXml.RELEASE_DATE.getTag());
            element.addContent(ReleaseDate.setText(obj.getReleaseDate()));
        }
        return element;
    }

    private Element updatePluginElement(PluginInfo obj, Element Plugin2) {
        if (!obj.getName().equals(obj.getPluginClassName())) {
            Plugin2.getChild(this.nameTag).setText(obj.getName());
        }
        Plugin2 = this.updateBasicElement(obj, Plugin2);
        Plugin2.getChild(this.installLocTag).setText(obj.getInstallLocation());
        if (obj.getPluginClassName() != null) {
            Plugin2.getChild(this.classTag).setText(obj.getPluginClassName());
        }
        Plugin2.removeChild(this.authorListTag);
        Element Authors = new Element(this.authorListTag);
        for (PluginInfo.AuthorInfo ai : obj.getAuthors()) {
            Element Author = new Element(this.authorTag);
            Author.addContent(new Element(this.nameTag).setText(ai.getAuthor()));
            Author.addContent(new Element(this.instTag).setText(ai.getInstitution()));
            Authors.addContent(Author);
        }
        Plugin2.addContent(Authors);
        return Plugin2;
    }

    private void addPlugin(PluginInfo obj, PluginStatus Status2) {
        Element PluginParent = this.trackerDoc.getRootElement().getChild(Status2.getTagName());
        Element PluginEl = this.getMatchingInfoObj(obj, Status2);
        if (PluginEl != null) {
            this.updatePluginElement(obj, PluginEl);
            this.infoObjMap.put(this.infoMapKey(obj, Status2), PluginEl);
        } else {
            Element NewPlugin = this.createPluginContent(obj);
            PluginParent.addContent(NewPlugin);
            this.infoObjMap.put(this.infoMapKey(obj, Status2), NewPlugin);
            logger.info("Adding plugin " + obj.getName() + " status " + Status2.name());
        }
        this.write();
    }

    protected void removeDownloadable(DownloadableInfo obj, PluginStatus Status2) {
        Element Parent2 = this.trackerDoc.getRootElement().getChild(Status2.getTagName());
        Element InfoObj2 = this.getMatchingInfoObj(obj, Status2);
        if (InfoObj2 != null) {
            Parent2.removeContent(InfoObj2);
            this.infoObjMap.remove(this.infoMapKey(obj, Status2));
            if (obj.getType().equals((Object)DownloadableType.THEME)) {
                ThemeInfo theme = (ThemeInfo)obj;
                for (PluginInfo themePlugin : theme.getPlugins()) {
                    this.infoObjMap.remove(this.infoMapKey(themePlugin, Status2));
                }
            }
            logger.info("Removing plugin/theme " + obj.getName() + " status " + Status2.name());
            this.write();
        }
    }

    protected Element getMatchingInfoObj(DownloadableInfo Obj, PluginStatus Status2) {
        String Key2 = this.infoMapKey(Obj, Status2);
        if (Key2 != null) {
            return this.infoObjMap.get(Key2);
        }
        return null;
    }

    private void createPluginTable() {
        this.infoObjMap = new HashMap();
        for (PluginStatus ps : PluginStatus.values()) {
            for (Element el : this.trackerDoc.getRootElement().getChild(ps.getTagName()).getChildren()) {
                if (el.getName().equals(PluginXml.THEME.getTag())) {
                    this.infoObjMap.put(this.infoMapKey(el, ps), el);
                    for (Element pEl : el.getChild(PluginXml.PLUGIN_LIST.getTag()).getChildren(PluginXml.PLUGIN.getTag())) {
                        String key = this.infoMapKey(pEl, ps);
                        this.infoObjMap.put(key, pEl);
                    }
                    continue;
                }
                if (el.getName().equals(PluginXml.PLUGIN.getTag())) {
                    String key = this.infoMapKey(el, ps);
                    this.infoObjMap.put(key, el);
                    continue;
                }
                logger.warn("Unknown tag in plugin tracker file: " + el.getName());
            }
        }
    }

    private String infoMapKey(DownloadableInfo Obj, PluginStatus Status2) {
        return Obj.getID() != null ? Obj.getID() + "_" + Obj.getType().value() + "_" + Obj.getDownloadableURL() + "_" + Status2.getTagName() : null;
    }

    private String infoMapKey(Element el, PluginStatus Status2) {
        return el.getChildTextTrim(this.uniqueIdTag) + "_" + el.getName() + "_" + el.getChildTextTrim(this.downloadUrlTag) + "_" + Status2.getTagName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void write() {
        for (Element e : this.corruptedElements) {
            e.detach();
        }
        try {
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            FileWriter writer = null;
            try {
                writer = new FileWriter(this.installFile);
                out.output(this.trackerDoc, (Writer)writer);
                Object var4_4 = null;
                if (writer == null) return;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            writer.close();
            return;
        }
        catch (IOException E) {
            logger.warn("Error writing plugin status file " + E.toString());
        }
    }

    public boolean hasCorruptedElements() {
        return this.corruptedElementsFound;
    }

    public int getTotalCorruptedElements() {
        return this.corruptedElements.size();
    }

    public void clearCorruptedElements() {
        this.corruptedElementsFound = false;
        this.corruptedElements.clear();
    }

    private void addCorruptedElement(Element e) {
        logger.warn("** Adding corrupted element **");
        this.corruptedElements.add(e);
        this.corruptedElementsFound = true;
    }

    public String toString() {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        return out.outputString(this.trackerDoc);
    }

    protected void delete() {
        if (this.installFile.exists()) {
            this.installFile.delete();
        }
    }

    private DownloadableInfo createBasicObject(Element e, DownloadableType Type2) {
        DownloadableInfo Info2 = null;
        if (e.getChildren().size() > 0 && e.getChild(this.uniqueIdTag) != null) {
            switch (Type2) {
                case PLUGIN: {
                    Info2 = new PluginInfo(e.getChildTextTrim(this.uniqueIdTag));
                    break;
                }
                case THEME: {
                    Info2 = new ThemeInfo(e.getChildTextTrim(this.uniqueIdTag));
                }
            }
            if (e.getChild(this.nameTag) == null || e.getChild(this.descTag) == null || e.getChild(this.cytoVersTag) == null || e.getChild(this.urlTag) == null || e.getChild(this.downloadUrlTag) == null) {
                return null;
            }
            Info2.setName(e.getChildTextTrim(this.nameTag));
            Info2.setDescription(e.getChildTextTrim(this.descTag));
            Info2.addCytoscapeVersion(e.getChildTextTrim(this.cytoVersTag));
            Info2.setObjectUrl(e.getChildTextTrim(this.urlTag));
            Info2.setDownloadableURL(e.getChildTextTrim(this.downloadUrlTag));
            if (e.getChild(this.categoryTag) != null) {
                Info2.setCategory(e.getChildTextTrim(this.categoryTag));
            }
            if (e.getChild(PluginXml.RELEASE_DATE.getTag()) != null) {
                Info2.setReleaseDate(e.getChildTextTrim(PluginXml.RELEASE_DATE.getTag()));
            }
        }
        return Info2;
    }

    private List<ThemeInfo> getThemeContent(Element ThemeParentTag) {
        ArrayList<ThemeInfo> Content2 = new ArrayList<ThemeInfo>();
        List Themes = ThemeParentTag.getChildren(PluginXml.THEME.getTag());
        for (Element CurrentTheme : Themes) {
            ThemeInfo themeInfo = (ThemeInfo)this.createBasicObject(CurrentTheme, DownloadableType.THEME);
            if (themeInfo == null || CurrentTheme.getChild(PluginXml.THEME_VERSION.getTag()) == null || CurrentTheme.getChild(PluginXml.PLUGIN_LIST.getTag()) == null || CurrentTheme.getChild(PluginXml.PLUGIN_LIST.getTag()).getChildren(PluginXml.PLUGIN.getTag()).size() <= 0) {
                this.addCorruptedElement(CurrentTheme);
                continue;
            }
            themeInfo.setObjectVersion(Double.valueOf(CurrentTheme.getChildTextTrim(PluginXml.THEME_VERSION.getTag())));
            Iterator pluginI = CurrentTheme.getChild(PluginXml.PLUGIN_LIST.getTag()).getChildren(PluginXml.PLUGIN.getTag()).iterator();
            while (pluginI.hasNext()) {
                PluginInfo pluginInfo = this.createPluginObject((Element)pluginI.next());
                if (pluginInfo == null) {
                    this.addCorruptedElement(CurrentTheme);
                    break;
                }
                pluginInfo.setParent(themeInfo);
                themeInfo.addPlugin(pluginInfo);
            }
            if (this.corruptedElements.contains(CurrentTheme)) continue;
            Content2.add(themeInfo);
        }
        return Content2;
    }

    private List<PluginInfo> getPluginContent(Element PluginParentTag) {
        ArrayList<PluginInfo> Content2 = new ArrayList<PluginInfo>();
        List Plugins2 = PluginParentTag.getChildren(this.pluginTag);
        for (Element CurrentPlugin : Plugins2) {
            PluginInfo Info2 = this.createPluginObject(CurrentPlugin);
            if (Info2 == null) {
                this.addCorruptedElement(CurrentPlugin);
                continue;
            }
            Content2.add(Info2);
        }
        return Content2;
    }

    private List<DownloadableInfo> getDownloadableContent(Element Parent2) {
        ArrayList<DownloadableInfo> Content2 = new ArrayList<DownloadableInfo>();
        Content2.addAll(this.getPluginContent(Parent2));
        Content2.addAll(this.getThemeContent(Parent2));
        return Content2;
    }

    private PluginInfo createPluginObject(Element PluginElement) {
        PluginInfo Info2 = (PluginInfo)this.createBasicObject(PluginElement, DownloadableType.PLUGIN);
        if (Info2 == null || PluginElement.getChildren().size() <= 0 || PluginElement.getChild(this.classTag) == null || PluginElement.getChild(this.installLocTag) == null || PluginElement.getChild(this.pluginVersTag) == null || PluginElement.getChild(this.fileTypeTag) == null || PluginElement.getChild(this.fileListTag) == null) {
            return null;
        }
        Info2.setPluginClassName(PluginElement.getChildTextTrim(this.classTag));
        Info2.setInstallLocation(PluginElement.getChildTextTrim(this.installLocTag));
        Info2.setObjectVersion(Double.valueOf(PluginElement.getChildTextTrim(this.pluginVersTag)));
        Info2.setProjectUrl(PluginElement.getChildTextTrim(this.projUrlTag));
        String FileType2 = PluginElement.getChildTextTrim(this.fileTypeTag);
        if (FileType2.equalsIgnoreCase(PluginInfo.FileType.JAR.toString())) {
            Info2.setFiletype(PluginInfo.FileType.JAR);
        } else if (FileType2.equalsIgnoreCase(PluginInfo.FileType.ZIP.toString())) {
            Info2.setFiletype(PluginInfo.FileType.ZIP);
        }
        List Files = PluginElement.getChild(this.fileListTag).getChildren(this.fileTag);
        for (Element File2 : Files) {
            Info2.addFileName(File2.getTextTrim());
        }
        if (PluginElement.getChild(this.authorListTag) != null) {
            List Authors = PluginElement.getChild(this.authorListTag).getChildren(this.authorTag);
            for (Element Author : Authors) {
                Info2.addAuthor(Author.getChildTextTrim(this.nameTag), Author.getChildTextTrim(this.instTag));
            }
        }
        Info2 = PluginFileReader.addLicense(Info2, PluginElement);
        return Info2;
    }

    private Element createBasicContent(DownloadableInfo obj, Element e) {
        e.addContent(new Element(this.uniqueIdTag).setText(obj.getID()));
        e.addContent(new Element(this.nameTag).setText(obj.getName()));
        e.addContent(new Element(this.descTag).setText(obj.getDescription()));
        e.addContent(new Element(this.cytoVersTag).setText(obj.getCytoscapeVersion()));
        e.addContent(new Element(this.urlTag).setText(obj.getObjectUrl()));
        e.addContent(new Element(this.downloadUrlTag).setText(obj.getDownloadableURL()));
        e.addContent(new Element(this.categoryTag).setText(obj.getCategory()));
        e.addContent(new Element(PluginXml.RELEASE_DATE.getTag()).setText(obj.getReleaseDate()));
        return e;
    }

    private Element createThemeContent(ThemeInfo obj) {
        Element Theme = new Element(PluginXml.THEME.getTag());
        Theme = this.createBasicContent(obj, Theme);
        Theme.addContent(new Element(PluginXml.THEME_VERSION.getTag()).setText(obj.getObjectVersion()));
        Element PluginList = new Element(PluginXml.PLUGIN_LIST.getTag());
        for (PluginInfo plugin : obj.getPlugins()) {
            PluginList.addContent(this.createPluginContent(plugin));
        }
        Theme.addContent(PluginList);
        return Theme;
    }

    private Element createPluginContent(PluginInfo obj) {
        Element Plugin2 = new Element(this.pluginTag);
        Plugin2 = this.createBasicContent(obj, Plugin2);
        Plugin2.addContent(new Element(this.pluginVersTag).setText(obj.getObjectVersion()));
        Plugin2.addContent(new Element(this.classTag).setText(obj.getPluginClassName()));
        Plugin2.addContent(new Element(this.projUrlTag).setText(obj.getProjectUrl()));
        Plugin2.addContent(new Element(this.fileTypeTag).setText(obj.getFileType().toString()));
        Plugin2.addContent(new Element(this.installLocTag).setText(obj.getInstallLocation()));
        Element License2 = new Element(this.licenseTag);
        License2.addContent(new Element("text").setText(obj.getLicenseText()));
        Plugin2.addContent(License2);
        Element AuthorList = new Element(this.authorListTag);
        for (PluginInfo.AuthorInfo CurrentAuthor : obj.getAuthors()) {
            Element Author = new Element(this.authorTag);
            Author.addContent(new Element(this.nameTag).setText(CurrentAuthor.getAuthor()));
            Author.addContent(new Element(this.instTag).setText(CurrentAuthor.getInstitution()));
            AuthorList.addContent(Author);
        }
        Plugin2.addContent(AuthorList);
        Element FileList = new Element(this.fileListTag);
        for (String FileName : obj.getFileList()) {
            FileList.addContent(new Element(this.fileTag).setText(FileName));
        }
        Plugin2.addContent(FileList);
        return Plugin2;
    }
}

