/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.data.readers.AbstractGraphReader;
import cytoscape.data.readers.NNFParser;
import cytoscape.data.readers.NestedNetworkReader;
import cytoscape.task.TaskMonitor;
import cytoscape.util.FileUtil;
import cytoscape.util.PercentUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NNFReader
extends AbstractGraphReader
implements NestedNetworkReader {
    private static final char COMMENT_CHAR = '#';
    private final NNFParser parser;
    private final InputStream inputStream;
    private TaskMonitor taskMonitor;
    private PercentUtil percentUtil;

    public NNFReader(String filename) {
        this(filename, null);
    }

    public NNFReader(String filename, TaskMonitor monitor) {
        this(FileUtil.getInputStream(filename), filename);
        this.taskMonitor = monitor;
    }

    public NNFReader(InputStream is, String name) {
        super(name);
        this.inputStream = is;
        this.parser = new NNFParser();
    }

    @Override
    public void setTaskMonitor(TaskMonitor monitor) {
        this.taskMonitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(this.inputStream));
        try {
            String line;
            int lineNumber = 1;
            while ((line = in.readLine()) != null) {
                if ((line = this.processComment(line)).length() != 0 && !this.parser.parse(line)) {
                    throw new IOException("Malformed line in NNF file: " + lineNumber + " \"" + line + "\"");
                }
                ++lineNumber;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            in.close();
            throw throwable;
        }
        in.close();
        if (this.parser.getNetworks().size() == 0) {
            throw new IOException("Input NNF file is empty!");
        }
    }

    @Override
    public int[] getNodeIndicesArray() {
        return null;
    }

    @Override
    public int[] getEdgeIndicesArray() {
        return null;
    }

    private String processComment(String line) {
        int hashPos = line.indexOf(35);
        if (hashPos != -1) {
            line = line.substring(0, hashPos);
        }
        return line.trim();
    }

    @Override
    public List<CyNetwork> getNetworks() {
        return this.parser.getNetworks();
    }

    @Override
    public String getNetworkName() {
        return "";
    }
}

