/*
 * Decompiled with CFR 0.152.
 */
package ViolinStrings;

import ViolinStrings.WordEntry;
import java.util.Locale;
import java.util.Vector;

public class Strings {
    protected Strings() {
    }

    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        if (ignoreCase) {
            return Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2);
        }
        return c1 == c2;
    }

    public static boolean equals(String s1, String s2, boolean ignoreCase) {
        if (ignoreCase) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public static int compare(String s1, String s2) {
        return s1.compareTo(s2);
    }

    public static boolean startsWith(String s, String prefix, boolean ignoreCase) {
        return s.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static boolean startsWith(String s, String prefix) {
        return s.startsWith(prefix);
    }

    public static boolean startsWith(String s, String prefix, int start) {
        return s.startsWith(prefix, start);
    }

    public static boolean startsWith(String s, String prefix, int start, boolean ignoreCase) {
        return s.regionMatches(ignoreCase, start, prefix, 0, prefix.length());
    }

    public static boolean endsWith(String s, String suffix, boolean ignoreCase) {
        int pos = s.length() - suffix.length();
        return s.regionMatches(ignoreCase, pos, suffix, 0, suffix.length());
    }

    public static boolean endsWith(String s, String suffix) {
        return s.endsWith(suffix);
    }

    public static int indexOf(String s, String c, int start) {
        return s.indexOf(c, start);
    }

    public static int indexOf(String s, String c, int start, boolean ignoreCase) {
        if (ignoreCase) {
            int ls = s.length();
            int lc = c.length();
            int lc1 = lc - 1;
            int le = ls - lc;
            if (lc == 0 || start > le) {
                return -1;
            }
            char c0 = c.charAt(0);
            for (int ns = start < 0 ? 0 : start; ns <= le; ++ns) {
                if (!Strings.equals(s.charAt(ns), c0, ignoreCase) || !s.regionMatches(ignoreCase, ns + 1, c, 1, lc1)) continue;
                return ns;
            }
            return -1;
        }
        return s.indexOf(c, start);
    }

    public static int indexOf(String s, String c, boolean ignoreCase) {
        return Strings.indexOf(s, c, 0, ignoreCase);
    }

    public static int indexOf(String s, String c) {
        return s.indexOf(c);
    }

    public static int indexOf(String s, char c) {
        return s.indexOf(c);
    }

    public static int indexOf(String s, char c, int start, boolean ignoreCase) {
        if (ignoreCase) {
            int ls = s.length();
            if (start < 0) {
                start = 0;
            }
            if (start >= ls) {
                return -1;
            }
            for (int n = start; n < ls; ++n) {
                if (!Strings.equals(s.charAt(n), c, ignoreCase)) continue;
                return n;
            }
            return -1;
        }
        return s.indexOf(c, start);
    }

    public static int indexOf(String s, char c, boolean ignoreCase) {
        return Strings.indexOf(s, c, 0, ignoreCase);
    }

    public static int indexOf(String s, char c, int start) {
        return s.indexOf(c, start);
    }

    public static int indexOfAnyOf(String s, String c, int start) {
        int ls;
        int lc = c.length();
        int pos = ls = s.length();
        for (int n = 0; n < lc; ++n) {
            char ch = c.charAt(n);
            int i = s.indexOf(ch, start);
            if (i < 0 || i >= pos) continue;
            pos = i;
        }
        return pos < ls ? pos : -1;
    }

    public static int indexOfAnyOf(String s, String c, int start, boolean ignoreCase) {
        int ls;
        int lc = c.length();
        int pos = ls = s.length();
        for (int n = 0; n < lc; ++n) {
            char ch = c.charAt(n);
            int i = Strings.indexOf(s, ch, start, ignoreCase);
            if (i < 0 || i >= pos) continue;
            pos = i;
        }
        return pos < ls ? pos : -1;
    }

    public static int indexOfAnyOf(String s, String c, boolean ignoreCase) {
        return Strings.indexOfAnyOf(s, c, 0, ignoreCase);
    }

    public static int indexOfAnyOf(String s, String c) {
        return Strings.indexOfAnyOf(s, c, 0);
    }

    public static int indexOfAnyBut(String s, String c, int start, boolean ignoreCase) {
        int ls = s.length();
        int pos = -1;
        for (int n = start; n < ls; ++n) {
            char ch = s.charAt(n);
            if (Strings.indexOf(c, ch, ignoreCase) >= 0) continue;
            pos = n;
            break;
        }
        return pos;
    }

    public static int indexOfAnyBut(String s, String c, boolean ignoreCase) {
        return Strings.indexOfAnyBut(s, c, 0, ignoreCase);
    }

    public static int indexOfAnyBut(String s, String c, int start) {
        return Strings.indexOfAnyBut(s, c, start, false);
    }

    public static int indexOfAnyBut(String s, String c) {
        return Strings.indexOfAnyBut(s, c, 0, false);
    }

    public static int occurrencesOf(String s, String c, int start, boolean ignoreCase) {
        int lc = c.length();
        int n = 0;
        if (start > s.length() - lc) {
            return 0;
        }
        if (lc > 0) {
            int i;
            while ((i = Strings.indexOf(s, c, start, ignoreCase)) >= 0) {
                ++n;
                start = i + lc;
            }
        }
        return n;
    }

    public static int occurrencesOf(String s, String c, boolean ignoreCase) {
        return Strings.occurrencesOf(s, c, 0, ignoreCase);
    }

    public static int occurrencesOf(String s, String c, int start) {
        return Strings.occurrencesOf(s, c, start, false);
    }

    public static int occurrencesOf(String s, String c) {
        return Strings.occurrencesOf(s, c, 0, false);
    }

    public static int lastIndexOf(String s, String c, int start, boolean ignoreCase) {
        if (ignoreCase) {
            int ls = s.length();
            int lc = c.length();
            int lc1 = lc - 1;
            int le = ls - lc;
            if (lc == 0 || start < 0) {
                return -1;
            }
            char c0 = c.charAt(0);
            for (int ns = start >= le ? le : start; ns >= 0; --ns) {
                if (!Strings.equals(s.charAt(ns), c0, ignoreCase) || !s.regionMatches(ignoreCase, ns + 1, c, 1, lc1)) continue;
                return ns;
            }
            return -1;
        }
        return s.lastIndexOf(c, start);
    }

    public static int lastIndexOf(String s, String c, boolean ignoreCase) {
        return Strings.lastIndexOf(s, c, Integer.MAX_VALUE, ignoreCase);
    }

    public static int lastIndexOf(String s, String c, int start) {
        return s.lastIndexOf(c, start);
    }

    public static int lastIndexOf(String s, String c) {
        return s.lastIndexOf(c);
    }

    public static int lastIndexOf(String s, char c, int start, boolean ignoreCase) {
        if (ignoreCase) {
            int ls = s.length();
            if (start < 0) {
                return -1;
            }
            if (start >= ls) {
                start = ls - 1;
            }
            for (int n = start; n >= 0; --n) {
                if (!Strings.equals(s.charAt(n), c, ignoreCase)) continue;
                return n;
            }
            return -1;
        }
        return s.lastIndexOf(c, start);
    }

    public static int lastIndexOf(String s, char c, int start) {
        return s.lastIndexOf(c, start);
    }

    public static int lastIndexOf(String s, char c) {
        return s.lastIndexOf(c);
    }

    public static int lastIndexOfAnyBut(String s, String c, int start, boolean ignoreCase) {
        int ls = s.length() - 1;
        int pos = -1;
        for (int n = start = start < ls ? start : ls; n >= 0; --n) {
            char ch = s.charAt(n);
            if (Strings.indexOf(c, ch, ignoreCase) >= 0) continue;
            pos = n;
            break;
        }
        return pos;
    }

    public static int lastIndexOfAnyBut(String s, String c, int start) {
        return Strings.lastIndexOfAnyBut(s, c, start, false);
    }

    public static int lastIndexOfAnyBut(String s, String c) {
        return Strings.lastIndexOfAnyBut(s, c, Integer.MAX_VALUE, false);
    }

    public static int lastIndexOfAnyOf(String s, String c, int start, boolean ignoreCase) {
        int lc = c.length();
        int ls = s.length();
        int pos = -1;
        for (int n = 0; n < lc; ++n) {
            char ch = c.charAt(n);
            int i = Strings.lastIndexOf(s, ch, start, ignoreCase);
            if (i < 0 || i <= pos) continue;
            pos = i;
        }
        return pos;
    }

    public static int lastIndexOfAnyOf(String s, String c, int start) {
        return Strings.lastIndexOfAnyOf(s, c, start, false);
    }

    public static int lastIndexOfAnyOf(String s, String c) {
        return Strings.lastIndexOfAnyOf(s, c, Integer.MAX_VALUE, false);
    }

    public static String stripLeading(String s, String c, boolean ignoreCase) {
        int pos;
        int ls = s.length();
        for (pos = 0; pos < ls && Strings.indexOf(c, s.charAt(pos), ignoreCase) >= 0; ++pos) {
        }
        return s.substring(pos);
    }

    public static String stripLeading(String s, String c) {
        return Strings.stripLeading(s, c, false);
    }

    public static String stripLeading(String s, char c, boolean ignoreCase) {
        int pos;
        int ls = s.length();
        for (pos = 0; pos < ls && Strings.equals(s.charAt(pos), c, ignoreCase); ++pos) {
        }
        return s.substring(pos);
    }

    public static String stripLeading(String s, char c) {
        return Strings.stripLeading(s, c, false);
    }

    public static String stripLeadingBlanks(String s) {
        int pos;
        int ls = s.length();
        for (pos = 0; pos < ls && Character.isWhitespace(s.charAt(pos)); ++pos) {
        }
        return s.substring(pos);
    }

    public static String stripTrailing(String s, String c, boolean ignoreCase) {
        int pos;
        for (pos = s.length() - 1; pos >= 0 && Strings.indexOf(c, s.charAt(pos), ignoreCase) >= 0; --pos) {
        }
        return s.substring(0, pos + 1);
    }

    public static String stripTrailing(String s, String c) {
        return Strings.stripTrailing(s, c, false);
    }

    public static String stripTrailing(String s, char c, boolean ignoreCase) {
        int pos;
        for (pos = s.length() - 1; pos >= 0 && Strings.equals(s.charAt(pos), c, ignoreCase); --pos) {
        }
        return s.substring(0, pos + 1);
    }

    public static String stripTrailing(String s, char c) {
        return Strings.stripTrailing(s, c, false);
    }

    public static String stripTrailingBlanks(String s) {
        int pos;
        for (pos = s.length() - 1; pos >= 0 && Character.isWhitespace(s.charAt(pos)); --pos) {
        }
        return s.substring(0, pos + 1);
    }

    public static String strip(String s, String c, boolean ignoreCase) {
        String s1 = Strings.stripLeading(s, c, ignoreCase);
        return Strings.stripTrailing(s1, c, ignoreCase);
    }

    public static String strip(String s, String c) {
        return Strings.strip(s, c, false);
    }

    public static String strip(String s, char c, boolean ignoreCase) {
        String s1 = Strings.stripLeading(s, c, ignoreCase);
        return Strings.stripTrailing(s1, c, ignoreCase);
    }

    public static String strip(String s, char c) {
        return Strings.strip(s, c, false);
    }

    public static String stripBlanks(String s) {
        return s.trim();
    }

    public static String center(String s, int len, char pad) {
        int ls = s.length();
        if (len < 1) {
            return "";
        }
        char[] buf = new char[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = pad;
        }
        if (len > ls) {
            int start = (len - ls) / 2;
            s.getChars(0, ls, buf, start);
        } else {
            int start = (ls - len) / 2;
            s.getChars(start, start + len, buf, 0);
        }
        return new String(buf);
    }

    public static String center(String s, int len) {
        return Strings.center(s, len, ' ');
    }

    public static String change(String s, String oldp, String newp, int start, int maxChanges, boolean ignoreCase) {
        int fpos;
        int ls;
        int lo = oldp.length();
        int ln = newp.length();
        int newlen = ls = s.length();
        int nchg = 0;
        if (lo == 0 || start >= ls) {
            return s;
        }
        if (start < 0) {
            start = 0;
        }
        int lastPos = start;
        if (ln > lo) {
            int n = Strings.occurrencesOf(s, oldp, start, ignoreCase);
            newlen = ls + n * (ln - lo);
        }
        char[] buf = new char[newlen];
        s.getChars(0, start, buf, 0);
        int lastDest = start;
        while ((fpos = Strings.indexOf(s, oldp, lastPos, ignoreCase)) >= 0 && nchg++ < maxChanges) {
            s.getChars(lastPos, fpos, buf, lastDest);
            newp.getChars(0, ln, buf, lastDest += fpos - lastPos);
            lastPos = fpos + lo;
            lastDest += ln;
        }
        s.getChars(lastPos, ls, buf, lastDest);
        return new String(buf, 0, lastDest - lastPos + ls);
    }

    public static String change(String s, String oldp, String newp, int start, boolean ignoreCase) {
        return Strings.change(s, oldp, newp, start, Integer.MAX_VALUE, ignoreCase);
    }

    public static String change(String s, String oldp, String newp, int start, int maxChanges) {
        return Strings.change(s, oldp, newp, start, maxChanges, false);
    }

    public static String change(String s, String oldp, String newp, int start) {
        return Strings.change(s, oldp, newp, start, Integer.MAX_VALUE);
    }

    public static String change(String s, String oldp, String newp, boolean ignoreCase) {
        return Strings.change(s, oldp, newp, 0, Integer.MAX_VALUE, ignoreCase);
    }

    public static String change(String s, String oldp, String newp) {
        return Strings.change(s, oldp, newp, 0, Integer.MAX_VALUE, false);
    }

    public static String change(String s, char oldc, char newc, int start, int maxChanges, boolean ignoreCase) {
        int fpos;
        int ls = s.length();
        int nchg = 0;
        if (start >= ls) {
            return s;
        }
        if (start < 0) {
            start = 0;
        }
        int lastPos = start;
        char[] buf = new char[ls];
        s.getChars(0, start, buf, 0);
        int lastDest = start;
        while ((fpos = Strings.indexOf(s, oldc, lastPos, ignoreCase)) >= 0 && nchg++ < maxChanges) {
            s.getChars(lastPos, fpos, buf, lastPos);
            buf[fpos] = newc;
            lastPos = fpos + 1;
        }
        s.getChars(lastPos, ls, buf, lastPos);
        return new String(buf, 0, ls);
    }

    public static String change(String s, char oldc, char newc, int start, int maxChanges) {
        return Strings.change(s, oldc, newc, start, maxChanges, false);
    }

    public static String change(String s, char oldc, char newc, int start, boolean ignoreCase) {
        return Strings.change(s, oldc, newc, start, Integer.MAX_VALUE, ignoreCase);
    }

    public static String change(String s, char oldc, char newc, int start) {
        return Strings.change(s, oldc, newc, start, Integer.MAX_VALUE, false);
    }

    public static String change(String s, char oldc, char newc) {
        return s.replace(oldc, newc);
    }

    public static String copies(String s, int nCopies) {
        int ls = s.length();
        if (nCopies < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(ls * nCopies);
        for (int n = 0; n < nCopies; ++n) {
            buf.append(s);
        }
        return buf.toString();
    }

    public static String insert(String s, String ins, int start, char pad) {
        int sPos;
        int ls = s.length();
        int li = ins.length();
        if (start < 0) {
            return "";
        }
        int newlen = start > ls ? li + start : ls + li;
        int sRest = sPos = start > ls ? ls : start;
        char[] buf = new char[newlen];
        s.getChars(0, sPos, buf, 0);
        while (sPos < start) {
            buf[sPos++] = pad;
        }
        ins.getChars(0, li, buf, sPos);
        s.getChars(sRest, ls, buf, sPos + li);
        return new String(buf);
    }

    public static String insert(String s, String ins, int start) {
        return Strings.insert(s, ins, start, ' ');
    }

    public static String leftJustify(String s, int len, char pad) {
        int ln;
        int ls = s.length();
        int n = ln = len < ls ? len : ls;
        if (len < 1) {
            return "";
        }
        char[] buf = new char[len];
        s.getChars(0, ln, buf, 0);
        while (ln < len) {
            buf[ln++] = pad;
        }
        return new String(buf);
    }

    public static String leftJustify(String s, int len) {
        return Strings.leftJustify(s, len, ' ');
    }

    public static String rightJustify(String s, int len, char pad) {
        int ls = s.length();
        if (len < 1) {
            return "";
        }
        char[] buf = new char[len];
        if (len > ls) {
            int lp = len - ls;
            s.getChars(0, ls, buf, lp);
            while (lp > 0) {
                buf[--lp] = pad;
            }
        } else {
            int lp = ls - len;
            s.getChars(lp, ls, buf, 0);
        }
        return new String(buf);
    }

    public static String rightJustify(String s, int len) {
        return Strings.rightJustify(s, len, ' ');
    }

    public static String toLowerCase(String s) {
        return s.toLowerCase();
    }

    public static String toLowerCase(String s, Locale locale) {
        return s.toLowerCase(locale);
    }

    public static String toUpperCase(String s) {
        return s.toUpperCase();
    }

    public static String toUpperCase(String s, Locale locale) {
        return s.toUpperCase(locale);
    }

    public static String toTitleCase(String s) {
        int ls = s.length();
        char[] buf = new char[ls];
        s.getChars(0, ls, buf, 0);
        for (int i = 0; i < ls; ++i) {
            Character.toTitleCase(buf[i]);
        }
        return new String(buf);
    }

    public static String overlayWith(String s, String o, int start, char pad) {
        int ls = s.length();
        int lo = o.length();
        if (start < 0) {
            return "";
        }
        int ln = start + lo;
        int pos = start >= ls ? ls : start;
        int newlen = ln < ls ? ls : ln;
        char[] buf = new char[newlen];
        s.getChars(0, pos, buf, 0);
        for (int i = ls; i < start; ++i) {
            buf[i] = pad;
        }
        o.getChars(0, lo, buf, start);
        if (ln < ls) {
            s.getChars(ln, ls, buf, ln);
        }
        return new String(buf);
    }

    public static String overlayWith(String s, String o, int start) {
        return Strings.overlayWith(s, o, start, ' ');
    }

    public static String remove(String s, int start, int numChars) {
        int ls = s.length();
        if (start >= ls || start < 0 || numChars < 1) {
            return s;
        }
        if (start > ls - numChars) {
            numChars = ls - start;
        }
        int newlen = ls - numChars;
        char[] buf = new char[newlen];
        s.getChars(0, start, buf, 0);
        s.getChars(start + numChars, ls, buf, start);
        return new String(buf);
    }

    public static String substring(String s, int start, int len, char pad) {
        int ls = s.length();
        if (start < 0 || start >= ls) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        if (len > ls - start) {
            char[] buf = new char[len];
            s.getChars(start, ls, buf, 0);
            for (int i = ls - start; i < len; ++i) {
                buf[i] = pad;
            }
            return new String(buf);
        }
        return s.substring(start, start + len);
    }

    public static String substring(String s, int start, int len) {
        return Strings.substring(s, start, len, ' ');
    }

    public static String substring(String s, int start) {
        return s.substring(start);
    }

    public static String reverse(String s) {
        StringBuffer buf = new StringBuffer(s);
        buf.reverse();
        return buf.toString();
    }

    public static String translate(String s, String setin, String setout, char pad, boolean ignoreCase) {
        int ls = s.length();
        int lout = setout.length();
        char[] buf = new char[ls];
        s.getChars(0, ls, buf, 0);
        int pos = 0;
        while ((pos = Strings.indexOfAnyOf(s, setin, pos, ignoreCase)) >= 0) {
            int n = Strings.indexOf(setin, buf[pos], ignoreCase);
            buf[pos] = n >= lout ? pad : setout.charAt(n);
            ++pos;
        }
        return new String(buf);
    }

    public static String translate(String s, String setin, String setout, char pad) {
        return Strings.translate(s, setin, setout, pad, false);
    }

    public static String translate(String s, String setin, String setout, boolean ignoreCase) {
        return Strings.translate(s, setin, setout, ' ', ignoreCase);
    }

    public static String translate(String s, String setin, String setout) {
        return Strings.translate(s, setin, setout, ' ');
    }

    public static String xRange(char start, char end) {
        if (start <= end) {
            int l = end - start + 1;
            char[] buf = new char[l];
            for (int i = 0; i < l; ++i) {
                buf[i] = (char)(start + i);
            }
            return new String(buf);
        }
        return "";
    }

    public static boolean contains(String s, String search, boolean ignoreCase) {
        return Strings.indexOf(s, search, ignoreCase) >= 0;
    }

    public static boolean contains(String s, String search) {
        return s.indexOf(search) >= 0;
    }

    public static boolean isAbbreviationOf(String s, String full, int minLength, boolean ignoreCase) {
        int ls = s.length();
        if (minLength > ls || minLength < 0) {
            return false;
        }
        if (minLength == 0) {
            minLength = ls;
        }
        return s.regionMatches(ignoreCase, 0, full, 0, minLength);
    }

    public static boolean isAbbreviationOf(String s, String full, int minLength) {
        return Strings.isAbbreviationOf(s, full, minLength, false);
    }

    public static boolean isAbbreviationOf(String s, String full, boolean ignoreCase) {
        return s.regionMatches(ignoreCase, 0, full, 0, s.length());
    }

    public static boolean isLike(String s, String pattern, int start, char wAnySeq, char wAnyChar, boolean ignoreCase) {
        int ls = s.length();
        int lp = pattern.length();
        if (lp == 0) {
            return false;
        }
        char p = ' ';
        int ns = start;
        int np = 0;
        int startp = -1;
        int starts = 0;
        while (np <= lp && ns <= ls) {
            if (np < lp) {
                p = pattern.charAt(np);
                if (p == wAnySeq) {
                    startp = np++;
                    starts = ns;
                    continue;
                }
                if (ns < ls) {
                    if (p == wAnyChar || Strings.equals(s.charAt(ns), pattern.charAt(np), ignoreCase)) {
                        ++np;
                        ++ns;
                        continue;
                    }
                    if (startp < 0) {
                        return false;
                    }
                    np = startp;
                    ns = ++starts;
                    continue;
                }
                return false;
            }
            if (p == wAnySeq) {
                return true;
            }
            if (ns < ls && startp >= 0) {
                np = startp + 1;
                ns = ++starts;
                continue;
            }
            return ns >= ls;
        }
        return true;
    }

    public static boolean isLike(String s, String pattern, int start, boolean ignoreCase) {
        return Strings.isLike(s, pattern, start, '*', '?', ignoreCase);
    }

    public static boolean isLike(String s, String pattern, int start) {
        return Strings.isLike(s, pattern, start, '*', '?', false);
    }

    public static boolean isLike(String s, String pattern) {
        return Strings.isLike(s, pattern, 0, '*', '?', false);
    }

    public static int indexOfWord(String s, int wordNum) {
        int ls = s.length();
        if (wordNum < 0) {
            return -1;
        }
        ++wordNum;
        int pos = 0;
        while (pos < ls) {
            while (pos < ls && Character.isWhitespace(s.charAt(pos))) {
                ++pos;
            }
            if (pos >= ls) continue;
            if (--wordNum == 0) break;
            ++pos;
            while (pos < ls && !Character.isWhitespace(s.charAt(pos))) {
                ++pos;
            }
            ++pos;
        }
        if (wordNum > 0) {
            pos = -1;
        }
        return pos;
    }

    public static int indexOfPhrase(String s, String p, int startWord, boolean ignoreCase) {
        WordEntry e = Strings.wordEntryOfPhrase(s, p, startWord, ignoreCase);
        if (e == null) {
            return -1;
        }
        return e.start;
    }

    public static int indexOfPhrase(String s, String p, int startWord) {
        return Strings.indexOfPhrase(s, p, startWord, false);
    }

    public static int numWords(String s) {
        int ls = s.length();
        int wordNum = 0;
        for (int pos = 0; pos < ls; ++pos) {
            while (pos < ls && Character.isWhitespace(s.charAt(pos))) {
                ++pos;
            }
            if (pos++ < ls) {
                ++wordNum;
            }
            while (pos < ls && !Character.isWhitespace(s.charAt(pos))) {
                ++pos;
            }
        }
        return wordNum;
    }

    public static String removeWords(String s, int startWord, int numWords) {
        if (startWord < 0 || numWords <= 0) {
            return s;
        }
        int startPos = Strings.indexOfWord(s, startWord);
        if (startPos >= 0) {
            int lastPos = Strings.indexOfWord(s.substring(startPos), numWords);
            if (lastPos >= 0) {
                return Strings.remove(s, startPos, lastPos);
            }
            return s.substring(0, startPos);
        }
        return s;
    }

    public static String wordSpace(String s, int spaces) {
        int i;
        int ls = s.length();
        if (spaces < 0) {
            return s;
        }
        Vector wordList = Strings.buildWordList(s, ls);
        int nWords = wordList.size();
        if (nWords == 0) {
            return "";
        }
        int newsize = 0;
        for (i = 0; i < nWords; ++i) {
            WordEntry e = (WordEntry)wordList.elementAt(i);
            newsize += e.len;
        }
        char[] buf = new char[newsize + (nWords - 1) * spaces];
        int pos = 0;
        for (i = 0; i < nWords; ++i) {
            WordEntry e = (WordEntry)wordList.elementAt(i);
            s.getChars(e.start, e.start + e.len, buf, pos);
            pos += e.len;
            if (i >= nWords - 1) continue;
            for (int j = 0; j < spaces; ++j) {
                buf[pos++] = 32;
            }
        }
        return new String(buf);
    }

    public static String word(String s, int wordNum) {
        int ls = s.length();
        if (wordNum < 0) {
            return "";
        }
        int startPos = Strings.indexOfWord(s, wordNum);
        if (startPos >= 0) {
            int pos;
            for (pos = startPos; pos < ls && !Character.isWhitespace(s.charAt(pos)); ++pos) {
            }
            return s.substring(startPos, pos);
        }
        return "";
    }

    public static int wordIndexOfPhrase(String s, String p, int startWord, boolean ignoreCase) {
        WordEntry e = Strings.wordEntryOfPhrase(s, p, startWord, ignoreCase);
        if (e == null) {
            return -1;
        }
        return e.wordNum;
    }

    public static int wordIndexOfPhrase(String s, String p, int startWord) {
        return Strings.wordIndexOfPhrase(s, p, startWord, false);
    }

    public static String subWords(String s, int startWord, int numWords) {
        int ls = s.length();
        if (startWord < 0 || numWords <= 0) {
            return "";
        }
        int startPos = Strings.indexOfWord(s, startWord);
        if (startPos >= 0) {
            int lastPos = Strings.indexOfWord(s.substring(startPos), numWords - 1);
            if (lastPos >= 0) {
                int pos;
                for (pos = startPos + lastPos; pos < ls && !Character.isWhitespace(s.charAt(pos)); ++pos) {
                }
                return s.substring(startPos, pos);
            }
            return Strings.stripTrailingBlanks(s.substring(startPos));
        }
        return "";
    }

    public static String[] split(String s) {
        return Strings.split(s, Integer.MAX_VALUE);
    }

    public static String[] split(String s, int limit) {
        String[] splitWords = new String[Math.min(limit, Strings.numWords(s))];
        for (int i = 0; i < splitWords.length; ++i) {
            splitWords[i] = Strings.subWords(s, i, 1);
        }
        return splitWords;
    }

    public static boolean toBoolean(String s) {
        return Boolean.valueOf(s);
    }

    public static byte toByte(String s) throws NumberFormatException {
        return Byte.valueOf(s);
    }

    public static byte toByte(String s, int radix) throws NumberFormatException {
        return Byte.valueOf(s, radix);
    }

    public static short toShort(String s, int radix) throws NumberFormatException {
        return Short.valueOf(s, radix);
    }

    public static short toShort(String s) throws NumberFormatException {
        return Short.valueOf(s);
    }

    public static int toInt(String s) throws NumberFormatException {
        return Integer.valueOf(s);
    }

    public static int toInt(String s, int radix) throws NumberFormatException {
        return Integer.valueOf(s, radix);
    }

    public static long toLong(String s) throws NumberFormatException {
        return Long.valueOf(s);
    }

    public static long toLong(String s, int radix) throws NumberFormatException {
        return Long.valueOf(s, radix);
    }

    public static float toFloat(String s) throws NumberFormatException {
        return Float.valueOf(s).floatValue();
    }

    public static double toDouble(String s) throws NumberFormatException {
        return Double.valueOf(s);
    }

    public static boolean isDigit(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentifierIgnorable(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isIdentifierIgnorable(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isISOControl(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isISOControl(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaIdentifier(String s) {
        int ls = s.length();
        if (ls == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < ls; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetter(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isLetter(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetterOrDigit(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isLetterOrDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isLowerCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSpaceChar(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isSpaceChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isTitleCase(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isTitleCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnicodeIdentifier(String s) {
        int ls = s.length();
        if (ls == 0 || !Character.isUnicodeIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < ls; ++i) {
            if (Character.isUnicodeIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isUpperCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static Vector buildWordList(String s, int ls) {
        int start = 0;
        int end = 0;
        int words = 0;
        Vector<WordEntry> wordList = new Vector<WordEntry>();
        int pos = 0;
        while (pos < ls) {
            while (pos < ls && Character.isWhitespace(s.charAt(pos))) {
                ++pos;
            }
            start = pos++;
            if (pos > ls) continue;
            while (pos < ls && !Character.isWhitespace(s.charAt(pos))) {
                ++pos;
            }
            end = pos++;
            WordEntry e = new WordEntry(start, end - start, words++);
            wordList.addElement(e);
        }
        return wordList;
    }

    private static WordEntry wordEntryOfPhrase(String s, String p, int startWord, boolean ignoreCase) {
        int ls = s.length();
        int lp = p.length();
        if (ls == 0 || lp == 0) {
            return null;
        }
        if (startWord < 0) {
            startWord = 0;
        }
        Vector sList = Strings.buildWordList(s, ls);
        Vector pList = Strings.buildWordList(p, lp);
        int ns = sList.size();
        int np = pList.size();
        int si = startWord;
        int pi = 0;
        int lastsi = startWord;
        int start = -1;
        while (si < ns && pi < np) {
            WordEntry es = (WordEntry)sList.elementAt(si);
            WordEntry ep = (WordEntry)pList.elementAt(pi);
            if (s.regionMatches(ignoreCase, es.start, p, ep.start, ep.len)) {
                ++si;
                ++pi;
                continue;
            }
            si = ++lastsi;
            pi = 0;
        }
        if (pi == np) {
            return (WordEntry)sList.elementAt(lastsi);
        }
        return null;
    }
}

