## ----LoadFunctions, echo=FALSE, message=FALSE, warning=FALSE, results='hide'----
library(knitr)
opts_chunk$set(error = FALSE)
library(EventPointer)

## ----style, echo = FALSE, results = 'asis'---------------------------------
##BiocStyle::markdown()

## ---- eval=FALSE-----------------------------------------------------------
#  source("http://www.bioconductor.org/biocLite.R")
#  biocLite("EventPointer")

## ----CDFGTF, eval=TRUE, warning=FALSE, collapse=TRUE-----------------------

# Set input variables
   PathFiles<-system.file("extdata",package="EventPointer")
   DONSON_GTF<-paste(PathFiles,"/DONSON.gtf",sep="")
   PSRProbes<-paste(PathFiles,"/PSR_Probes.txt",sep="")
   JunctionProbes<-paste(PathFiles,"/Junction_Probes.txt",sep="")
   Directory<-tempdir()
   array<-"HTA-2_0"

# Run the function

   CDFfromGTF(input="AffyGTF",inputFile=DONSON_GTF,
              PSR=PSRProbes,Junc=JunctionProbes,
              PathCDF=Directory,microarray=array)


## ----aroma, eval=FALSE-----------------------------------------------------
#  
#  # Simple example of Aroma.Affymetrix Preprocessing Pipeline
#  
#  verbose <- Arguments$getVerbose(-8);
#  timestampOn(verbose);
#  projectName <- "Experiment"
#  cdfGFile <- "EP_HTA-2_0,r"
#  cdfG <- AffymetrixCdfFile$byChipType(cdfGFile)
#  cs <- AffymetrixCelSet$byName(projectName, cdf=cdfG)
#  bc <- NormExpBackgroundCorrection(cs, method="mle", tag=c("*","r11"));
#  csBC <- process(bc,verbose=verbose,ram=20);
#  qn <- QuantileNormalization(csBC, typesToUpdate="pm");
#  csN <- process(qn,verbose=verbose,ram=20);
#  plmEx <- ExonRmaPlm(csN, mergeGroups=FALSE)
#  fit(plmEx, verbose=verbose)
#  cesEx <- getChipEffectSet(plmEx)
#  ExFit <- extractDataFrame(cesEx, addNames = TRUE)

## ----EP_arrays, eval=TRUE--------------------------------------------------

   data(ArraysData)

   Dmatrix<-matrix(c(1,1,1,1,0,0,1,1),nrow=4,ncol=2,byrow=FALSE)
   Cmatrix<-t(t(c(0,1)))
   EventsFound<-paste(system.file("extdata",package="EventPointer"),"/EventsFound.txt",sep="")
   
   Events<-EventPointer(Design=Dmatrix,
                      Contrast=Cmatrix,
                      ExFit=ArraysData,
                      Eventstxt=EventsFound,
                      Filter=FALSE,
                      Qn=0.25,
                      Statistic="LogFC",
                      PSI=TRUE)

## ----EP_Arrays_Res_Table, echo=FALSE---------------------------------------
kable(Events[1:5,],digits=5,row.names=TRUE,align="c",caption = "Table 1: EventPointer Arrays results")

## ----Arrays_IGV, eval=TRUE, collapse=TRUE----------------------------------

# Set Input Variables
  
   DONSON_GTF<-paste(PathFiles,"/DONSON.gtf",sep="")
   PSRProbes<-paste(PathFiles,"/PSR_Probes.txt",sep="")
   JunctionProbes<-paste(PathFiles,"/Junction_Probes.txt",sep="")
   Directory<-tempdir()
   EventsFound<-paste(system.file("extdata",package="EventPointer"),"/EventsFound.txt",sep="")
   array<-"HTA-2_0"

                      
# Generate Visualization files  

 EventPointer_IGV(Events[1,,drop=FALSE],"AffyGTF",DONSON_GTF,PSRProbes,JunctionProbes,Directory,EventsFound,array)



## ----PrepareBam, eval=FALSE, collapse=TRUE---------------------------------
#  # Obtain the samples and directory for .bam files
#  
#  # the object si contains example sample information from the SGSeq R package
#  # use ?si to see the corresponding documentation
#  
#     BamInfo<-si
#     Samples<-BamInfo[,2]
#     PathToSamples <- system.file("extdata/bams", package = "SGSeq")
#     PathToGTF<-paste(system.file("extdata",package="EventPointer"),"/FBXO31.gtf",sep="")
#  
#    # Run PrepareBam function
#     SG_RNASeq<-PrepareBam_EP(Samples=Samples,
#                              SamplePath=PathToSamples,
#                              Ref_Transc="GTF",
#                              fileTransc=PathToGTF,
#                              cores=1)

## ----EventDetection, eval=TRUE---------------------------------------------
  # Run EventDetection function
   data(SG_RNASeq)
   TxtPath<-tempdir()
   AllEvents_RNASeq<-EventDetection(SG_RNASeq,cores=1,Path=TxtPath)

## ----ListofLists, eval=FALSE-----------------------------------------------
#  Events[[i]][[j]]

## ----EP_RNASeq, eval=TRUE--------------------------------------------------
   Dmatrix<-matrix(c(1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1),ncol=2,byrow=FALSE)
   Cmatrix<-t(t(c(0,1)))
   Events <- EventPointer_RNASeq(AllEvents_RNASeq,Dmatrix,Cmatrix,Statistic="LogFC",PSI=TRUE)

## ----EP_RNASeq_Res_Table, echo=FALSE---------------------------------------
kable(Events[1:5,],digits=5,row.names=TRUE,align="c",caption = "Table 2: EventPointer RNASeq results")

## ----RNAS_IGV, eval=TRUE, collapse=TRUE------------------------------------

   # IGV Visualization
   EventsTxt<-paste(system.file("extdata",package="EventPointer"),"/EventsFound_RNASeq.txt",sep="")
   PathGTF<-tempdir()
   EventPointer_RNASeq_IGV(Events,SG_RNASeq,EventsTxt,PathGTF)

## ----PSI_ADV, eval=TRUE, collapse=TRUE-------------------------------------

# Microarrays
data(ArraysData)
PSI_Arrays<-EventPointer:::getPSI(ArraysData)

# RNASeq
data(AllEvents_RNASeq)
PSI_RNASeq<-EventPointer:::getPSI_RNASeq(AllEvents_RNASeq)

## --------------------------------------------------------------------------
sessionInfo()

