## ----setup, include=FALSE-----------------------------------------------------
library(knitr)
opts_chunk$set(size="scriptsize")
if (!dir.exists("~/mydata")) dir.create("~/mydata")
options(width=80)
library(Matrix)
library(DelayedArray)
library(HDF5Array)
library(SummarizedExperiment)
library(airway)
library(pryr)

## ----airway-------------------------------------------------------------------
library(airway)
data(airway)
m <- unname(assay(airway))
dim(m)
typeof(m)

## ----airway2------------------------------------------------------------------
head(m, n=4)
tail(m, n=4)
sum(m != 0) / length(m)

## ----object_size--------------------------------------------------------------
library(pryr)  # for object_size()
object_size(m)

library(Matrix)
object_size(as(m, "dgCMatrix"))

library(DelayedArray)
object_size(as(m, "RleMatrix"))
object_size(as(t(m), "RleMatrix"))

library(HDF5Array)
object_size(as(m, "HDF5Matrix"))

## ----M------------------------------------------------------------------------
M <- as(m, "HDF5Matrix")
M

## ----M2-----------------------------------------------------------------------
M2 <- M[10:12, 1:5]
M2

## ----seed_of_M2---------------------------------------------------------------
seed(M2)

## -----------------------------------------------------------------------------
M3 <- t(M2)
M3

## -----------------------------------------------------------------------------
seed(M3)

## -----------------------------------------------------------------------------
M4 <- cbind(M3, M[1:5, 6:8])
M4

## -----------------------------------------------------------------------------
seed(M4)

## -----------------------------------------------------------------------------
M5 <- M == 0
M5

## -----------------------------------------------------------------------------
seed(M5)

## -----------------------------------------------------------------------------
M6 <- round(M[11:14, ] / M[1:4, ], digits=3)
M6

## -----------------------------------------------------------------------------
seed(M6)

## -----------------------------------------------------------------------------
M6a <- as(M6, "HDF5Array")
M6a

## -----------------------------------------------------------------------------
seed(M6a)

## -----------------------------------------------------------------------------
M6b <- as(M6, "RleArray")
M6b

## -----------------------------------------------------------------------------
seed(M6b)

## -----------------------------------------------------------------------------
setHDF5DumpFile("~/mydata/M6c.h5")
setHDF5DumpName("M6c")
M6c <- as(M6, "HDF5Array")

## -----------------------------------------------------------------------------
seed(M6c)
h5ls("~/mydata/M6c.h5")

## -----------------------------------------------------------------------------
showHDF5DumpLog()

## -----------------------------------------------------------------------------
DelayedArray:::set_verbose_block_processing(TRUE)
colSums(M)

## -----------------------------------------------------------------------------
getOption("DelayedArray.block.size")
options(DelayedArray.block.size=1e6)
colSums(M)

## ----cleanup, include=FALSE---------------------------------------------------
unlink("~/mydata", recursive=TRUE, force=TRUE)

