## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, results = "markup", message = FALSE, warning = FALSE)

## ------------------------------------------------------------------------
library(flowWorkspace)
library(CytoML)
fcsFiles <- list.files(pattern = "CytoTrol", system.file("extdata", package = "flowWorkspaceData"), full.names = TRUE)
xmlfile <- system.file("extdata/cytotrol_tcell_cytobank.xml", package = "CytoML")

## ---- eval=FALSE---------------------------------------------------------
#  gs <- cytobank2GatingSet(xmlfile, fcsFiles)

## ------------------------------------------------------------------------
g <- read.gatingML.cytobank(xmlfile)
class(g)
g

## ------------------------------------------------------------------------
getNodes(g)
getParent(g, "GateSet_722318")
getChildren(g, "GateSet_722318")


## ----fig.width=4,fig.height=4--------------------------------------------
plot(g)

## ------------------------------------------------------------------------
fs <- read.ncdfFlowSet(fcsFiles)
gs <- GatingSet(fs)

## ------------------------------------------------------------------------
gs <- compensate(gs, g)
## Extract the transformation from graphGML
trans <- getTransformations(g)
trans
## Transform the `GatingSet`
gs <- transform(gs, trans)

## ----fig.width=4,fig.height=4, fig.show='hold'---------------------------
require(ggcyto)
ggcyto(gs, aes(x = CD4), subset = "root") + geom_density()
ggcyto(gs, aes(x = CD4, y = CD8), subset = "root") + geom_hex()

## ------------------------------------------------------------------------
gating(g, gs)
## Plot the gates
autoplot(gs[[1]])
# Extract the population statistics
getPopStats(gs, statType = "count")

