## ----global_settings, echo = FALSE, message = FALSE-----------------------------------------------
library(markdown)
options(markdown.HTML.options = c(options('markdown.HTML.options')[[1]], "toc"))

library(knitr)
knitr::opts_chunk$set(
    error = FALSE,
    tidy  = FALSE,
    message = FALSE,
    fig.align = "center",
    fig.width = 5,
    fig.height = 5)
options(markdown.HTML.stylesheet = "custom.css")

options(width = 100)

## ----heatmap_list_default, fig.width = 10---------------------------------------------------------
library(ComplexHeatmap)

mat1 = matrix(rnorm(80, 2), 8, 10)
mat1 = rbind(mat1, matrix(rnorm(40, -2), 4, 10))
rownames(mat1) = paste0("R", 1:12)
colnames(mat1) = paste0("C", 1:10)

mat2 = matrix(rnorm(60, 2), 6, 10)
mat2 = rbind(mat2, matrix(rnorm(60, -2), 6, 10))
rownames(mat2) = paste0("R", 1:12)
colnames(mat2) = paste0("C", 1:10)

ht1 = Heatmap(mat1, name = "ht1")
ht2 = Heatmap(mat2, name = "ht2")
class(ht1)
class(ht2)

ht1 + ht2

## -------------------------------------------------------------------------------------------------
ht_list = ht1 + ht2
class(ht_list)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  ht1 + ht1 + ht1
#  ht1 + ht_list
#  ht_list + ht1
#  ht_list + ht_list

## ---- eval = FALSE--------------------------------------------------------------------------------
#  ht_list = NULL
#  for(s in sth) {
#      ht_list = ht_list + Heatmap(...)
#  }

## ----heatmap_list_title, fig.width = 10-----------------------------------------------------------
ht1 = Heatmap(mat1, name = "ht1", row_title = "Heatmap 1", column_title = "Heatmap 1")
ht2 = Heatmap(mat2, name = "ht2", row_title = "Heatmap 2", column_title = "Heatmap 2")
ht_list = ht1 + ht2

draw(ht_list, row_title = "Two heatmaps, row title", row_title_gp = gpar(col = "red"),
    column_title = "Two heatmaps, column title", column_title_side = "bottom")

## ----heatmap_list_gap, fig.width = 10, fig.keep = "all"-------------------------------------------
draw(ht_list, gap = unit(1, "cm"))
draw(ht_list + ht_list, gap = unit(c(3, 6, 9, 0), "mm"))

## ----heatmap_list_size, fig.width = 10, fig.keep = "all"------------------------------------------
ht1 = Heatmap(mat1, name = "ht1", column_title = "Heatmap 1")
ht2 = Heatmap(mat2, name = "ht2", column_title = "Heatmap 2", width = unit(5, "cm"))
ht1 + ht2

## ----heatmap_list_relative_size, fig.width = 10, fig.keep = "all"---------------------------------
ht1 = Heatmap(mat1, name = "ht1", column_title = "Heatmap 1", width = 2)
ht2 = Heatmap(mat2, name = "ht2", column_title = "Heatmap 2", width = 1)
ht1 + ht2

## ----heatmap_list_auto_adjust, fig.width = 10, fig.keep = "all"-----------------------------------
ht1 = Heatmap(mat1, name = "ht1", column_title = "Heatmap 1", km = 2)
ht2 = Heatmap(mat2, name = "ht2", column_title = "Heatmap 2")
ht1 + ht2

# note we changed the order of `ht1` and `ht2`
draw(ht2 + ht1)

# here although `ht1` is the second heatmap, we specify `ht1` to be
# the main heatmap by explicitely setting `main_heatmap` argument
draw(ht2 + ht1, main_heatmap = "ht1")

## ----heatmap_list_auto_adjust_no_row_cluster, fig.width = 10--------------------------------------
ht1 = Heatmap(mat1, name = "ht1", column_title = "Heatmap 1", cluster_rows = FALSE)
ht2 = Heatmap(mat2, name = "ht2", column_title = "Heatmap 2")
ht1 + ht2

## ---- fig.width = 10------------------------------------------------------------------------------
ht_global_opt(heatmap_row_names_gp = gpar(fontface = "italic"), 
	          heatmap_column_names_gp = gpar(fontsize = 14))
ht1 = Heatmap(mat1, name = "ht1", column_title = "Heatmap 1")
ht2 = Heatmap(mat2, name = "ht2", column_title = "Heatmap 2")
ht1 + ht2
ht_global_opt(RESET = TRUE)

## -------------------------------------------------------------------------------------------------
names(ht_global_opt())

## -------------------------------------------------------------------------------------------------
ht_list = ht1 + ht2
row_order(ht_list)
column_order(ht_list)
row_dend(ht_list)
column_dend(ht_list)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  ht_list = draw(ht1 + ht2)
#  row_order(ht_list)
#  column_order(ht_list)
#  row_dend(ht_list)
#  column_dend(ht_list)

## ---- fig.width = 8-------------------------------------------------------------------------------
split = rep(c("a", "b"), each = 6)
ht_list = Heatmap(mat1, name = "mat1", cluster_rows = FALSE, column_title = "mat1") + 
          Heatmap(mat2, name = "mat2", cluster_rows = FALSE, column_title = "mat2")
draw(ht_list, main_heatmap = "mat1", split = split)
draw(ht_list, main_heatmap = "mat2", km = 2, cluster_rows = TRUE)
draw(ht_list, cluster_rows = TRUE, main_heatmap = "mat1", show_row_dend =TRUE)
draw(ht_list, cluster_rows = TRUE, main_heatmap = "mat2", show_row_dend =TRUE)

## -------------------------------------------------------------------------------------------------
sessionInfo()

