/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.bio;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.bridgedb.DataSource;
import org.bridgedb.DataSourcePatterns;
import org.bridgedb.bio.DataSourceComparator;
import org.bridgedb.bio.Organism;

public class DataSourceTxt {
    public static String datasourcesTxt = "";

    public static void init() {
        try {
            InputStream is = DataSourceTxt.class.getClassLoader().getResourceAsStream("org/bridgedb/bio/datasources.txt");
            new DataSourceTxt().loadAnInputStream(is);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    public static void loadInputStream(InputStream is) throws IOException {
        new DataSourceTxt().loadAnInputStream(is);
    }

    protected void loadAnInputStream(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            datasourcesTxt = datasourcesTxt + line + "\n";
            String[] fields = line.split("\\t");
            this.loadLine(fields);
        }
    }

    protected void loadLine(String[] fields) throws IOException {
        DataSource.Builder builder = DataSource.register(fields[1], fields[0]);
        if (fields.length > 2 && fields[2].length() > 0) {
            builder.mainUrl(fields[2]);
        }
        if (fields.length > 3 && fields[3].length() > 0) {
            builder.urlPattern(fields[3]);
        }
        if (fields.length > 4 && fields[4].length() > 0) {
            builder.idExample(fields[4]);
        }
        if (fields.length > 5 && fields[5].length() > 0) {
            builder.type(fields[5]);
        }
        if (fields.length > 6 && fields[6].length() > 0) {
            builder.organism((Object)Organism.fromLatinName(fields[6]));
        }
        if (fields.length > 7 && fields[7].length() > 0) {
            builder.primary(fields[7].equals("1"));
        }
        if (fields.length > 8) {
            builder.urnBase(fields[8]);
        }
        if (fields.length > 9) {
            String patternString = fields[9];
            try {
                Pattern pattern = Pattern.compile(patternString);
                DataSourcePatterns.registerPattern(builder.asDataSource(), pattern);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to parse pattern " + patternString + " for " + builder.asDataSource(), ex);
            }
        }
        if (fields.length > 10) {
            builder.alternative(fields[10]);
        }
    }

    public static void writeToBuffer(BufferedWriter writer) throws IOException {
        TreeSet<DataSource> sorted = new TreeSet<DataSource>(new DataSourceComparator());
        sorted.addAll(DataSource.getDataSources());
        DataSourceTxt.writeToBuffer(writer, sorted);
    }

    public static void writeToBuffer(BufferedWriter writer, SortedSet<DataSource> dataSources) throws IOException {
        for (DataSource dataSource : dataSources) {
            if (dataSource.getSystemCode() == null || dataSource.getFullName() == null) continue;
            writer.write(dataSource.getFullName());
            writer.write("\t");
            writer.write(dataSource.getSystemCode());
            writer.write("\t");
            if (dataSource.getMainUrl() != null) {
                writer.write(dataSource.getMainUrl());
            }
            writer.write("\t");
            if (dataSource.getKnownUrl("$id") != null) {
                writer.write(dataSource.getKnownUrl("$id"));
            }
            writer.write("\t");
            if (dataSource.getExample().getId() != null) {
                writer.write(dataSource.getExample().getId());
            }
            writer.write("\t");
            if (dataSource.getType() != null) {
                writer.write(dataSource.getType());
            }
            writer.write("\t");
            if (dataSource.getOrganism() instanceof Organism) {
                writer.write(((Organism)((Object)dataSource.getOrganism())).latinName());
            }
            writer.write("\t");
            if (dataSource.isPrimary()) {
                writer.write("1");
            } else {
                writer.write("0");
            }
            writer.write("\t");
            String base = dataSource.getMiriamURN("");
            if (base != null) {
                writer.write(base.substring(0, base.length() - 1));
            }
            writer.write("\t");
            if (DataSourcePatterns.getPatterns().containsKey(dataSource)) {
                writer.write(DataSourcePatterns.getPatterns().get(dataSource).pattern());
            }
            writer.write("\t");
            if (dataSource.getAlternative() != null) {
                writer.write(dataSource.getAlternative());
            }
            writer.newLine();
        }
        writer.flush();
        writer.close();
    }
}

