/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.impl.sql.compile.ColumnOrdering;

class RowOrderingImpl
implements RowOrdering {
    Vector ordering = new Vector();
    ColumnOrdering columnsAlwaysOrdered;
    Vector alwaysOrderedOptimizables;
    ColumnOrdering currentColumnOrdering;
    Vector unorderedOptimizables = new Vector();

    RowOrderingImpl() {
        this.columnsAlwaysOrdered = new ColumnOrdering(3);
        this.alwaysOrderedOptimizables = new Vector();
    }

    public boolean orderedOnColumn(int n, int n2, int n3, int n4) throws StandardException {
        if (this.vectorContainsOptimizable(n3, this.alwaysOrderedOptimizables)) {
            return true;
        }
        if (this.columnsAlwaysOrdered.contains(n3, n4)) {
            return true;
        }
        if (n2 >= this.ordering.size()) {
            return false;
        }
        ColumnOrdering columnOrdering = (ColumnOrdering)this.ordering.elementAt(n2);
        return columnOrdering.ordered(n, n3, n4);
    }

    public boolean orderedOnColumn(int n, int n2, int n3) throws StandardException {
        if (this.vectorContainsOptimizable(n2, this.alwaysOrderedOptimizables)) {
            return true;
        }
        if (this.columnsAlwaysOrdered.contains(n2, n3)) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < this.ordering.size(); ++i) {
            ColumnOrdering columnOrdering = (ColumnOrdering)this.ordering.elementAt(i);
            boolean bl2 = columnOrdering.ordered(n, n2, n3);
            if (!bl2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean vectorContainsOptimizable(int n, Vector vector) {
        for (int i = vector.size() - 1; i >= 0; --i) {
            Optimizable optimizable = (Optimizable)vector.elementAt(i);
            if (!optimizable.hasTableNumber() || optimizable.getTableNumber() != n) continue;
            return true;
        }
        return false;
    }

    public void addOrderedColumn(int n, int n2, int n3) {
        ColumnOrdering columnOrdering;
        if (this.unorderedOptimizables.size() > 0) {
            return;
        }
        if (this.ordering.size() == 0) {
            columnOrdering = new ColumnOrdering(n);
            this.ordering.addElement(columnOrdering);
        } else {
            columnOrdering = (ColumnOrdering)this.ordering.elementAt(this.ordering.size() - 1);
        }
        columnOrdering.addColumn(n2, n3);
    }

    public void nextOrderPosition(int n) {
        if (this.unorderedOptimizables.size() > 0) {
            return;
        }
        this.currentColumnOrdering = new ColumnOrdering(n);
        this.ordering.addElement(this.currentColumnOrdering);
    }

    public void optimizableAlwaysOrdered(Optimizable optimizable) {
        int n;
        if (this.unorderedOptimizablesOtherThan(optimizable)) {
            return;
        }
        boolean bl = optimizable.hasTableNumber();
        int n2 = n = bl ? optimizable.getTableNumber() : 0;
        if ((this.ordering.size() == 0 || bl && ((ColumnOrdering)this.ordering.elementAt(0)).hasTable(n)) && bl && !this.columnsAlwaysOrdered.hasAnyOtherTable(n)) {
            if (optimizable.hasTableNumber()) {
                this.removeOptimizable(optimizable.getTableNumber());
            }
            this.alwaysOrderedOptimizables.addElement(optimizable);
        }
    }

    public void columnAlwaysOrdered(Optimizable optimizable, int n) {
        this.columnsAlwaysOrdered.addColumn(optimizable.getTableNumber(), n);
    }

    public boolean alwaysOrdered(int n) {
        return this.vectorContainsOptimizable(n, this.alwaysOrderedOptimizables);
    }

    public void removeOptimizable(int n) {
        for (int i = this.ordering.size() - 1; i >= 0; --i) {
            ColumnOrdering columnOrdering = (ColumnOrdering)this.ordering.elementAt(i);
            columnOrdering.removeColumns(n);
            if (!columnOrdering.empty()) continue;
            this.ordering.removeElementAt(i);
        }
        this.columnsAlwaysOrdered.removeColumns(n);
        this.removeOptimizableFromVector(n, this.unorderedOptimizables);
        this.removeOptimizableFromVector(n, this.alwaysOrderedOptimizables);
    }

    private void removeOptimizableFromVector(int n, Vector vector) {
        for (int i = vector.size() - 1; i >= 0; --i) {
            Optimizable optimizable = (Optimizable)vector.elementAt(i);
            if (!optimizable.hasTableNumber() || optimizable.getTableNumber() != n) continue;
            vector.removeElementAt(i);
        }
    }

    public void addUnorderedOptimizable(Optimizable optimizable) {
        this.unorderedOptimizables.addElement(optimizable);
    }

    public void copy(RowOrdering rowOrdering) {
        int n;
        RowOrderingImpl rowOrderingImpl = (RowOrderingImpl)rowOrdering;
        rowOrderingImpl.ordering.removeAllElements();
        rowOrderingImpl.currentColumnOrdering = null;
        rowOrderingImpl.unorderedOptimizables.removeAllElements();
        for (n = 0; n < this.unorderedOptimizables.size(); ++n) {
            rowOrderingImpl.unorderedOptimizables.addElement(this.unorderedOptimizables.elementAt(n));
        }
        rowOrderingImpl.alwaysOrderedOptimizables.removeAllElements();
        for (n = 0; n < this.alwaysOrderedOptimizables.size(); ++n) {
            rowOrderingImpl.alwaysOrderedOptimizables.addElement(this.alwaysOrderedOptimizables.elementAt(n));
        }
        for (n = 0; n < this.ordering.size(); ++n) {
            ColumnOrdering columnOrdering = (ColumnOrdering)this.ordering.elementAt(n);
            rowOrderingImpl.ordering.addElement(columnOrdering.cloneMe());
            if (columnOrdering != this.currentColumnOrdering) continue;
            rowOrderingImpl.rememberCurrentColumnOrdering(n);
        }
        rowOrderingImpl.columnsAlwaysOrdered = null;
        if (this.columnsAlwaysOrdered != null) {
            rowOrderingImpl.columnsAlwaysOrdered = this.columnsAlwaysOrdered.cloneMe();
        }
    }

    private void rememberCurrentColumnOrdering(int n) {
        this.currentColumnOrdering = (ColumnOrdering)this.ordering.elementAt(n);
    }

    public String toString() {
        String string = null;
        return string;
    }

    private boolean unorderedOptimizablesOtherThan(Optimizable optimizable) {
        for (int i = 0; i < this.unorderedOptimizables.size(); ++i) {
            Optimizable optimizable2 = (Optimizable)this.unorderedOptimizables.elementAt(i);
            if (optimizable2 == optimizable) continue;
            return true;
        }
        return false;
    }
}

