/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;

public class RoleDescriptor
extends TupleDescriptor {
    private final UUID uuid;
    private final String roleName;
    private final String grantee;
    private final String grantor;
    private boolean withAdminOption;
    private final boolean isDef;

    RoleDescriptor(DataDictionary dataDictionary, UUID uUID, String string, String string2, String string3, boolean bl, boolean bl2) {
        super(dataDictionary);
        this.uuid = uUID;
        this.roleName = string;
        this.grantee = string2;
        this.grantor = string3;
        this.withAdminOption = bl;
        this.isDef = bl2;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public boolean isDef() {
        return this.isDef;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public boolean isWithAdminOption() {
        return this.withAdminOption;
    }

    public void setWithAdminOption(boolean bl) {
        this.withAdminOption = bl;
    }

    public String toString() {
        return "";
    }

    public String getDescriptorType() {
        return "Role";
    }

    public String getDescriptorName() {
        return this.roleName + " " + this.grantor + " " + this.grantee;
    }

    public void drop(LanguageConnectionContext languageConnectionContext) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.dropRoleDescriptor(this.roleName, this.grantee, this.grantor, transactionController);
    }
}

