/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.rules.DecisionTable;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.clusterers.NumberOfClustersRequestable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class SimpleKMeans
extends Clusterer
implements NumberOfClustersRequestable,
OptionHandler,
WeightedInstancesHandler {
    private ReplaceMissingValues m_ReplaceMissingFilter;
    private int m_NumClusters = 2;
    private Instances m_ClusterCentroids;
    private Instances m_ClusterStdDevs;
    private int[][][] m_ClusterNominalCounts;
    private int[] m_ClusterSizes;
    private int m_Seed = 10;
    private double[] m_Min;
    private double[] m_Max;
    private int m_Iterations = 0;
    private double[] m_squaredErrors;

    public String globalInfo() {
        return "Cluster data using the k means algorithm";
    }

    public void buildClusterer(Instances instances) throws Exception {
        int n;
        Object object;
        int n2;
        this.m_Iterations = 0;
        if (instances.checkForStringAttributes()) {
            throw new Exception("Can't handle string attributes!");
        }
        this.m_ReplaceMissingFilter = new ReplaceMissingValues();
        Instances instances2 = new Instances(instances);
        instances2.setClassIndex(-1);
        this.m_ReplaceMissingFilter.setInputFormat(instances2);
        instances2 = Filter.useFilter(instances2, this.m_ReplaceMissingFilter);
        this.m_Min = new double[instances2.numAttributes()];
        this.m_Max = new double[instances2.numAttributes()];
        for (int i = 0; i < instances2.numAttributes(); ++i) {
            this.m_Max[i] = Double.NaN;
            this.m_Min[i] = Double.NaN;
        }
        this.m_ClusterCentroids = new Instances(instances2, this.m_NumClusters);
        int[] nArray = new int[instances2.numInstances()];
        for (int i = 0; i < instances2.numInstances(); ++i) {
            this.updateMinMax(instances2.instance(i));
        }
        Random random = new Random(this.m_Seed);
        HashMap hashMap = new HashMap();
        DecisionTable.hashKey hashKey2 = null;
        for (n2 = instances2.numInstances() - 1; n2 >= 0; --n2) {
            int n3 = random.nextInt(n2 + 1);
            hashKey2 = new DecisionTable.hashKey(instances2.instance(n3), instances2.numAttributes(), true);
            if (!hashMap.containsKey(hashKey2)) {
                this.m_ClusterCentroids.add(instances2.instance(n3));
                hashMap.put(hashKey2, null);
            }
            instances2.swap(n2, n3);
            if (this.m_ClusterCentroids.numInstances() == this.m_NumClusters) break;
        }
        this.m_NumClusters = this.m_ClusterCentroids.numInstances();
        boolean bl = false;
        Instances[] instancesArray = new Instances[this.m_NumClusters];
        this.m_squaredErrors = new double[this.m_NumClusters];
        this.m_ClusterNominalCounts = new int[this.m_NumClusters][instances2.numAttributes()][0];
        while (!bl) {
            int n4 = 0;
            ++this.m_Iterations;
            bl = true;
            for (n2 = 0; n2 < instances2.numInstances(); ++n2) {
                object = instances2.instance(n2);
                n = this.clusterProcessedInstance((Instance)object, true);
                if (n != nArray[n2]) {
                    bl = false;
                }
                nArray[n2] = n;
            }
            this.m_ClusterCentroids = new Instances(instances2, this.m_NumClusters);
            for (n2 = 0; n2 < this.m_NumClusters; ++n2) {
                instancesArray[n2] = new Instances(instances2, 0);
            }
            for (n2 = 0; n2 < instances2.numInstances(); ++n2) {
                instancesArray[nArray[n2]].add(instances2.instance(n2));
            }
            for (n2 = 0; n2 < this.m_NumClusters; ++n2) {
                object = new double[instances2.numAttributes()];
                if (instancesArray[n2].numInstances() == 0) {
                    ++n4;
                    continue;
                }
                for (n = 0; n < instances2.numAttributes(); ++n) {
                    object[n] = (Instances)instancesArray[n2].meanOrMode(n);
                    this.m_ClusterNominalCounts[n2][n] = instancesArray[n2].attributeStats((int)n).nominalCounts;
                }
                this.m_ClusterCentroids.add(new Instance(1.0, (double[])object));
            }
            if (n4 > 0) {
                this.m_NumClusters -= n4;
                if (bl) {
                    object = new Instances[this.m_NumClusters];
                    n = 0;
                    for (int i = 0; i < instancesArray.length; ++i) {
                        if (instancesArray[i].numInstances() <= 0) continue;
                        object[n++] = instancesArray[i];
                    }
                    instancesArray = object;
                } else {
                    instancesArray = new Instances[this.m_NumClusters];
                }
            }
            if (bl) continue;
            this.m_squaredErrors = new double[this.m_NumClusters];
            this.m_ClusterNominalCounts = new int[this.m_NumClusters][instances2.numAttributes()][0];
        }
        this.m_ClusterStdDevs = new Instances(instances2, this.m_NumClusters);
        this.m_ClusterSizes = new int[this.m_NumClusters];
        for (n2 = 0; n2 < this.m_NumClusters; ++n2) {
            object = new double[instances2.numAttributes()];
            for (n = 0; n < instances2.numAttributes(); ++n) {
                object[n] = instances2.attribute(n).isNumeric() ? (Object)Math.sqrt(instancesArray[n2].variance(n)) : (Object)Instance.missingValue();
            }
            this.m_ClusterStdDevs.add(new Instance(1.0, (double[])object));
            this.m_ClusterSizes[n2] = instancesArray[n2].numInstances();
        }
    }

    private int clusterProcessedInstance(Instance instance, boolean bl) {
        double d = 2.147483647E9;
        int n = 0;
        for (int i = 0; i < this.m_NumClusters; ++i) {
            double d2 = this.distance(instance, this.m_ClusterCentroids.instance(i));
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        if (bl) {
            int n2 = n;
            this.m_squaredErrors[n2] = this.m_squaredErrors[n2] + d;
        }
        return n;
    }

    public int clusterInstance(Instance instance) throws Exception {
        this.m_ReplaceMissingFilter.input(instance);
        this.m_ReplaceMissingFilter.batchFinished();
        Instance instance2 = this.m_ReplaceMissingFilter.output();
        return this.clusterProcessedInstance(instance2, false);
    }

    private double distance(Instance instance, Instance instance2) {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n < instance.numValues() || n2 < instance2.numValues()) {
            double d2;
            int n3;
            int n4 = n >= instance.numValues() ? this.m_ClusterCentroids.numAttributes() : instance.index(n);
            if (n4 == (n3 = n2 >= instance2.numValues() ? this.m_ClusterCentroids.numAttributes() : instance2.index(n2))) {
                d2 = this.difference(n4, instance.valueSparse(n), instance2.valueSparse(n2));
                ++n;
                ++n2;
            } else if (n4 > n3) {
                d2 = this.difference(n3, 0.0, instance2.valueSparse(n2));
                ++n2;
            } else {
                d2 = this.difference(n4, instance.valueSparse(n), 0.0);
                ++n;
            }
            d += d2 * d2;
        }
        return d;
    }

    private double difference(int n, double d, double d2) {
        switch (this.m_ClusterCentroids.attribute(n).type()) {
            case 1: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2) || (int)d != (int)d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 0: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2)) {
                    if (Instance.isMissingValue(d) && Instance.isMissingValue(d2)) {
                        return 1.0;
                    }
                    double d3 = Instance.isMissingValue(d2) ? this.norm(d, n) : this.norm(d2, n);
                    if (d3 < 0.5) {
                        d3 = 1.0 - d3;
                    }
                    return d3;
                }
                return this.norm(d, n) - this.norm(d2, n);
            }
        }
        return 0.0;
    }

    private double norm(double d, int n) {
        if (Double.isNaN(this.m_Min[n]) || Utils.eq(this.m_Max[n], this.m_Min[n])) {
            return 0.0;
        }
        return (d - this.m_Min[n]) / (this.m_Max[n] - this.m_Min[n]);
    }

    private void updateMinMax(Instance instance) {
        for (int i = 0; i < this.m_ClusterCentroids.numAttributes(); ++i) {
            if (instance.isMissing(i)) continue;
            if (Double.isNaN(this.m_Min[i])) {
                this.m_Min[i] = instance.value(i);
                this.m_Max[i] = instance.value(i);
                continue;
            }
            if (instance.value(i) < this.m_Min[i]) {
                this.m_Min[i] = instance.value(i);
                continue;
            }
            if (!(instance.value(i) > this.m_Max[i])) continue;
            this.m_Max[i] = instance.value(i);
        }
    }

    public int numberOfClusters() throws Exception {
        return this.m_NumClusters;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tnumber of clusters. (default = 2).", "N", 1, "-N <num>"));
        vector.addElement(new Option("\trandom number seed.\n (default 10)", "S", 1, "-S <num>"));
        return vector.elements();
    }

    public String numClustersTipText() {
        return "set number of clusters";
    }

    public void setNumClusters(int n) throws Exception {
        if (n <= 0) {
            throw new Exception("Number of clusters must be > 0");
        }
        this.m_NumClusters = n;
    }

    public int getNumClusters() {
        return this.m_NumClusters;
    }

    public String seedTipText() {
        return "random number seed";
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNumClusters(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('S', stringArray)).length() != 0) {
            this.setSeed(Integer.parseInt(string));
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[4];
        int n = 0;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.getNumClusters();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSeed();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        int n;
        int n2 = 0;
        for (int i = 0; i < this.m_NumClusters; ++i) {
            for (int j = 0; j < this.m_ClusterCentroids.numAttributes(); ++j) {
                if (!this.m_ClusterCentroids.attribute(j).isNumeric()) continue;
                double d = Math.log(Math.abs(this.m_ClusterCentroids.instance(i).value(j))) / Math.log(10.0);
                if ((int)(d += 1.0) <= n2) continue;
                n2 = (int)d;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = "N/A";
        for (n = 0; n < n2 + 2; ++n) {
            string = string + " ";
        }
        stringBuffer.append("\nkMeans\n======\n");
        stringBuffer.append("\nNumber of iterations: " + this.m_Iterations + "\n");
        stringBuffer.append("Within cluster sum of squared errors: " + Utils.sum(this.m_squaredErrors));
        stringBuffer.append("\n\nCluster centroids:\n");
        for (n = 0; n < this.m_NumClusters; ++n) {
            int n3;
            stringBuffer.append("\nCluster " + n + "\n\t");
            stringBuffer.append("Mean/Mode: ");
            for (n3 = 0; n3 < this.m_ClusterCentroids.numAttributes(); ++n3) {
                if (this.m_ClusterCentroids.attribute(n3).isNominal()) {
                    stringBuffer.append(" " + this.m_ClusterCentroids.attribute(n3).value((int)this.m_ClusterCentroids.instance(n).value(n3)));
                    continue;
                }
                stringBuffer.append(" " + Utils.doubleToString(this.m_ClusterCentroids.instance(n).value(n3), n2 + 5, 4));
            }
            stringBuffer.append("\n\tStd Devs:  ");
            for (n3 = 0; n3 < this.m_ClusterStdDevs.numAttributes(); ++n3) {
                if (this.m_ClusterStdDevs.attribute(n3).isNumeric()) {
                    stringBuffer.append(" " + Utils.doubleToString(this.m_ClusterStdDevs.instance(n).value(n3), n2 + 5, 4));
                    continue;
                }
                stringBuffer.append(" " + string);
            }
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    public Instances getClusterCentroids() {
        return this.m_ClusterCentroids;
    }

    public Instances getClusterStandardDevs() {
        return this.m_ClusterStdDevs;
    }

    public int[][][] getClusterNominalCounts() {
        return this.m_ClusterNominalCounts;
    }

    public double getSquaredError() {
        return Utils.sum(this.m_squaredErrors);
    }

    public int[] getClusterSizes() {
        return this.m_ClusterSizes;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(ClusterEvaluation.evaluateClusterer(new SimpleKMeans(), stringArray));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

