/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeSelection;
import weka.classifiers.functions.SMO;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;
import weka.filters.unsupervised.attribute.Remove;

public class SVMAttributeEval
extends AttributeEvaluator
implements OptionHandler {
    private double[] m_attScores;
    private int m_numToEliminate = 1;
    private int m_percentToEliminate = 0;
    private int m_percentThreshold = 0;
    private double m_smoCParameter = 1.0;
    private double m_smoTParameter = 1.0E-10;
    private double m_smoPParameter = 1.0E-25;
    private int m_smoFilterType = 0;

    public String globalInfo() {
        return "SVMAttributeEval :\n\nEvaluates the worth of an attribute by using an SVM classifier.\n\nFor more information see:\nGuyon, I., Weston, J., Barnhill, S., & Vapnik, V. (2002). Gene selection for cancer classification using support vector machines. Machine Learning, 46, 389-422";
    }

    public SVMAttributeEval() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tSpecify the constant rate of attribute\n\telimination per invocation of\n\tthe support vector machine.\n\tDefault = 1.", "X", 1, "-X <constant rate of elimination>"));
        vector.addElement(new Option("\tSpecify the percentage rate of attributes to\n\telimination per invocation of\n\tthe support vector machine.\n\tTrumps constant rate (above threshold).\n\tDefault = 0.", "Y", 1, "-Y <percent rate of elimination>"));
        vector.addElement(new Option("\tSpecify the threshold below which \n\tpercentage attribute elimination\n\treverts to the constant method.\n", "Z", 1, "-Z <threshold for percent elimination>"));
        vector.addElement(new Option("\tSpecify the value of P (epsilon\n\tparameter) to pass on to the\n\tsupport vector machine.\n\tDefault = 1.0e-25", "P", 1, "-P <epsilon>"));
        vector.addElement(new Option("\tSpecify the value of T (tolerance\n\tparameter) to pass on to the\n\tsupport vector machine.\n\tDefault = 1.0e-10", "T", 1, "-T <tolerance>"));
        vector.addElement(new Option("\tSpecify the value of C (complexity\n\tparameter) to pass on to the\n\tsupport vector machine.\n\tDefault = 1.0", "C", 1, "-C <complexity>"));
        vector.addElement(new Option("\tWhether the SVM should 0=normalize/1=standardize/2=neither. (default 0=normalize)", "N", 1, "-N"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('X', stringArray);
        if (string.length() != 0) {
            this.setAttsToEliminatePerIteration(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('Y', stringArray)).length() != 0) {
            this.setPercentToEliminatePerIteration(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('Z', stringArray)).length() != 0) {
            this.setPercentThreshold(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('P', stringArray)).length() != 0) {
            this.setEpsilonParameter(new Double(string));
        }
        if ((string = Utils.getOption('T', stringArray)).length() != 0) {
            this.setToleranceParameter(new Double(string));
        }
        if ((string = Utils.getOption('C', stringArray)).length() != 0) {
            this.setComplexityParameter(new Double(string));
        }
        if ((string = Utils.getOption('N', stringArray)).length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(string), SMO.TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, SMO.TAGS_FILTER));
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[14];
        int n = 0;
        stringArray[n++] = "-X";
        stringArray[n++] = "" + this.getAttsToEliminatePerIteration();
        stringArray[n++] = "-Y";
        stringArray[n++] = "" + this.getPercentToEliminatePerIteration();
        stringArray[n++] = "-Z";
        stringArray[n++] = "" + this.getPercentThreshold();
        stringArray[n++] = "-P";
        stringArray[n++] = "" + this.getEpsilonParameter();
        stringArray[n++] = "-T";
        stringArray[n++] = "" + this.getToleranceParameter();
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getComplexityParameter();
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_smoFilterType;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String attsToEliminatePerIterationTipText() {
        return "Constant rate of attribute elimination.";
    }

    public String percentToEliminatePerIterationTipText() {
        return "Percent rate of attribute elimination.";
    }

    public String percentThresholdTipText() {
        return "Threshold below which percent elimination reverts to constant elimination.";
    }

    public String epsilonParameterTipText() {
        return "P epsilon parameter to pass to the SVM";
    }

    public String toleranceParameterTipText() {
        return "T tolerance parameter to pass to the SVM";
    }

    public String complexityParameterTipText() {
        return "C complexity parameter to pass to the SVM";
    }

    public String filterTypeTipText() {
        return "filtering used by the SVM";
    }

    public void setAttsToEliminatePerIteration(int n) {
        this.m_numToEliminate = n;
    }

    public int getAttsToEliminatePerIteration() {
        return this.m_numToEliminate;
    }

    public void setPercentToEliminatePerIteration(int n) {
        this.m_percentToEliminate = n;
    }

    public int getPercentToEliminatePerIteration() {
        return this.m_percentToEliminate;
    }

    public void setPercentThreshold(int n) {
        this.m_percentThreshold = n;
    }

    public int getPercentThreshold() {
        return this.m_percentThreshold;
    }

    public void setEpsilonParameter(double d) {
        this.m_smoPParameter = d;
    }

    public double getEpsilonParameter() {
        return this.m_smoPParameter;
    }

    public void setToleranceParameter(double d) {
        this.m_smoTParameter = d;
    }

    public double getToleranceParameter() {
        return this.m_smoTParameter;
    }

    public void setComplexityParameter(double d) {
        this.m_smoCParameter = d;
    }

    public double getComplexityParameter() {
        return this.m_smoCParameter;
    }

    public void setFilterType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == SMO.TAGS_FILTER) {
            this.m_smoFilterType = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_smoFilterType, SMO.TAGS_FILTER);
    }

    public void buildEvaluator(Instances instances) throws Exception {
        int[][] nArray;
        if (instances.checkForStringAttributes()) {
            throw new Exception("Can't handle string attributes!");
        }
        if (!instances.classAttribute().isNominal()) {
            throw new Exception("Class must be nominal!");
        }
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (!instances.attribute(i).isNominal() || instances.attribute(i).numValues() == 2 || i == instances.classIndex()) continue;
            throw new Exception("All nominal attributes must be binary!");
        }
        System.out.println("Class attribute: " + instances.attribute(instances.classIndex()).name());
        this.m_numToEliminate = this.m_numToEliminate > 1 ? this.m_numToEliminate : 1;
        this.m_percentToEliminate = this.m_percentToEliminate < 100 ? this.m_percentToEliminate : 100;
        this.m_percentToEliminate = this.m_percentToEliminate > 0 ? this.m_percentToEliminate : 0;
        this.m_percentThreshold = this.m_percentThreshold < instances.numAttributes() ? this.m_percentThreshold : instances.numAttributes() - 1;
        this.m_percentThreshold = this.m_percentThreshold > 0 ? this.m_percentThreshold : 0;
        int n = instances.numAttributes() - 1;
        if (instances.numClasses() > 2) {
            nArray = new int[instances.numClasses()][n];
            for (int i = 0; i < instances.numClasses(); ++i) {
                nArray[i] = this.rankBySVM(i, instances);
            }
        } else {
            nArray = new int[1][n];
            nArray[0] = this.rankBySVM(0, instances);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < (instances.numClasses() > 2 ? instances.numClasses() : 1); ++j) {
                Integer n2 = new Integer(nArray[j][i]);
                if (arrayList.contains(n2)) continue;
                arrayList.add(n2);
            }
        }
        this.m_attScores = new double[instances.numAttributes()];
        Iterator iterator = arrayList.iterator();
        double d = n;
        while (iterator.hasNext()) {
            this.m_attScores[((Integer)iterator.next()).intValue()] = d;
            d -= 1.0;
        }
    }

    private int[] rankBySVM(int n, Instances instances) {
        int n2;
        int[] nArray = new int[instances.numAttributes()];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = n2;
        }
        n2 = instances.numAttributes() - 1;
        int[] nArray2 = new int[n2];
        try {
            MakeIndicator makeIndicator = new MakeIndicator();
            makeIndicator.setAttributeIndex("" + (instances.classIndex() + 1));
            makeIndicator.setNumeric(false);
            makeIndicator.setValueIndex(n);
            makeIndicator.setInputFormat(instances);
            Instances instances2 = Filter.useFilter(instances, makeIndicator);
            double d = (double)this.m_percentToEliminate / 100.0;
            while (n2 > 0) {
                int n3;
                int n4;
                if (d > 0.0) {
                    n4 = (int)((double)instances2.numAttributes() * d);
                    int n5 = n4 = n4 > 1 ? n4 : 1;
                    if (n2 - n4 <= this.m_percentThreshold) {
                        d = 0.0;
                        n4 = n2 - this.m_percentThreshold;
                    }
                } else {
                    n4 = n2 >= this.m_numToEliminate ? this.m_numToEliminate : n2;
                }
                SMO sMO = new SMO();
                sMO.setFilterType(new SelectedTag(this.m_smoFilterType, SMO.TAGS_FILTER));
                sMO.setEpsilon(this.m_smoPParameter);
                sMO.setToleranceParameter(this.m_smoTParameter);
                sMO.setC(this.m_smoCParameter);
                sMO.buildClassifier(instances2);
                double[] dArray = sMO.sparseWeights()[0][1];
                int[] nArray3 = sMO.sparseIndices()[0][1];
                double[] dArray2 = new double[instances2.numAttributes()];
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    dArray2[nArray3[n3]] = dArray[n3] * dArray[n3];
                }
                dArray2[instances2.classIndex()] = Double.MAX_VALUE;
                int[] nArray4 = new int[n4];
                boolean[] blArray = new boolean[nArray.length];
                for (int i = 0; i < n4; ++i) {
                    n3 = Utils.minIndex(dArray2);
                    nArray2[--n2] = nArray[n3];
                    nArray4[i] = n3;
                    blArray[n3] = true;
                    dArray2[n3] = Double.MAX_VALUE;
                }
                Remove remove = new Remove();
                remove.setInvertSelection(false);
                remove.setAttributeIndicesArray(nArray4);
                remove.setInputFormat(instances2);
                instances2 = Filter.useFilter(instances2, remove);
                int[] nArray5 = new int[nArray.length - n4];
                int n6 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    if (blArray[i]) continue;
                    nArray5[n6++] = nArray[i];
                }
                nArray = nArray5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray2;
    }

    protected void resetOptions() {
        this.m_attScores = null;
    }

    public double evaluateAttribute(int n) throws Exception {
        return this.m_attScores[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_attScores == null) {
            stringBuffer.append("\tSVM feature evaluator has not been built yet");
        } else {
            stringBuffer.append("\tSVM feature evaluator");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(AttributeSelection.SelectAttributes(new SVMAttributeEval(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

