### R code from vignette source 'triplex.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: triplex.Rnw:53-54
###################################################
library(triplex)


###################################################
### code chunk number 2: triplex.Rnw:82-84
###################################################
seq <- DNAString("TTGGGGAAAGCAATGCCAGGCAGGGGGTTCCTTTCGTTACGGTCCGTCCC")
triplex.search(seq)


###################################################
### code chunk number 3: triplex.Rnw:105-106
###################################################
triplex.search(seq, type=1)


###################################################
### code chunk number 4: triplex.Rnw:134-135
###################################################
triplex.search(seq, min_len=10, max_len=20)


###################################################
### code chunk number 5: triplex.Rnw:155-156
###################################################
triplex.search(seq, iso_pen=2)


###################################################
### code chunk number 6: triplex.Rnw:178-179
###################################################
triplex.search(seq, min_score=14)


###################################################
### code chunk number 7: triplex.Rnw:223-225
###################################################
t <- triplex.search(seq)
t


###################################################
### code chunk number 8: triplex.Rnw:234-235
###################################################
triplex.alignment(t[1])


###################################################
### code chunk number 9: triplex.Rnw:248-249
###################################################
triplex.diagram(t[1])


###################################################
### code chunk number 10: triplex.Rnw:263-264 (eval = FALSE)
###################################################
## triplex.3D(t[1])


###################################################
### code chunk number 11: triplex.Rnw:267-268
###################################################
triplex.alignment(t[1])


###################################################
### code chunk number 12: triplex.Rnw:298-300
###################################################
gr <- as(t, "GRanges")
gr


###################################################
### code chunk number 13: triplex.Rnw:309-311
###################################################
library(rtracklayer)
export(gr,"test.gff", version="3")


###################################################
### code chunk number 14: triplex.Rnw:317-319
###################################################
text <- readLines("test.gff",n=10)
cat(strwrap(text, width=80, exdent=3),sep="\n")


###################################################
### code chunk number 15: triplex.Rnw:333-335
###################################################
dss <- as(t, "DNAStringSet")
dss


###################################################
### code chunk number 16: triplex.Rnw:340-341
###################################################
writeXStringSet(dss, file="test.fa", format="fasta")


###################################################
### code chunk number 17: triplex.Rnw:346-348
###################################################
text <- readLines("test.fa",n=10)
cat(text,sep="\n")


###################################################
### code chunk number 18: triplex.Rnw:375-377
###################################################
library(triplex) 
library(BSgenome.Celegans.UCSC.ce10) 


###################################################
### code chunk number 19: triplex.Rnw:382-384
###################################################
t <- triplex.search(Celegans[["chrX"]][1:100000],min_score=17,min_len=8)
t


###################################################
### code chunk number 20: triplex.Rnw:390-392
###################################################
ts <- t[order(score(t),decreasing=TRUE)]
ts


###################################################
### code chunk number 21: triplex.Rnw:400-401
###################################################
triplex.diagram(ts[1])


###################################################
### code chunk number 22: triplex.Rnw:409-410 (eval = FALSE)
###################################################
## triplex.3D(ts[1])


###################################################
### code chunk number 23: triplex.Rnw:413-414
###################################################
triplex.alignment(ts[1])


###################################################
### code chunk number 24: triplex.Rnw:428-430
###################################################
library(rtracklayer)
export(as(t, "GRanges"),"test.gff", version="3")


###################################################
### code chunk number 25: triplex.Rnw:435-437
###################################################
text <- readLines("test.gff",n=10)
cat(strwrap(text, width=80, exdent=3),sep="\n")


###################################################
### code chunk number 26: triplex.Rnw:442-443
###################################################
writeXStringSet(as(t, "DNAStringSet"), file="test.fa", format="fasta")


###################################################
### code chunk number 27: triplex.Rnw:448-450
###################################################
text <- readLines("test.fa",n=20)
cat(text,sep="\n")


###################################################
### code chunk number 28: triplex.Rnw:455-456
###################################################
hist(score(t), breaks=20)


###################################################
### code chunk number 29: triplex.Rnw:461-462
###################################################
plot(coverage(ts[0:length(t)]), type="s", col="grey75")


###################################################
### code chunk number 30: triplex.Rnw:469-499
###################################################
library(GenomeGraphs)
mart <- useMart("ensembl", dataset = "celegans_gene_ensembl")

# Set up basic GenomeGraphs annotation tracks
ideog <- makeIdeogram(chromosome = "X")
genomeAxis <- makeGenomeAxis()
genesplus <- makeGeneRegion(start = 0, end = 62000, strand = "+",
   chromosome = "X", biomart = mart)
genesminus <- makeGeneRegion(start = 0, end = 62000, strand = "-",
   chromosome = "X", biomart = mart)

# Set up triplex annotation tracks
tall <- as(t,"GRanges")
ta <- makeAnnotationTrack(
  start = start(tall[which(end(tall)<62000)]),
  end = end(tall[which(end(tall)<62000)]),
  feature = "gene_model",
  dp = DisplayPars(gene_model = "grey")
)
ta1 <- makeAnnotationTrack(
  start = start(tall[which(end(tall)<62000 & score(tall)>20)]),
  end = end(tall[which(end(tall)<62000 & score(tall)>20)]),
  feature = "gene_model",
  dp = DisplayPars(gene_model = "darkblue")
)

# Plot the entire thing
gdPlot(list(fwd = genesplus, GENES = genomeAxis, rev = genesminus,
   weak = ta, strong = ta1, chrX = ideog), minBase = 0,
   maxBase = 62000, labelRot = 0)


