/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.file;

import java.net.URI;
import org.apache.log4j.Logger;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.ebi.ontocat.OntologyServiceException;

public final class OntologyLoader {
    private static final Logger log = Logger.getLogger(OntologyLoader.class.getName());
    private OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    private OWLOntology ontology;

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OntologyLoader(URI uriOntology) throws OntologyServiceException {
        try {
            OWLOntologyManager oWLOntologyManager = this.manager;
            synchronized (oWLOntologyManager) {
                System.setProperty("entityExpansionLimit", "100000000");
                IRI iri = IRI.create(uriOntology);
                try {
                    this.ontology = this.manager.loadOntologyFromOntologyDocument(iri);
                }
                catch (OWLOntologyCreationException e) {
                    log.warn("Ontology could not be created. Waiting 30s and retrying once. " + uriOntology.toString() + e.getMessage());
                    Thread.sleep(30000L);
                    this.ontology = this.manager.loadOntologyFromOntologyDocument(iri);
                }
            }
        }
        catch (InterruptedException e) {
            throw new OntologyServiceException(e);
        }
        catch (OWLOntologyCreationException e) {
            throw new OntologyServiceException("Ontology could not be created for " + uriOntology.toString() + e.getMessage());
        }
        catch (OutOfMemoryError e) {
            log.fatal("Ran out of memory. Try a bigger heap size, e.g. VM arguments -Xms512M -Xmx512M");
            throw new OntologyServiceException(e.getMessage());
        }
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }
}

