/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyTerm;
import uk.ac.ebi.ontocat.bioportal.BioportalOntologyService;
import uk.ac.ebi.ontocat.special.AbstractOntologyServiceTest;

public class BioportalServiceTest
extends AbstractOntologyServiceTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        os = new BioportalOntologyService();
        ONTOLOGY_ACCESSION = "1070";
    }

    @Test
    public void testSearchSubtree() throws Exception {
        BioportalOntologyService bos = new BioportalOntologyService();
        List list1 = bos.searchSubtree("1136", "efo:EFO_0003740", "EST", new OntologyService.SearchOptions[0]);
        Assert.assertNotSame((String)"Subtree search list empty!", (Object)Collections.EMPTY_LIST, (Object)list1);
        for (OntologyTerm ot : list1) {
            System.out.println(ot);
        }
        List list2 = bos.searchOntology("1136", "EST", new OntologyService.SearchOptions[0]);
        log.info(list1.size() + " < " + list2.size());
        Assert.assertTrue((String)"Incorrect list size returned!", (list1.size() <= list2.size() ? 1 : 0) != 0);
    }

    @Test
    @Ignore(value="Takes too long to test usually")
    public void testGetAllTerms() throws Exception {
        Set<OntologyTerm> set = os.getAllTerms("1136");
        log.info(set.size() + " terms returned.");
        Assert.assertTrue((String)"Less than expected terms returned", (set.size() > 2600 ? 1 : 0) != 0);
    }
}

