/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.Printing;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowModelCommand
extends AbstractCommand {
    public ShowModelCommand(Debugger debugger) {
        super(debugger);
    }

    @Override
    public String getCommandName() {
        return "showModel";
    }

    @Override
    public String[] getDescription() {
        return new String[]{"", "prints all assertions", "predicate", "prints all assertions for the given predicate"};
    }

    @Override
    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: showModel");
        printWriter.println("    Prints the entire current model.");
        printWriter.println("usage: showModel predicate");
        printWriter.println("    Prints all assertions containing the supplied predicate.");
    }

    @Override
    public void execute(String[] stringArray) {
        Object object;
        String string;
        Object object2;
        TreeSet<Object[]> treeSet = new TreeSet<Object[]>(Printing.FactComparator.INSTANCE);
        if (stringArray.length < 2) {
            for (ExtensionTable extensionTable : this.m_debugger.getTableau().getExtensionManager().getExtensionTables()) {
                object2 = extensionTable.createRetrieval(new boolean[extensionTable.getArity()], ExtensionTable.View.TOTAL);
                this.loadFacts(treeSet, (ExtensionTable.Retrieval)object2);
            }
            string = "Current model";
        } else {
            object = null;
            try {
                object = this.getDLPredicate(stringArray[1]);
            }
            catch (Exception exception) {
                this.m_debugger.getOutput().println(stringArray[1] + " is invalid: " + exception.getMessage());
            }
            if (object != null) {
                ExtensionTable extensionTable = this.m_debugger.getTableau().getExtensionManager().getExtensionTable(object.getArity() + 1);
                object2 = new boolean[extensionTable.getArity()];
                object2[0] = true;
                ExtensionTable.Retrieval retrieval = extensionTable.createRetrieval((boolean[])object2, ExtensionTable.View.TOTAL);
                retrieval.getBindingsBuffer()[0] = object;
                this.loadFacts(treeSet, retrieval);
                string = "Assertions containing the predicate '" + this.m_debugger.getPrefixes().abbreviateIRI(object.toString()) + "'.";
            } else {
                int n;
                try {
                    n = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.m_debugger.getOutput().println("Invalid ID of the node.");
                    return;
                }
                object2 = this.m_debugger.getTableau().getNode(n);
                if (object2 == null) {
                    this.m_debugger.getOutput().println("Node with ID '" + n + "' not found.");
                    return;
                }
                for (ExtensionTable objectArray : this.m_debugger.getTableau().getExtensionManager().getExtensionTables()) {
                    for (int i = 0; i < objectArray.getArity(); ++i) {
                        boolean[] blArray = new boolean[objectArray.getArity()];
                        blArray[i] = true;
                        ExtensionTable.Retrieval retrieval = objectArray.createRetrieval(blArray, ExtensionTable.View.TOTAL);
                        retrieval.getBindingsBuffer()[i] = object2;
                        this.loadFacts(treeSet, retrieval);
                    }
                }
                string = "Assertions containing node '" + ((Node)object2).getNodeID() + "'.";
            }
        }
        object = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter((Writer)object);
        object2 = null;
        for (Object[] objectArray : treeSet) {
            if (object2 != objectArray[0]) {
                object2 = objectArray[0];
                printWriter.println();
            }
            printWriter.print(' ');
            this.printFact(objectArray, printWriter);
            printWriter.println();
        }
        printWriter.flush();
        this.showTextInWindow(((CharArrayWriter)object).toString(), string);
        this.selectConsoleWindow();
    }

    protected void loadFacts(Set<Object[]> set, ExtensionTable.Retrieval retrieval) {
        retrieval.open();
        while (!retrieval.afterLast()) {
            set.add((Object[])retrieval.getTupleBuffer().clone());
            retrieval.next();
        }
    }

    protected void printFact(Object[] objectArray, PrintWriter printWriter) {
        Object object = objectArray[0];
        if (object instanceof Concept) {
            printWriter.print(((Concept)object).toString(this.m_debugger.getPrefixes()));
        } else if (object instanceof DLPredicate) {
            printWriter.print(((DLPredicate)object).toString(this.m_debugger.getPrefixes()));
        } else {
            throw new IllegalStateException("Internal error: invalid predicate.");
        }
        printWriter.print('[');
        for (int i = 1; i < objectArray.length; ++i) {
            if (i != 1) {
                printWriter.print(',');
            }
            printWriter.print(((Node)objectArray[i]).getNodeID());
        }
        printWriter.print(']');
    }
}

