/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.floatnum;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatInterval {
    protected final float m_lowerBoundInclusive;
    protected final float m_upperBoundInclusive;

    public FloatInterval(float f, float f2) {
        assert (!FloatInterval.isIntervalEmpty(f, f2));
        this.m_lowerBoundInclusive = f;
        this.m_upperBoundInclusive = f2;
    }

    public FloatInterval intersectWith(FloatInterval floatInterval) {
        float f;
        float f2 = FloatInterval.isSmallerEqual(this.m_lowerBoundInclusive, floatInterval.m_lowerBoundInclusive) ? floatInterval.m_lowerBoundInclusive : this.m_lowerBoundInclusive;
        if (FloatInterval.isIntervalEmpty(f2, f = FloatInterval.isSmallerEqual(this.m_upperBoundInclusive, floatInterval.m_upperBoundInclusive) ? this.m_upperBoundInclusive : floatInterval.m_upperBoundInclusive)) {
            return null;
        }
        if (this.isEqual(f2, f)) {
            return this;
        }
        if (floatInterval.isEqual(f2, f)) {
            return floatInterval;
        }
        return new FloatInterval(f2, f);
    }

    protected boolean isEqual(float f, float f2) {
        return FloatInterval.areIdentical(this.m_lowerBoundInclusive, f) && FloatInterval.areIdentical(this.m_upperBoundInclusive, f2);
    }

    public int subtractSizeFrom(int n) {
        return FloatInterval.subtractIntervalSizeFrom(this.m_lowerBoundInclusive, this.m_upperBoundInclusive, n);
    }

    public boolean contains(float f) {
        return FloatInterval.contains(this.m_lowerBoundInclusive, this.m_upperBoundInclusive, f);
    }

    public void enumerateNumbers(Collection<Object> collection) {
        float f = this.m_lowerBoundInclusive;
        while (!FloatInterval.areIdentical(f, this.m_upperBoundInclusive)) {
            collection.add(Float.valueOf(f));
            f = FloatInterval.nextFloat(f);
        }
        collection.add(Float.valueOf(this.m_upperBoundInclusive));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FLOAT[");
        stringBuffer.append(this.m_lowerBoundInclusive);
        stringBuffer.append("..");
        stringBuffer.append(this.m_upperBoundInclusive);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static boolean isNaN(int n) {
        return (n & 0x7F800000) == 2139095040 && (n & 0x3FFFFF) != 0;
    }

    protected static boolean isIntervalEmpty(float f, float f2) {
        return !FloatInterval.isSmallerEqual(f, f2);
    }

    public static boolean areIdentical(float f, float f2) {
        return Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static float nextFloat(float f) {
        int n;
        boolean bl;
        boolean bl2;
        int n2 = Float.floatToIntBits(f);
        int n3 = n2 & Integer.MAX_VALUE;
        boolean bl3 = bl2 = (n2 & Integer.MIN_VALUE) == 0;
        if (FloatInterval.isNaN(n2) || n3 == 2139095040 && bl2) {
            return f;
        }
        if (bl2) {
            bl = true;
            n = n3 + 1;
        } else if (!bl2 && n3 == 0) {
            bl = true;
            n = 0;
        } else {
            bl = false;
            n = n3 - 1;
        }
        int n4 = n | (bl ? 0 : Integer.MIN_VALUE);
        return Float.intBitsToFloat(n4);
    }

    public static float previousFloat(float f) {
        int n;
        boolean bl;
        boolean bl2;
        int n2 = Float.floatToIntBits(f);
        int n3 = n2 & Integer.MAX_VALUE;
        boolean bl3 = bl2 = (n2 & Integer.MIN_VALUE) == 0;
        if (FloatInterval.isNaN(n2) || n3 == 2139095040 && !bl2) {
            return f;
        }
        if (!bl2) {
            bl = false;
            n = n3 + 1;
        } else if (bl2 && n3 == 0) {
            bl = false;
            n = 0;
        } else {
            bl = true;
            n = n3 - 1;
        }
        int n4 = n | (bl ? 0 : Integer.MIN_VALUE);
        return Float.intBitsToFloat(n4);
    }

    public static int subtractIntervalSizeFrom(float f, float f2, int n) {
        int n2;
        boolean bl;
        int n3;
        if (n <= 0) {
            return 0;
        }
        int n4 = Float.floatToIntBits(f);
        int n5 = Float.floatToIntBits(f2);
        if (FloatInterval.isNaN(n4) || FloatInterval.isNaN(n5)) {
            return n;
        }
        boolean bl2 = (n4 & Integer.MIN_VALUE) == 0;
        if (!FloatInterval.isSmallerEqual(bl2, n3 = n4 & Integer.MAX_VALUE, bl = (n5 & Integer.MIN_VALUE) == 0, n2 = n5 & Integer.MAX_VALUE)) {
            return n;
        }
        if (bl2 && bl) {
            int n6 = n2 - n3 + 1;
            return Math.max(n - n6, 0);
        }
        if (!bl2 && !bl) {
            int n7 = n3 - n2 + 1;
            return Math.max(n - n7, 0);
        }
        if (!bl2 && bl) {
            int n8 = n3 + 1;
            if (n8 >= n) {
                return 0;
            }
            int n9 = 1 + n2;
            if (n9 >= (n -= n8)) {
                return 0;
            }
            return n - n9;
        }
        throw new IllegalStateException();
    }

    public static boolean contains(float f, float f2, float f3) {
        int n = Float.floatToIntBits(f);
        int n2 = Float.floatToIntBits(f2);
        int n3 = Float.floatToIntBits(f3);
        if (FloatInterval.isNaN(n) || FloatInterval.isNaN(n2) || FloatInterval.isNaN(n3)) {
            return false;
        }
        boolean bl = (n & Integer.MIN_VALUE) == 0;
        boolean bl2 = (n2 & Integer.MIN_VALUE) == 0;
        boolean bl3 = (n3 & Integer.MIN_VALUE) == 0;
        int n4 = n & Integer.MAX_VALUE;
        int n5 = n2 & Integer.MAX_VALUE;
        int n6 = n3 & Integer.MAX_VALUE;
        return FloatInterval.isSmallerEqual(bl, n4, bl3, n6) && FloatInterval.isSmallerEqual(bl3, n6, bl2, n5);
    }

    public static boolean isSmallerEqual(float f, float f2) {
        int n = Float.floatToIntBits(f);
        int n2 = Float.floatToIntBits(f2);
        if (FloatInterval.isNaN(n) || FloatInterval.isNaN(n2)) {
            return false;
        }
        boolean bl = (n & Integer.MIN_VALUE) == 0;
        boolean bl2 = (n2 & Integer.MIN_VALUE) == 0;
        int n3 = n & Integer.MAX_VALUE;
        int n4 = n2 & Integer.MAX_VALUE;
        return FloatInterval.isSmallerEqual(bl, n3, bl2, n4);
    }

    public static boolean isSmallerEqual(boolean bl, int n, boolean bl2, int n2) {
        if (bl && bl2) {
            return n <= n2;
        }
        if (!bl && bl2) {
            return true;
        }
        if (bl && !bl2) {
            return false;
        }
        return n >= n2;
    }
}

