/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.blocking;

import java.io.Serializable;
import java.util.List;
import org.semanticweb.HermiT.blocking.BlockersCache;
import org.semanticweb.HermiT.blocking.BlockingSignatureCache;
import org.semanticweb.HermiT.blocking.BlockingStrategy;
import org.semanticweb.HermiT.blocking.DirectBlockingChecker;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLOntology;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.model.Variable;
import org.semanticweb.HermiT.tableau.DLClauseEvaluator;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnywhereBlocking
implements BlockingStrategy,
Serializable {
    private static final long serialVersionUID = -2959900333817197464L;
    protected final DirectBlockingChecker m_directBlockingChecker;
    protected final BlockersCache m_currentBlockersCache;
    protected final BlockingSignatureCache m_blockingSignatureCache;
    protected Tableau m_tableau;
    protected boolean m_useBlockingSignatureCache;
    protected Node m_firstChangedNode;

    public AnywhereBlocking(DirectBlockingChecker directBlockingChecker, BlockingSignatureCache blockingSignatureCache) {
        this.m_directBlockingChecker = directBlockingChecker;
        this.m_currentBlockersCache = new BlockersCache(this.m_directBlockingChecker);
        this.m_blockingSignatureCache = blockingSignatureCache;
    }

    @Override
    public void initialize(Tableau tableau) {
        this.m_tableau = tableau;
        this.m_directBlockingChecker.initialize(tableau);
        this.updateBlockingSignatureCacheUsage();
    }

    @Override
    public void additionalDLOntologySet(DLOntology dLOntology) {
        this.updateBlockingSignatureCacheUsage();
    }

    @Override
    public void additionalDLOntologyCleared() {
        this.updateBlockingSignatureCacheUsage();
    }

    protected void updateBlockingSignatureCacheUsage() {
        this.m_useBlockingSignatureCache = this.m_tableau.getAdditionalHyperresolutionManager() == null;
    }

    @Override
    public void clear() {
        this.m_currentBlockersCache.clear();
        this.m_firstChangedNode = null;
        this.m_directBlockingChecker.clear();
    }

    @Override
    public void computeBlocking(boolean bl) {
        if (this.m_firstChangedNode != null) {
            boolean bl2;
            Node node;
            for (node = this.m_firstChangedNode; node != null; node = node.getNextTableauNode()) {
                this.m_currentBlockersCache.removeNode(node);
            }
            boolean bl3 = bl2 = this.m_useBlockingSignatureCache && this.m_blockingSignatureCache != null && !this.m_blockingSignatureCache.isEmpty();
            for (node = this.m_firstChangedNode; node != null; node = node.getNextTableauNode()) {
                if (!node.isActive() || !this.m_directBlockingChecker.canBeBlocked(node) && !this.m_directBlockingChecker.canBeBlocker(node)) continue;
                if (this.m_directBlockingChecker.hasBlockingInfoChanged(node) || !node.isDirectlyBlocked() || node.getBlocker().getNodeID() >= this.m_firstChangedNode.getNodeID()) {
                    Node node2;
                    Node node3 = node.getParent();
                    if (node3 == null) {
                        node.setBlocked(null, false);
                    } else if (node3.isBlocked()) {
                        node.setBlocked(node3, false);
                    } else if (bl2) {
                        if (this.m_blockingSignatureCache.containsSignature(node)) {
                            node.setBlocked(Node.SIGNATURE_CACHE_BLOCKER, true);
                        } else {
                            node.setBlocked(node2, (node2 = this.m_currentBlockersCache.getBlocker(node)) != null);
                        }
                    } else {
                        node.setBlocked(node2, (node2 = this.m_currentBlockersCache.getBlocker(node)) != null);
                    }
                    if (!node.isBlocked() && this.m_directBlockingChecker.canBeBlocker(node)) {
                        this.m_currentBlockersCache.addNode(node);
                    }
                }
                this.m_directBlockingChecker.clearBlockingInfoChanged(node);
            }
            this.m_firstChangedNode = null;
        }
    }

    @Override
    public boolean isPermanentAssertion(Concept concept, Node node) {
        return true;
    }

    @Override
    public boolean isPermanentAssertion(DataRange dataRange, Node node) {
        return true;
    }

    @Override
    public void assertionAdded(Concept concept, Node node, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(concept, node, bl));
    }

    @Override
    public void assertionCoreSet(Concept concept, Node node) {
    }

    @Override
    public void assertionRemoved(Concept concept, Node node, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionRemoved(concept, node, bl));
    }

    @Override
    public void assertionAdded(DataRange dataRange, Node node, boolean bl) {
        this.m_directBlockingChecker.assertionAdded(dataRange, node, bl);
    }

    @Override
    public void assertionCoreSet(DataRange dataRange, Node node) {
    }

    @Override
    public void assertionRemoved(DataRange dataRange, Node node, boolean bl) {
        this.m_directBlockingChecker.assertionRemoved(dataRange, node, bl);
    }

    @Override
    public void assertionAdded(AtomicRole atomicRole, Node node, Node node2, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionAdded(atomicRole, node, node2, bl));
    }

    @Override
    public void nodesMerged(Node node, Node node2) {
        this.updateNodeChange(this.m_directBlockingChecker.nodesMerged(node, node2));
    }

    @Override
    public void nodesUnmerged(Node node, Node node2) {
        this.updateNodeChange(this.m_directBlockingChecker.nodesUnmerged(node, node2));
    }

    @Override
    public void assertionCoreSet(AtomicRole atomicRole, Node node, Node node2) {
    }

    @Override
    public void assertionRemoved(AtomicRole atomicRole, Node node, Node node2, boolean bl) {
        this.updateNodeChange(this.m_directBlockingChecker.assertionRemoved(atomicRole, node, node2, bl));
    }

    @Override
    public void nodeStatusChanged(Node node) {
        this.updateNodeChange(node);
    }

    protected final void updateNodeChange(Node node) {
        if (node != null && (this.m_firstChangedNode == null || node.getNodeID() < this.m_firstChangedNode.getNodeID())) {
            this.m_firstChangedNode = node;
        }
    }

    @Override
    public void nodeInitialized(Node node) {
        this.m_directBlockingChecker.nodeInitialized(node);
    }

    @Override
    public void nodeDestroyed(Node node) {
        this.m_currentBlockersCache.removeNode(node);
        this.m_directBlockingChecker.nodeDestroyed(node);
        if (this.m_firstChangedNode != null && this.m_firstChangedNode.getNodeID() >= node.getNodeID()) {
            this.m_firstChangedNode = null;
        }
    }

    @Override
    public void modelFound() {
        if (this.m_useBlockingSignatureCache && this.m_blockingSignatureCache != null) {
            assert (this.m_firstChangedNode == null);
            for (Node node = this.m_tableau.getFirstTableauNode(); node != null; node = node.getNextTableauNode()) {
                if (!node.isActive() || node.isBlocked() || !this.m_directBlockingChecker.canBeBlocker(node)) continue;
                this.m_blockingSignatureCache.addNode(node);
            }
        }
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public void dlClauseBodyCompiled(List<DLClauseEvaluator.Worker> list, DLClause dLClause, List<Variable> list2, Object[] objectArray, boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
    }
}

