## ----knitr, echo=FALSE, results="hide"-----------------------------------
library("knitr")
opts_chunk$set(tidy=FALSE,
            fig.width=5,fig.height=5,
            message=FALSE)

## ----style, eval=TRUE, echo=FALSE, results="asis"---------------------------------------
BiocStyle::latex()

## ----format-line,eval=FALSE,echo=TRUE---------------------------------------------------
#  seq     name    freq    mir     start   end     mism    add     t5      t3      s5      s3      DB      ambiguity
#  TGTAAACATCCTACACTCAGCTGT        seq_100014_x23  23      hsa-miR-30b-5p  17      40      0       0       0       GT    TTCATGTA        AGCTGTAA        miRNA   1
#  TGTAAACATCCCTGACTGGAA   seq_100019_x4   4       hsa-miR-30d-5p  6       26      13TC    0       0       g     TTGTTGTA        GAAGCTGT        miRNA   2
#  TGTAAACATCCCTGACTGGAA   seq_100019_x4   4       hsa-miR-30e-5p  17      37      12CT    0       0       g     CTACTGTA        GAAGCTGT        miRNA   2
#  CAAATTCGTATCTAGGGGATT   seq_100049_x1   1       hsa-miR-10a-3p  63      81      0       TT    0       ata   GTCACAAA        AATATGTA        miRNA   1
#  TGACCTAGGAATTGACAGCCAGT seq_100060_x1   1       hsa-miR-192-5p  25      47      8GT     0       c     agt   GGCTCTGA        AGCCAGTG        miRNA   1

## ----package-select,message=FALSE-------------------------------------------------------
library(isomiRs)
data(mirData)
head(isoSelect(mirData, mirna="hsa-let-7a-5p", 1000))

## ----package-load,message=FALSE---------------------------------------------------------
library(isomiRs)
data(mirData)

## ----package-plot-iso,message=FALSE,eval=FALSE------------------------------------------
#  ids <- IsomirDataSeqFromFiles(fn_list, design=de)

## ----package-plot-iso-t5,message=FALSE--------------------------------------------------
ids <- isoCounts(mirData)
isoPlot(ids, type="iso5", column = "group")

## ----package-count,message=FALSE--------------------------------------------------------
head(counts(ids))

## ----package-norm,message=FALSE---------------------------------------------------------
ids = isoNorm(ids, formula = ~ group)
heatmap(counts(ids, norm=TRUE)[1:100,], labRow = "")

## ----package-de,message=FALSE-----------------------------------------------------------
dds <- isoDE(ids, formula=~group)
library(DESeq2)
plotMA(dds)
head(results(dds, format="DataFrame"))

## ----package-de-iso5,message=FALSE------------------------------------------------------
dds = isoDE(ids, formula=~group, ref=TRUE, iso5=TRUE)
head(results(dds, tidy=TRUE))

## ----package-de-with-deseq2-------------------------------------------------------------
dds = DESeqDataSetFromMatrix(counts(ids),
                             colData(ids), design = ~ group)

## ----package-pls,eval=TRUE--------------------------------------------------------------
ids = isoCounts(ids, iso5=TRUE, minc=10, mins=6)
ids = isoNorm(ids, formula = ~ group)
pls.ids = isoPLSDA(ids, "group", nperm = 2)
df = isoPLSDAplot(pls.ids)

## ----package-plsplot,message=FALSE,eval=FALSE-------------------------------------------
#  pls.ids = isoPLSDA(ids,"group", refinment = FALSE, vip = 0.8)

## ----sessionInfo,results='asis',echo=FALSE----------------------------------------------
toLatex(sessionInfo())

