### R code from vignette source 'genphenManual.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: sectionTag
###################################################
library(genphen)
genotype <- c("A", "A", "A", "T", "T", "T", "T", "T", "T",
              "T", "T", "T", "A", "A")

phenotype <- c(6.14, 3.95, 6.19, 8.02, 8.07, 7.32, 7.28,
               7.10, 7.10, 8.26, 8.38, 7.48, 5.22, 5.60)


###################################################
### code chunk number 2: sectionTag
###################################################
result <- runGenphenSvm(genotype = genotype,
                        phenotype = phenotype,
                        cv.fold = 0.66,
                        cv.steps = 1000,
                        hdi.level = 0.95)


###################################################
### code chunk number 3: sectionTag
###################################################
result <- runGenphenBayes(genotype = genotype,
                          phenotype = phenotype,
                          chain.nr = 2,
                          mcmc.iter = 1000,
                          model = "tdist",
                          hdi.levels = 0.95)


###################################################
### code chunk number 4: sectionTag
###################################################
library(genphen)
data(genotype.saap)
data(phenotype.saap)

genotype <- genotype.saap[, 82]
phenotype <- phenotype.saap


###################################################
### code chunk number 5: sectionTag
###################################################
result <- runGenphenSvm(genotype = genotype,
                        phenotype = phenotype,
                        cv.fold = 0.66,
                        cv.steps = 1000,
                        hdi.level = 0.95)


###################################################
### code chunk number 6: sectionTag
###################################################
result <- runGenphenBayes(genotype = genotype,
                          phenotype = phenotype,
                          chain.nr = 2,
                          mcmc.iter = 1000,
                          model = "tdist",
                          hdi.levels = 0.95)


###################################################
### code chunk number 7: sectionTag
###################################################
library(genphen)
data(genotype.saap)
# One can also use a multiple sequence alignment as a genotype input (in the
# form of either a DNAMultipleAlignment or AAMultipleAlignment objects of the
# Biostring package).
data(phenotype.saap)


###################################################
### code chunk number 8: sectionTag
###################################################
# if DNAMultipleAlignment is loaded you cannot subset
# with genotype.snp[, 1:10]
genphen.rf <- runGenphenRf(genotype = genotype.saap[, 1:10],
                           phenotype = phenotype.saap,
                           cv.fold = 0.66,
                           cv.steps = 100,
                           hdi.level = 0.99,
                           ntree = 1000)


genphen.svm <- runGenphenSvm(genotype = genotype.saap[, 1:10],
                             phenotype = phenotype.saap,
                             cv.fold = 0.66,
                             cv.steps = 100,
                             hdi.level = 0.99)


###################################################
### code chunk number 9: sectionTag
###################################################
genphen.rf <- genphen.rf[complete.cases(genphen.rf), ]
genphen.svm <- genphen.svm[complete.cases(genphen.svm), ]


###################################################
### code chunk number 10: genphenManual.Rnw:615-616
###################################################
plotGenphenRfSvm(genphen.results = genphen.rf)


###################################################
### code chunk number 11: genphenManual.Rnw:624-625
###################################################
plotGenphenRfSvm(genphen.results = genphen.svm)


###################################################
### code chunk number 12: genphenManual.Rnw:635-636
###################################################
plotManhattan(genphen.results = genphen.rf)


###################################################
### code chunk number 13: sectionTag
###################################################
# if DNAMultipleAlignment is loaded you cannot subset
# with genotype.snp[, 1:10]
genphen.bayes <- runGenphenBayes(genotype = genotype.saap[, 1:10],
                                 phenotype = phenotype.saap,
                                 chain.nr = 2,
                                 mcmc.iter = 1000,
                                 model = "tdist",
                                 hdi.levels = c(0.90, 0.95, 0.99))


###################################################
### code chunk number 14: sectionTag
###################################################
genphen.bayes <- genphen.bayes[complete.cases(genphen.bayes), ]


###################################################
### code chunk number 15: genphenManual.Rnw:665-666
###################################################
plotGenphenBayes(genphen.results = genphen.bayes, hdi = 0.9)


###################################################
### code chunk number 16: genphenManual.Rnw:674-675
###################################################
plotManhattan(genphen.results = genphen.bayes)


###################################################
### code chunk number 17: genphenManual.Rnw:685-688
###################################################
plotSpecificGenotype(genotype = genotype.saap,
                     phenotype = phenotype.saap,
                     index = 9)


