/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.boss;

public class TileCalculator {
    int windowWidth;
    int windowHeight;
    int numberOfWindows;
    int cellWidth;
    int cellHeight;
    int rowCount;
    int columnCount;
    int TITLE_BAR_HEIGHT_ALLOWANCE = 20;
    int CELL_SIDE_GAP = 10;
    int CELL_TOP_GAP = 10;
    int X_EDGE_GAP = 5;
    int Y_EDGE_GAP = 5;
    int YGap = 10;
    int XGap = 10;

    public TileCalculator(int width, int height, int numberOfWindows) {
        this.calculateGrid(numberOfWindows);
        this.windowWidth = width - (1 + this.columnCount) * this.XGap;
        this.windowHeight = height - (1 + this.rowCount) * this.YGap;
        this.calculateWindowSize();
    }

    public int[] getGeometry(int windowNumber) {
        int[] rowAndColumn = this.getRowAndColumn(windowNumber);
        int row = rowAndColumn[0];
        int column = rowAndColumn[1];
        int x = this.XGap + column * (this.cellWidth + this.XGap);
        int y = this.YGap + row * (this.cellHeight + this.YGap);
        int width = this.cellWidth - this.XGap;
        int height = this.cellHeight;
        int[] result = new int[]{x, y, width, height};
        return result;
    }

    public int[] getRowAndColumn(int windowNumber) {
        int row = new Integer(windowNumber / this.columnCount);
        int column = windowNumber - row * this.columnCount;
        return new int[]{row, column};
    }

    public int getTitleBarHeight() {
        return this.TITLE_BAR_HEIGHT_ALLOWANCE;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    protected void calculateGrid(int numberOfWindows) {
        int cols;
        int squareRoot = (int)Math.sqrt(numberOfWindows);
        int rows = squareRoot;
        if (rows * (cols = squareRoot) < numberOfWindows) {
            ++cols;
        }
        if (rows * cols < numberOfWindows) {
            ++rows;
        }
        this.rowCount = rows;
        this.columnCount = cols;
    }

    protected void calculateWindowSize() {
        this.cellWidth = this.windowWidth / this.columnCount;
        this.cellHeight = this.windowHeight / this.rowCount;
    }
}

