## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(dpi = 300)
knitr::opts_chunk$set(cache=FALSE)

## ---- eval = TRUE, echo = FALSE,hide=TRUE, message=FALSE,warning=FALSE----
devtools::load_all()

## ---- eval = FALSE-------------------------------------------------------
#  source("https://bioconductor.org/biocLite.R")
#  biocLite("SpidermiR")

## ---- eval = TRUE--------------------------------------------------------

org<-SpidermiRquery_species(species)

## ---- eval = TRUE, echo = FALSE------------------------------------------
knitr::kable(org, digits = 2,
             caption = "List of species",row.names = TRUE)

## ---- eval = TRUE--------------------------------------------------------
net_type<-SpidermiRquery_networks_type(organismID=org[9,])

## ---- eval = TRUE, echo = FALSE------------------------------------------
net_type

## ---- eval = TRUE--------------------------------------------------------

net_shar_prot<-SpidermiRquery_spec_networks(organismID = org[9,],
                                    network = "SHpd")

## ---- eval = TRUE, echo = FALSE------------------------------------------
net_shar_prot

## ---- eval = TRUE--------------------------------------------------------
disease<-SpidermiRquery_disease(diseaseID)

## ---- eval = TRUE, echo = FALSE------------------------------------------
disease

## ---- eval = TRUE--------------------------------------------------------
out_net<-SpidermiRdownload_net(net_shar_prot)

## ---- eval = TRUE, echo = FALSE------------------------------------------
str(out_net)

## ---- eval = FALSE-------------------------------------------------------
#  mirna<-c('hsa-miR-567','hsa-miR-566')
#  SpidermiRdownload_miRNAprediction(mirna_list=mirna)

## ---- eval = FALSE-------------------------------------------------------
#  list<-SpidermiRdownload_miRNAvalidate(validated)

## ---- eval = FALSE-------------------------------------------------------
#  list<-SpidermiRdownload_miRNAextra_cir(miRNAextra_cir)

## ---- eval = TRUE--------------------------------------------------------
mir_pharmaco<-SpidermiRdownload_pharmacomir(pharmacomir=pharmacomir)

## ---- eval = TRUE--------------------------------------------------------

geneSymb_net<-SpidermiRprepare_NET(organismID = org[9,],
                                    data = out_net)

## ---- eval = TRUE, echo = FALSE------------------------------------------
knitr::kable(geneSymb_net[[1]][1:5,c(1,2,3,5,8)], digits = 2,
             caption = "shared protein domain",row.names = FALSE)

## ---- eval = TRUE--------------------------------------------------------
miRNA_NET<-SpidermiRanalyze_mirna_network(data=geneSymb_net,disease="prostate cancer",miR_trg="val")

## ---- eval = TRUE, echo = FALSE------------------------------------------
str(miRNA_NET)

## ---- eval = FALSE-------------------------------------------------------
#  miRNA_complNET<-SpidermiRanalyze_mirna_gene_complnet(data=geneSymb_net,disease="prostate cancer",miR_trg="val")

## ---- eval = TRUE--------------------------------------------------------
mir_pharmnet<-SpidermiRanalyze_mirnanet_pharm(mir_ph=mir_pharmaco,net=miRNA_NET)

## ---- eval = FALSE-------------------------------------------------------
#  miRNA_NET_ext_circmT<-SpidermiRanalyze_mirna_extra_cir(data=miRNA_complNET,"mT")

## ---- eval = FALSE-------------------------------------------------------
#  miRNA_NET_ext_circmCT<-SpidermiRanalyze_mirna_extra_cir(data=miRNA_complNET,"mCT")

## ---- eval = TRUE--------------------------------------------------------
biomark_of_interest<-c("hsa-miR-214","PTEN","FOXO1","hsa-miR-27a")

GIdirect_net<-SpidermiRanalyze_direct_net(data=miRNA_NET,BI=biomark_of_interest)

## ---- eval = TRUE, echo = FALSE------------------------------------------
str(GIdirect_net)

## ---- eval = FALSE-------------------------------------------------------
#  
#  subnet<-SpidermiRanalyze_direct_subnetwork(data=miRNA_NET,BI=biomark_of_interest)
#  

## ---- eval = FALSE-------------------------------------------------------
#  
#  GIdirect_net_neigh<-SpidermiRanalyze_subnetwork_neigh(data=miRNA_NET,BI=biomark_of_interest)

## ---- eval = FALSE-------------------------------------------------------
#  top10_cent_gene<-SpidermiRanalyze_degree_centrality(miRNA_NET,cut=10)

## ---- eval = FALSE-------------------------------------------------------
#  comm<-  SpidermiRanalyze_Community_detection(data=miRNA_NET,type="FC")

## ---- eval = FALSE-------------------------------------------------------
#  cd_net<-SpidermiRanalyze_Community_detection_net(data=miRNA_NET,comm_det=comm,size=1)

## ---- eval = FALSE-------------------------------------------------------
#  gi=c("CF","ROCK1","KIT","CCND2")
#  mol<-SpidermiRanalyze_Community_detection_bi(data=comm,BI=gi)

## ---- eval = TRUE--------------------------------------------------------
miRNA_cN <-data.frame(gA=c('IGFL3','GABRA1'),gB=c('IGFL2','KRT13'),stringsAsFactors=FALSE)
tumour<-c("TCGA-E9-A1RD-01A","TCGA-E9-A1RC-01A")
normal<-c("TCGA-BH-A18P-11A","TCGA-BH-A18L-11A") 
de_int<-SpidermiRanalyze_DEnetworkTCGA(data=miRNA_cN,
                                        TCGAmatrix=Data_CANCER_normUQ_filt,
                                        tumour,
                                        normal
                                       )

## ---- eval = TRUE--------------------------------------------------------
library(networkD3)

SpidermiRvisualize_mirnanet(data=mir_pharmnet[sample(nrow(mir_pharmnet), 100), ] )

## ---- eval = TRUE--------------------------------------------------------

biomark_of_interest<-c("hsa-let-7b","MUC1","PEX7","hsa-miR-222")
SpidermiRvisualize_BI(data=mir_pharmnet[sample(nrow(mir_pharmnet), 100), ],BI=biomark_of_interest)

## ---- eval = TRUE--------------------------------------------------------
library(visNetwork)

SpidermiRvisualize_direction(data=mir_pharmnet[sample(nrow(mir_pharmnet), 100), ] )

## ---- eval = TRUE--------------------------------------------------------

SpidermiRvisualize_plot_target(data=miRNA_NET[1:15,])

## ----fig.width=4, fig.height=4, eval = TRUE------------------------------
SpidermiRvisualize_degree_dist(data=miRNA_NET)

## ---- fig.width=10, fig.height=10,eval = TRUE----------------------------
SpidermiRvisualize_adj_matrix(data=miRNA_NET[1:30,])

## ----fig.width=4, fig.height=4, eval = TRUE------------------------------
SpidermiRvisualize_3Dbarplot(Edges_1net=1041003,Edges_2net=100016,Edges_3net=3008,Edges_4net=1493,Edges_5net=1598,NODES_1net=16502,NODES_2net=13338,NODES_3net=1429,NODES_4net=675,NODES_5net=712,nmiRNAs_1net=0,nmiRNAs_2net=74,nmiRNAs_3net=0,nmiRNAs_4net=0,nmiRNAs_5net=37)

## ---- eval = TRUE,echo = FALSE-------------------------------------------
B<-matrix( c("Gene network", "Validated miRNA-target","","", "Predicted miRNA-target","","","", "Extracellular Circulating microRNAs", "miRNA-disease", "Drug Associations",
      
             "GeneMania", "miRTAR", "miRwalk","miRTarBase", "DIANA", "Miranda", "PicTar","TargetScan","miRandola","miR2disease","Pharmaco-miR",
             
             "Current","N/A","miRwalk2","miRTarBase 6.1","DIANA- 5.0","N/A","N/A","TargetScan7.1","miRandola v 02/2017","N/A","N/A",
             2016,2009,2015,"N/A",2013,2010,"N/A","2016",2017,2009,"N/A",
             "http://genemania.org/data/current/","http://watson.compbio.iupui.edu:8080/miR2Disease/download/miRtar.txt","http://zmf.umm.uni-heidelberg.de/apps/zmf/mirwalk2/downloads/vtm/hsa-vtm-gene.rdata.zip","http://mirtarbase.mbc.nctu.edu.tw/cache/download/6.1/miRTarBase_SE_WR.xls","https://bioconductor.org/packages/release/bioc/html/miRNAtap.html","https://bioconductor.org/packages/release/bioc/html/miRNAtap.html","https://bioconductor.org/packages/release/bioc/html/miRNAtap.html","https://bioconductor.org/packages/release/bioc/html/miRNAtap.html","http://mirandola.iit.cnr.it/download/miRandola_version_02_2017.txt","http://watson.compbio.iupui.edu:8080/miR2Disease/download/AllEntries.txt","http://pharmaco-mir.org/home/download_VERSE_db/pharmacomir_VERSE_DB.csv"
             
             ), nrow=11, ncol=5)
colnames(B)<-c("CATEGORY","EXTERNAL DATABASE","VERSION","LAST UPDATE","LINK")


## ---- eval = TRUE, echo = FALSE------------------------------------------
knitr::kable(B, digits = 2,
             caption = "Features",row.names = FALSE)

## ---- eval = FALSE-------------------------------------------------------
#  
#  a<-Case_Study1_loading_1_network(species)
#  b<-Case_Study1_loading_2_network(data=a)
#  c<-Case_Study1_loading_3_network(data=b,dataFilt=dataFilt,dataClin=dataClin)
#  d<-Case_Study1_loading_4_network(TERZA_NET=c)
#  

## ---- eval = FALSE-------------------------------------------------------
#  a2<-Case_Study2_loading_1_network(species)
#  b2<-Case_Study2_loading_2_network(data=a2)
#  c2<-Case_Study2_loading_3_network(sdas=a2,miRNA_NET=b2)

## ----sessionInfo---------------------------------------------------------
sessionInfo()

