## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()

## ----load, message=FALSE-------------------------------------------------
library(Rqc)

## ----file_loc------------------------------------------------------------
folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")

## ---- rqc, eval=FALSE----------------------------------------------------
#  rqc(path = folder, pattern = ".fastq.gz")

## ----example, echo=FALSE, message=FALSE----------------------------------
library(knitr)
fastqDir <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
files <- list.files(fastqDir, "fastq.gz", full.names=TRUE)
qa <- rqcQA(files, workers=1)

## ------------------------------------------------------------------------
kable(perFileInformation(qa))

## ----read-mean-dist, fig.width=10----------------------------------------
rqcReadQualityBoxPlot(qa)

## ----average-quality-plot, fig.width=10----------------------------------
rqcReadQualityPlot(qa)

## ----cycle-average-quality-plot, fig.width=10----------------------------
rqcCycleAverageQualityPlot(qa)

## ----readfrequency, fig.width=10-----------------------------------------
rqcReadFrequencyPlot(qa)

## ----heatmap-reads, fig.width=10-----------------------------------------
rqcFileHeatmap(qa[[1]])

## ----read-width-plot, fig.width=10---------------------------------------
rqcReadWidthPlot(qa)

## ----cycle-gc-plot, fig.width=10-----------------------------------------
rqcCycleGCPlot(qa)

## ----cycle-quality-plots, fig.width=10-----------------------------------
rqcCycleQualityPlot(qa)

## ----biplot, fig.width=10------------------------------------------------
rqcCycleAverageQualityPcaPlot(qa)

## ----cycle-quality-boxplots, fig.width=10--------------------------------
rqcCycleQualityBoxPlot(qa)

## ----cycle-basecall-plots, fig.width=10----------------------------------
rqcCycleBaseCallsPlot(qa)

## ----cycle-basecall-lineplots, fig.width=10------------------------------
rqcCycleBaseCallsLinePlot(qa)

## ----input---------------------------------------------------------------
fastqDir <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
files <- list.files(fastqDir, "fastq.gz", full.names=TRUE)

## ----rqcQA---------------------------------------------------------------
qa <- rqcQA(files, workers=1)

## ----report, eval=FALSE--------------------------------------------------
#  reportFile <- rqcReport(qa)
#  browseURL(reportFile)

## ----calc----------------------------------------------------------------
df <- rqcCycleAverageQualityCalc(qa)
cycle <- as.numeric(levels(df$cycle))[df$cycle]
plot(cycle, df$quality, col = df$filename, xlab='Cycle', ylab='Quality Score')

## ----subset, fig.width=10------------------------------------------------
sublist <- qa[1]
rqcCycleQualityPlot(sublist)

## ----default-report-path, eval=FALSE-------------------------------------
#  system.file(package = "Rqc", "templates", "rqc_report.Rmd")

## ----rqc-report-custom-template, eval=FALSE------------------------------
#  rqcReport(qa, templateFile = "custom_report.Rmd")

## ------------------------------------------------------------------------
sessionInfo()

