/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.map;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.collection.CompositeCollection;
import org.apache.commons.collections15.set.CompositeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeMap<K, V>
implements Map<K, V> {
    private Map[] composite;
    private MapMutator<K, V> mutator;

    public CompositeMap() {
        this(new Map[0], null);
    }

    public CompositeMap(Map<? extends K, ? extends V> one, Map<? extends K, ? extends V> two) {
        this(new Map[]{one, two}, null);
    }

    public CompositeMap(Map<? extends K, ? extends V> one, Map<? extends K, ? extends V> two, MapMutator<K, V> mutator) {
        this(new Map[]{one, two}, mutator);
    }

    public CompositeMap(Map[] composite) {
        this(composite, null);
    }

    public CompositeMap(Map[] composite, MapMutator<K, V> mutator) {
        this.mutator = mutator;
        this.composite = new Map[0];
        for (int i = composite.length - 1; i >= 0; --i) {
            this.addComposited(composite[i]);
        }
    }

    public void setMutator(MapMutator<K, V> mutator) {
        this.mutator = mutator;
    }

    public synchronized void addComposited(Map<? extends K, ? extends V> map) throws IllegalArgumentException {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            Collection<K> intersect = CollectionUtils.intersection(this.composite[i].keySet(), map.keySet());
            if (intersect.size() == 0) continue;
            if (this.mutator == null) {
                throw new IllegalArgumentException("Key collision adding Map to CompositeMap");
            }
            this.mutator.resolveCollision(this, this.composite[i], map, intersect);
        }
        Map[] temp = new Map[this.composite.length + 1];
        System.arraycopy(this.composite, 0, temp, 0, this.composite.length);
        temp[temp.length - 1] = map;
        this.composite = temp;
    }

    public synchronized Map<? extends K, ? extends V> removeComposited(Map<? extends K, ? extends V> map) {
        int size = this.composite.length;
        for (int i = 0; i < size; ++i) {
            if (!((Object)this.composite[i]).equals(map)) continue;
            Map[] temp = new Map[size - 1];
            System.arraycopy(this.composite, 0, temp, 0, i);
            System.arraycopy(this.composite, i + 1, temp, i, size - i - 1);
            this.composite = temp;
            return map;
        }
        return null;
    }

    @Override
    public void clear() {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            this.composite[i].clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set entrySet() {
        CompositeSet entries = new CompositeSet();
        for (int i = this.composite.length - 1; i >= 0; --i) {
            entries.addComposited(this.composite[i].entrySet());
        }
        return entries;
    }

    @Override
    public V get(Object key) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsKey(key)) continue;
            return this.composite[i].get(key);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (this.composite[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set keySet() {
        CompositeSet keys = new CompositeSet();
        for (int i = this.composite.length - 1; i >= 0; --i) {
            keys.addComposited(this.composite[i].keySet());
        }
        return keys;
    }

    @Override
    public V put(K key, V value) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("No mutator specified");
        }
        return this.mutator.put(this, this.composite, key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("No mutator specified");
        }
        this.mutator.putAll(this, this.composite, map);
    }

    @Override
    public V remove(Object key) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsKey(key)) continue;
            return this.composite[i].remove(key);
        }
        return null;
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = this.composite.length - 1; i >= 0; --i) {
            size += this.composite[i].size();
        }
        return size;
    }

    @Override
    public Collection<V> values() {
        CompositeCollection keys = new CompositeCollection();
        for (int i = this.composite.length - 1; i >= 0; --i) {
            keys.addComposited(this.composite[i].values());
        }
        return keys;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return ((Object)this.entrySet()).equals(map.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            code += i.next().hashCode();
        }
        return code;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MapMutator<K, V> {
        public void resolveCollision(CompositeMap<K, V> var1, Map<? extends K, ? extends V> var2, Map<? extends K, ? extends V> var3, Collection<K> var4);

        public V put(CompositeMap<K, V> var1, Map[] var2, K var3, V var4);

        public void putAll(CompositeMap<K, V> var1, Map[] var2, Map<? extends K, ? extends V> var3);
    }
}

