/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout.hierarchical.stage;

import com.mxgraph.layout.hierarchical.model.mxGraphAbstractHierarchyCell;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyEdge;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyModel;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyNode;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyRank;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.hierarchical.stage.mxHierarchicalLayoutStage;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxCoordinateAssignment
implements mxHierarchicalLayoutStage {
    protected mxHierarchicalLayout layout;
    protected double intraCellSpacing = 30.0;
    protected double interRankCellSpacing = 30.0;
    protected double parallelEdgeSpacing = 10.0;
    protected int maxIterations = 8;
    protected int orientation = 1;
    protected double initialX;
    protected double limitX;
    protected double currentXDelta;
    protected int widestRank;
    protected double widestRankValue;
    protected double[] rankWidths;
    protected double[] rankY;
    protected boolean fineTuning = true;
    protected boolean disableEdgeStyle = true;
    protected mxGraphAbstractHierarchyCell[][] nextLayerConnectedCache;
    protected mxGraphAbstractHierarchyCell[][] previousLayerConnectedCache;
    private static Logger logger = Logger.getLogger("com.jgraph.layout.hierarchical.JGraphCoordinateAssignment");

    public mxCoordinateAssignment(mxHierarchicalLayout mxHierarchicalLayout2, double d, double d2, int n, double d3, double d4) {
        this.layout = mxHierarchicalLayout2;
        this.intraCellSpacing = d;
        this.interRankCellSpacing = d2;
        this.orientation = n;
        this.initialX = d3;
        this.parallelEdgeSpacing = d4;
        this.setLoggerLevel(Level.OFF);
    }

    @Override
    public void execute(Object object) {
        mxGraphHierarchyModel mxGraphHierarchyModel2 = this.layout.getModel();
        this.currentXDelta = 0.0;
        this.initialCoords(this.layout.getGraph(), mxGraphHierarchyModel2);
        if (this.fineTuning) {
            this.minNode(mxGraphHierarchyModel2);
        }
        double d = 1.0E8;
        if (this.fineTuning) {
            for (int i = 0; i < this.maxIterations; ++i) {
                mxGraphHierarchyRank mxGraphHierarchyRank2;
                int n;
                if (i != 0) {
                    this.medianPos(i, mxGraphHierarchyModel2);
                    this.minNode(mxGraphHierarchyModel2);
                }
                if (this.currentXDelta < d) {
                    for (n = 0; n < mxGraphHierarchyModel2.ranks.size(); ++n) {
                        mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n));
                        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : mxGraphHierarchyRank2) {
                            mxGraphAbstractHierarchyCell2.setX(n, mxGraphAbstractHierarchyCell2.getGeneralPurposeVariable(n));
                        }
                    }
                    d = this.currentXDelta;
                } else {
                    for (n = 0; n < mxGraphHierarchyModel2.ranks.size(); ++n) {
                        mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n));
                        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : mxGraphHierarchyRank2) {
                            mxGraphAbstractHierarchyCell2.setGeneralPurposeVariable(n, (int)mxGraphAbstractHierarchyCell2.getX(n));
                        }
                    }
                }
                this.currentXDelta = 0.0;
            }
        }
        this.setCellLocations(this.layout.getGraph(), mxGraphHierarchyModel2);
    }

    private void minNode(mxGraphHierarchyModel mxGraphHierarchyModel2) {
        Object object;
        Object object2;
        int n;
        int n2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Object[][] objectArrayArray = new Object[mxGraphHierarchyModel2.maxRank + 1][];
        for (n2 = 0; n2 <= mxGraphHierarchyModel2.maxRank; ++n2) {
            mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n2));
            objectArrayArray[n2] = mxGraphHierarchyRank2.toArray();
            n = 0;
            while (n < objectArrayArray[n2].length) {
                object2 = (mxGraphAbstractHierarchyCell)objectArrayArray[n2][n];
                object = new WeightedCellSorter((mxGraphAbstractHierarchyCell)object2, n2);
                ((WeightedCellSorter)object).rankIndex = n++;
                ((WeightedCellSorter)object).visited = true;
                linkedList.add(object);
                hashtable.put(object2, object);
            }
        }
        n2 = linkedList.size() * 10;
        n = 1;
        for (int i = 0; !linkedList.isEmpty() && i <= n2; ++i) {
            object2 = (WeightedCellSorter)linkedList.getFirst();
            object = ((WeightedCellSorter)object2).cell;
            int n3 = ((WeightedCellSorter)object2).weightedValue;
            int n4 = ((WeightedCellSorter)object2).rankIndex;
            Object[] objectArray = ((mxGraphAbstractHierarchyCell)object).getNextLayerConnectedCells(n3).toArray();
            Object[] objectArray2 = ((mxGraphAbstractHierarchyCell)object).getPreviousLayerConnectedCells(n3).toArray();
            int n5 = objectArray.length;
            int n6 = objectArray2.length;
            int n7 = this.medianXValue(objectArray, n3 + 1);
            int n8 = this.medianXValue(objectArray2, n3 - 1);
            int n9 = n5 + n6;
            int n10 = ((mxGraphAbstractHierarchyCell)object).getGeneralPurposeVariable(n3);
            double d = n10;
            if (n9 > 0) {
                d = (n7 * n5 + n8 * n6) / n9;
            }
            boolean bl = false;
            if (d < (double)(n10 - n)) {
                if (n4 == 0) {
                    ((mxGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, (int)d);
                    bl = true;
                } else {
                    mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 = (mxGraphAbstractHierarchyCell)objectArrayArray[n3][n4 - 1];
                    int n11 = mxGraphAbstractHierarchyCell2.getGeneralPurposeVariable(n3);
                    if ((double)(n11 = n11 + (int)mxGraphAbstractHierarchyCell2.width / 2 + (int)this.intraCellSpacing + (int)((mxGraphAbstractHierarchyCell)object).width / 2) < d) {
                        ((mxGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, (int)d);
                        bl = true;
                    } else if (n11 < ((mxGraphAbstractHierarchyCell)object).getGeneralPurposeVariable(n3) - n) {
                        ((mxGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, n11);
                        bl = true;
                    }
                }
            } else if (d > (double)(n10 + n)) {
                int n12 = objectArrayArray[n3].length;
                if (n4 == n12 - 1) {
                    ((mxGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, (int)d);
                    bl = true;
                } else {
                    mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3 = (mxGraphAbstractHierarchyCell)objectArrayArray[n3][n4 + 1];
                    int n13 = mxGraphAbstractHierarchyCell3.getGeneralPurposeVariable(n3);
                    if ((double)(n13 = n13 - (int)mxGraphAbstractHierarchyCell3.width / 2 - (int)this.intraCellSpacing - (int)((mxGraphAbstractHierarchyCell)object).width / 2) > d) {
                        ((mxGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, (int)d);
                        bl = true;
                    } else if (n13 > ((mxGraphAbstractHierarchyCell)object).getGeneralPurposeVariable(n3) + n) {
                        ((mxGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, n13);
                        bl = true;
                    }
                }
            }
            if (bl) {
                int n14;
                for (n14 = 0; n14 < objectArray.length; ++n14) {
                    mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell4 = (mxGraphAbstractHierarchyCell)objectArray[n14];
                    WeightedCellSorter weightedCellSorter = (WeightedCellSorter)hashtable.get(mxGraphAbstractHierarchyCell4);
                    if (weightedCellSorter == null || weightedCellSorter.visited) continue;
                    weightedCellSorter.visited = true;
                    linkedList.add(weightedCellSorter);
                }
                for (n14 = 0; n14 < objectArray2.length; ++n14) {
                    mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell5 = (mxGraphAbstractHierarchyCell)objectArray2[n14];
                    WeightedCellSorter weightedCellSorter = (WeightedCellSorter)hashtable.get(mxGraphAbstractHierarchyCell5);
                    if (weightedCellSorter == null || weightedCellSorter.visited) continue;
                    weightedCellSorter.visited = true;
                    linkedList.add(weightedCellSorter);
                }
            }
            linkedList.removeFirst();
            ((WeightedCellSorter)object2).visited = false;
        }
    }

    private void medianPos(int n, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        boolean bl;
        boolean bl2 = bl = n % 2 == 0;
        if (bl) {
            for (int i = mxGraphHierarchyModel2.maxRank; i > 0; --i) {
                this.rankMedianPosition(i - 1, mxGraphHierarchyModel2, i);
            }
        } else {
            for (int i = 0; i < mxGraphHierarchyModel2.maxRank - 1; ++i) {
                this.rankMedianPosition(i + 1, mxGraphHierarchyModel2, i);
            }
        }
    }

    protected void rankMedianPosition(int n, mxGraphHierarchyModel mxGraphHierarchyModel2, int n2) {
        List<mxGraphAbstractHierarchyCell> list;
        int n3;
        mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n));
        Object[] objectArray = mxGraphHierarchyRank2.toArray();
        Object[] objectArray2 = new WeightedCellSorter[objectArray.length];
        Hashtable<mxGraphAbstractHierarchyCell, Object> hashtable = new Hashtable<mxGraphAbstractHierarchyCell, Object>(objectArray.length);
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 = (mxGraphAbstractHierarchyCell)objectArray[n3];
            objectArray2[n3] = new WeightedCellSorter();
            ((WeightedCellSorter)objectArray2[n3]).cell = mxGraphAbstractHierarchyCell2;
            ((WeightedCellSorter)objectArray2[n3]).rankIndex = n3;
            hashtable.put(mxGraphAbstractHierarchyCell2, objectArray2[n3]);
            list = null;
            list = n2 < n ? mxGraphAbstractHierarchyCell2.getPreviousLayerConnectedCells(n) : mxGraphAbstractHierarchyCell2.getNextLayerConnectedCells(n);
            ((WeightedCellSorter)objectArray2[n3]).weightedValue = this.calculatedWeightedValue(mxGraphAbstractHierarchyCell2, list);
        }
        Arrays.sort(objectArray2);
        for (n3 = 0; n3 < objectArray2.length; ++n3) {
            int n4 = 0;
            list = ((WeightedCellSorter)objectArray2[n3]).cell;
            Object[] objectArray3 = null;
            int n5 = 0;
            objectArray3 = n2 < n ? ((mxGraphAbstractHierarchyCell)((Object)list)).getPreviousLayerConnectedCells(n).toArray() : ((mxGraphAbstractHierarchyCell)((Object)list)).getNextLayerConnectedCells(n).toArray();
            if (objectArray3 != null) {
                n4 = objectArray3.length;
                n5 = n4 > 0 ? this.medianXValue(objectArray3, n2) : ((mxGraphAbstractHierarchyCell)((Object)list)).getGeneralPurposeVariable(n);
            }
            double d = 0.0;
            double d2 = -1.0E8;
            int n6 = ((WeightedCellSorter)objectArray2[n3]).rankIndex - 1;
            while (n6 >= 0) {
                WeightedCellSorter weightedCellSorter = (WeightedCellSorter)hashtable.get(objectArray[n6]);
                if (weightedCellSorter == null) continue;
                mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3 = weightedCellSorter.cell;
                if (weightedCellSorter.visited) {
                    d2 = (double)mxGraphAbstractHierarchyCell3.getGeneralPurposeVariable(n) + mxGraphAbstractHierarchyCell3.width / 2.0 + this.intraCellSpacing + d + ((mxGraphAbstractHierarchyCell)((Object)list)).width / 2.0;
                    n6 = -1;
                    continue;
                }
                d += mxGraphAbstractHierarchyCell3.width + this.intraCellSpacing;
                --n6;
            }
            double d3 = 0.0;
            double d4 = 1.0E8;
            int n7 = ((WeightedCellSorter)objectArray2[n3]).rankIndex + 1;
            while (n7 < objectArray2.length) {
                WeightedCellSorter weightedCellSorter = (WeightedCellSorter)hashtable.get(objectArray[n7]);
                if (weightedCellSorter == null) continue;
                mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell4 = weightedCellSorter.cell;
                if (weightedCellSorter.visited) {
                    d4 = (double)mxGraphAbstractHierarchyCell4.getGeneralPurposeVariable(n) - mxGraphAbstractHierarchyCell4.width / 2.0 - this.intraCellSpacing - d3 - ((mxGraphAbstractHierarchyCell)((Object)list)).width / 2.0;
                    n7 = objectArray2.length;
                    continue;
                }
                d3 += mxGraphAbstractHierarchyCell4.width + this.intraCellSpacing;
                ++n7;
            }
            if ((double)n5 >= d2 && (double)n5 <= d4) {
                ((mxGraphAbstractHierarchyCell)((Object)list)).setGeneralPurposeVariable(n, n5);
            } else if ((double)n5 < d2) {
                ((mxGraphAbstractHierarchyCell)((Object)list)).setGeneralPurposeVariable(n, (int)d2);
                this.currentXDelta += d2 - (double)n5;
            } else if ((double)n5 > d4) {
                ((mxGraphAbstractHierarchyCell)((Object)list)).setGeneralPurposeVariable(n, (int)d4);
                this.currentXDelta += (double)n5 - d4;
            }
            ((WeightedCellSorter)objectArray2[n3]).visited = true;
        }
    }

    private int calculatedWeightedValue(mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2, Collection<mxGraphAbstractHierarchyCell> collection) {
        int n = 0;
        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3 : collection) {
            if (mxGraphAbstractHierarchyCell2.isVertex() && mxGraphAbstractHierarchyCell3.isVertex()) {
                ++n;
                continue;
            }
            if (mxGraphAbstractHierarchyCell2.isEdge() && mxGraphAbstractHierarchyCell3.isEdge()) {
                n += 8;
                continue;
            }
            n += 2;
        }
        return n;
    }

    private int medianXValue(Object[] objectArray, int n) {
        int n2;
        if (objectArray.length == 0) {
            return 0;
        }
        int[] nArray = new int[objectArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            nArray[n2] = ((mxGraphAbstractHierarchyCell)objectArray[n2]).getGeneralPurposeVariable(n);
        }
        Arrays.sort(nArray);
        if (objectArray.length % 2 == 1) {
            return nArray[objectArray.length / 2];
        }
        n2 = objectArray.length / 2;
        int n3 = nArray[n2 - 1];
        int n4 = nArray[n2];
        return (n3 + n4) / 2;
    }

    private void initialCoords(mxGraph mxGraph2, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        int n;
        this.calculateWidestRank(mxGraph2, mxGraphHierarchyModel2);
        for (n = this.widestRank; n >= 0; --n) {
            if (n >= mxGraphHierarchyModel2.maxRank) continue;
            this.rankCoordinates(n, mxGraph2, mxGraphHierarchyModel2);
        }
        for (n = this.widestRank + 1; n <= mxGraphHierarchyModel2.maxRank; ++n) {
            if (n <= 0) continue;
            this.rankCoordinates(n, mxGraph2, mxGraphHierarchyModel2);
        }
    }

    protected void rankCoordinates(int n, mxGraph mxGraph2, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(n));
        double d = 0.0;
        double d2 = this.initialX + (this.widestRankValue - this.rankWidths[n]) / 2.0;
        boolean bl = false;
        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : mxGraphHierarchyRank2) {
            mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3;
            if (mxGraphAbstractHierarchyCell2.isVertex()) {
                mxGraphAbstractHierarchyCell3 = (mxGraphHierarchyNode)mxGraphAbstractHierarchyCell2;
                mxRectangle mxRectangle2 = this.layout.getVertexBounds(mxGraphAbstractHierarchyCell3.cell);
                if (mxRectangle2 != null) {
                    if (this.orientation == 1 || this.orientation == 5) {
                        mxGraphAbstractHierarchyCell2.width = mxRectangle2.getWidth();
                        mxGraphAbstractHierarchyCell2.height = mxRectangle2.getHeight();
                    } else {
                        mxGraphAbstractHierarchyCell2.width = mxRectangle2.getHeight();
                        mxGraphAbstractHierarchyCell2.height = mxRectangle2.getWidth();
                    }
                } else {
                    bl = true;
                }
                d = Math.max(d, mxGraphAbstractHierarchyCell2.height);
            } else if (mxGraphAbstractHierarchyCell2.isEdge()) {
                mxGraphAbstractHierarchyCell3 = (mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell2;
                int n2 = 1;
                if (((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).edges != null) {
                    n2 = ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).edges.size();
                } else {
                    logger.info("edge.edges is null");
                }
                mxGraphAbstractHierarchyCell2.width = (double)(n2 - 1) * this.parallelEdgeSpacing;
            }
            mxGraphAbstractHierarchyCell2.setX(n, d2 += mxGraphAbstractHierarchyCell2.width / 2.0);
            mxGraphAbstractHierarchyCell2.setGeneralPurposeVariable(n, (int)d2);
            d2 += mxGraphAbstractHierarchyCell2.width / 2.0;
            d2 += this.intraCellSpacing;
        }
        if (bl) {
            logger.info("At least one cell has no bounds");
        }
    }

    protected void calculateWidestRank(mxGraph mxGraph2, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        double d = -this.interRankCellSpacing;
        double d2 = 0.0;
        this.rankWidths = new double[mxGraphHierarchyModel2.maxRank + 1];
        this.rankY = new double[mxGraphHierarchyModel2.maxRank + 1];
        for (int i = mxGraphHierarchyModel2.maxRank; i >= 0; --i) {
            double d3 = 0.0;
            mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(i));
            double d4 = this.initialX;
            boolean bl = false;
            for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : mxGraphHierarchyRank2) {
                mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3;
                if (mxGraphAbstractHierarchyCell2.isVertex()) {
                    mxGraphAbstractHierarchyCell3 = (mxGraphHierarchyNode)mxGraphAbstractHierarchyCell2;
                    Object object = this.layout.getVertexBounds(mxGraphAbstractHierarchyCell3.cell);
                    if (object != null) {
                        if (this.orientation == 1 || this.orientation == 5) {
                            mxGraphAbstractHierarchyCell2.width = ((mxRectangle)object).getWidth();
                            mxGraphAbstractHierarchyCell2.height = ((mxRectangle)object).getHeight();
                        } else {
                            mxGraphAbstractHierarchyCell2.width = ((mxRectangle)object).getHeight();
                            mxGraphAbstractHierarchyCell2.height = ((mxRectangle)object).getWidth();
                        }
                    } else {
                        bl = true;
                    }
                    d3 = Math.max(d3, mxGraphAbstractHierarchyCell2.height);
                } else if (mxGraphAbstractHierarchyCell2.isEdge()) {
                    mxGraphAbstractHierarchyCell3 = (mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell2;
                    int n = 1;
                    if (((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).edges != null) {
                        n = ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).edges.size();
                    } else {
                        logger.info("edge.edges is null");
                    }
                    mxGraphAbstractHierarchyCell2.width = (double)(n - 1) * this.parallelEdgeSpacing;
                }
                mxGraphAbstractHierarchyCell2.setX(i, d4 += mxGraphAbstractHierarchyCell2.width / 2.0);
                mxGraphAbstractHierarchyCell2.setGeneralPurposeVariable(i, (int)d4);
                d4 += mxGraphAbstractHierarchyCell2.width / 2.0;
                d4 += this.intraCellSpacing;
                if (d4 > this.widestRankValue) {
                    this.widestRankValue = d4;
                    this.widestRank = i;
                }
                this.rankWidths[i] = d4;
            }
            if (bl) {
                logger.info("At least one cell has no bounds");
            }
            this.rankY[i] = d;
            double d5 = d3 / 2.0 + d2 / 2.0 + this.interRankCellSpacing;
            d2 = d3;
            d = this.orientation == 1 || this.orientation == 7 ? (d += d5) : (d -= d5);
            for (Object object : mxGraphHierarchyRank2) {
                ((mxGraphAbstractHierarchyCell)object).setY(i, d);
            }
        }
    }

    private void setCellLocations(mxGraph mxGraph2, mxGraphHierarchyModel mxGraphHierarchyModel2) {
        for (int i = 0; i < mxGraphHierarchyModel2.ranks.size(); ++i) {
            mxGraphHierarchyRank mxGraphHierarchyRank2 = mxGraphHierarchyModel2.ranks.get(new Integer(i));
            for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : mxGraphHierarchyRank2) {
                mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3;
                if (mxGraphAbstractHierarchyCell2.isVertex()) {
                    mxGraphAbstractHierarchyCell3 = (mxGraphHierarchyNode)mxGraphAbstractHierarchyCell2;
                    Object object = ((mxGraphHierarchyNode)mxGraphAbstractHierarchyCell3).cell;
                    double d = ((mxGraphHierarchyNode)mxGraphAbstractHierarchyCell3).x[0] - ((mxGraphHierarchyNode)mxGraphAbstractHierarchyCell3).width / 2.0;
                    double d2 = ((mxGraphHierarchyNode)mxGraphAbstractHierarchyCell3).y[0] - ((mxGraphHierarchyNode)mxGraphAbstractHierarchyCell3).height / 2.0;
                    if (this.orientation == 1 || this.orientation == 5) {
                        this.layout.setVertexLocation(object, d, d2);
                    } else {
                        this.layout.setVertexLocation(object, d2, d);
                    }
                    this.limitX = Math.max(this.limitX, d + ((mxGraphHierarchyNode)mxGraphAbstractHierarchyCell3).width);
                    continue;
                }
                if (!mxGraphAbstractHierarchyCell2.isEdge()) continue;
                mxGraphAbstractHierarchyCell3 = (mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell2;
                double d = 0.0;
                if (((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).temp[0] == 101207) continue;
                for (Object object : ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).edges) {
                    double d3;
                    int n;
                    ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>(((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).x.length);
                    if (((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).isReversed()) {
                        for (n = 0; n < ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).x.length; ++n) {
                            d3 = ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).x[n] + d;
                            if (this.orientation == 1 || this.orientation == 5) {
                                arrayList.add(new mxPoint(d3, ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).y[n]));
                            } else {
                                arrayList.add(new mxPoint(((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).y[n], d3));
                            }
                            this.limitX = Math.max(this.limitX, d3);
                        }
                        this.processReversedEdge((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3, object);
                    } else {
                        for (n = ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).x.length - 1; n >= 0; --n) {
                            d3 = ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).x[n] + d;
                            if (this.orientation == 1 || this.orientation == 5) {
                                arrayList.add(new mxPoint(d3, ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).y[n]));
                            } else {
                                arrayList.add(new mxPoint(((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).y[n], d3));
                            }
                            this.limitX = Math.max(this.limitX, d3);
                        }
                    }
                    this.layout.setEdgePoints(object, arrayList);
                    if (d == 0.0) {
                        d = this.parallelEdgeSpacing;
                        continue;
                    }
                    if (d > 0.0) {
                        d = -d;
                        continue;
                    }
                    d = -d + this.parallelEdgeSpacing;
                }
                ((mxGraphHierarchyEdge)mxGraphAbstractHierarchyCell3).temp[0] = 101207;
            }
        }
    }

    private void processReversedEdge(mxGraphHierarchyEdge mxGraphHierarchyEdge2, Object object) {
    }

    public double getInterRankCellSpacing() {
        return this.interRankCellSpacing;
    }

    public void setInterRankCellSpacing(double d) {
        this.interRankCellSpacing = d;
    }

    public double getIntraCellSpacing() {
        return this.intraCellSpacing;
    }

    public void setIntraCellSpacing(double d) {
        this.intraCellSpacing = d;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public double getLimitX() {
        return this.limitX;
    }

    public void setLimitX(double d) {
        this.limitX = d;
    }

    public boolean isFineTuning() {
        return this.fineTuning;
    }

    public void setFineTuning(boolean bl) {
        this.fineTuning = bl;
    }

    public void setLoggerLevel(Level level) {
        try {
            logger.setLevel(level);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected class AreaSpatialCache
    extends Rectangle2D.Double {
        public Set<Object> cells = new HashSet<Object>();

        protected AreaSpatialCache() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WeightedCellSorter
    implements Comparable<Object> {
        public int weightedValue = 0;
        public boolean nudge = false;
        public boolean visited = false;
        public int rankIndex;
        public mxGraphAbstractHierarchyCell cell = null;

        public WeightedCellSorter() {
            this(null, 0);
        }

        public WeightedCellSorter(mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2, int n) {
            this.cell = mxGraphAbstractHierarchyCell2;
            this.weightedValue = n;
        }

        @Override
        public int compareTo(Object object) {
            if (object instanceof WeightedCellSorter) {
                if (this.weightedValue > ((WeightedCellSorter)object).weightedValue) {
                    return -1;
                }
                if (this.weightedValue < ((WeightedCellSorter)object).weightedValue) {
                    return 1;
                }
                if (this.nudge) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

