/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.decorators;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.EdgeIndexFunction;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.decorators.AbstractEdgeShapeTransformer;
import edu.uci.ics.jung.visualization.util.ArrowFactory;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeShape<V, E> {
    protected static Loop loop = new Loop();
    protected static SimpleLoop simpleLoop = new SimpleLoop();
    protected static Box box = new Box();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IndexedRendering<V, E> {
        public void setEdgeIndexFunction(EdgeIndexFunction<V, E> var1);

        public EdgeIndexFunction<V, E> getEdgeIndexFunction();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Orthogonal<V, E>
    extends AbstractEdgeShapeTransformer<V, E>
    implements IndexedRendering<V, E> {
        private static Line2D instance = new Line2D.Float(0.0f, 0.0f, 1.0f, 0.0f);
        protected EdgeIndexFunction<V, E> edgeIndexFunction;

        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<V, E> edgeIndexFunction) {
            this.edgeIndexFunction = edgeIndexFunction;
            box.setEdgeIndexFunction(edgeIndexFunction);
        }

        @Override
        public EdgeIndexFunction<V, E> getEdgeIndexFunction() {
            return this.edgeIndexFunction;
        }

        @Override
        public Shape transform(Context<Graph<V, E>, E> context) {
            boolean isLoop;
            Graph graph = (Graph)context.graph;
            Object e = context.element;
            Pair endpoints = graph.getEndpoints(e);
            if (endpoints != null && (isLoop = endpoints.getFirst().equals(endpoints.getSecond()))) {
                return box.transform(context);
            }
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Box<V, E>
    extends AbstractEdgeShapeTransformer<V, E>
    implements IndexedRendering<V, E> {
        private static Rectangle2D instance = new Rectangle2D.Float();
        protected EdgeIndexFunction<V, E> parallelEdgeIndexFunction;

        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<V, E> parallelEdgeIndexFunction) {
            this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
        }

        @Override
        public EdgeIndexFunction<V, E> getEdgeIndexFunction() {
            return this.parallelEdgeIndexFunction;
        }

        @Override
        public Shape transform(Context<Graph<V, E>, E> context) {
            Graph graph = (Graph)context.graph;
            Object e = context.element;
            int count = 1;
            if (this.parallelEdgeIndexFunction != null) {
                count = this.parallelEdgeIndexFunction.getIndex(graph, e);
            }
            float x = -0.5f;
            float y = -0.5f;
            float diam = 1.0f;
            diam += diam * (float)count / 2.0f;
            x += x * (float)count / 2.0f;
            y += y * (float)count / 2.0f;
            instance.setFrame(x, y, diam, diam);
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Wedge<V, E>
    extends AbstractEdgeShapeTransformer<V, E> {
        private static GeneralPath triangle;
        private static GeneralPath bowtie;

        public Wedge(int width) {
            triangle = ArrowFactory.getWedgeArrow(width, 1.0f);
            triangle.transform(AffineTransform.getTranslateInstance(1.0, 0.0));
            bowtie = new GeneralPath(0);
            bowtie.moveTo(0.0f, width / 2);
            bowtie.lineTo(1.0f, -width / 2);
            bowtie.lineTo(1.0f, width / 2);
            bowtie.lineTo(0.0f, -width / 2);
            bowtie.closePath();
        }

        @Override
        public Shape transform(Context<Graph<V, E>, E> context) {
            boolean isLoop;
            Graph graph = (Graph)context.graph;
            Object e = context.element;
            Pair endpoints = graph.getEndpoints(e);
            if (endpoints != null && (isLoop = endpoints.getFirst().equals(endpoints.getSecond()))) {
                return Loop.instance;
            }
            if (graph.getEdgeType(e) == EdgeType.DIRECTED) {
                return triangle;
            }
            return bowtie;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Loop<V, E>
    extends AbstractEdgeShapeTransformer<V, E>
    implements IndexedRendering<V, E> {
        private static Ellipse2D instance = new Ellipse2D.Float();
        protected EdgeIndexFunction<V, E> parallelEdgeIndexFunction;

        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<V, E> parallelEdgeIndexFunction) {
            this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
        }

        @Override
        public EdgeIndexFunction<V, E> getEdgeIndexFunction() {
            return this.parallelEdgeIndexFunction;
        }

        @Override
        public Shape transform(Context<Graph<V, E>, E> context) {
            Graph graph = (Graph)context.graph;
            Object e = context.element;
            int count = 1;
            if (this.parallelEdgeIndexFunction != null) {
                count = this.parallelEdgeIndexFunction.getIndex(graph, e);
            }
            float x = -0.5f;
            float y = -0.5f;
            float diam = 1.0f;
            diam += diam * (float)count / 2.0f;
            x += x * (float)count / 2.0f;
            y += y * (float)count / 2.0f;
            instance.setFrame(x, y, diam, diam);
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleLoop<V, E>
    extends AbstractEdgeShapeTransformer<V, E> {
        private static Ellipse2D instance = new Ellipse2D.Float(-0.5f, -0.5f, 1.0f, 1.0f);

        @Override
        public Shape transform(Context<Graph<V, E>, E> context) {
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CubicCurve<V, E>
    extends AbstractEdgeShapeTransformer<V, E>
    implements IndexedRendering<V, E> {
        private static CubicCurve2D instance = new CubicCurve2D.Float();
        protected EdgeIndexFunction<V, E> parallelEdgeIndexFunction;

        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<V, E> parallelEdgeIndexFunction) {
            this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
            loop.setEdgeIndexFunction(parallelEdgeIndexFunction);
        }

        @Override
        public EdgeIndexFunction<V, E> getEdgeIndexFunction() {
            return this.parallelEdgeIndexFunction;
        }

        @Override
        public Shape transform(Context<Graph<V, E>, E> context) {
            boolean isLoop;
            Graph graph = (Graph)context.graph;
            Object e = context.element;
            Pair endpoints = graph.getEndpoints(e);
            if (endpoints != null && (isLoop = endpoints.getFirst().equals(endpoints.getSecond()))) {
                return loop.transform(context);
            }
            int index = 1;
            if (this.parallelEdgeIndexFunction != null) {
                index = this.parallelEdgeIndexFunction.getIndex(graph, e);
            }
            float controlY = this.control_offset_increment + this.control_offset_increment * (float)index;
            instance.setCurve(0.0, 0.0, 0.33f, 2.0f * controlY, 0.66f, -controlY, 1.0, 0.0);
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QuadCurve<V, E>
    extends AbstractEdgeShapeTransformer<V, E>
    implements IndexedRendering<V, E> {
        private static QuadCurve2D instance = new QuadCurve2D.Float();
        protected EdgeIndexFunction<V, E> parallelEdgeIndexFunction;

        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<V, E> parallelEdgeIndexFunction) {
            this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
            loop.setEdgeIndexFunction(parallelEdgeIndexFunction);
        }

        @Override
        public EdgeIndexFunction<V, E> getEdgeIndexFunction() {
            return this.parallelEdgeIndexFunction;
        }

        @Override
        public Shape transform(Context<Graph<V, E>, E> context) {
            boolean isLoop;
            Graph graph = (Graph)context.graph;
            Object e = context.element;
            Pair endpoints = graph.getEndpoints(e);
            if (endpoints != null && (isLoop = endpoints.getFirst().equals(endpoints.getSecond()))) {
                return loop.transform(context);
            }
            int index = 1;
            if (this.parallelEdgeIndexFunction != null) {
                index = this.parallelEdgeIndexFunction.getIndex(graph, e);
            }
            float controlY = this.control_offset_increment + this.control_offset_increment * (float)index;
            instance.setCurve(0.0, 0.0, 0.5, controlY, 1.0, 0.0);
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BentLine<V, E>
    extends AbstractEdgeShapeTransformer<V, E>
    implements IndexedRendering<V, E> {
        private static GeneralPath instance = new GeneralPath();
        protected EdgeIndexFunction<V, E> parallelEdgeIndexFunction;

        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<V, E> parallelEdgeIndexFunction) {
            this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
            loop.setEdgeIndexFunction(parallelEdgeIndexFunction);
        }

        @Override
        public EdgeIndexFunction<V, E> getEdgeIndexFunction() {
            return this.parallelEdgeIndexFunction;
        }

        @Override
        public Shape transform(Context<Graph<V, E>, E> context) {
            boolean isLoop;
            Graph graph = (Graph)context.graph;
            Object e = context.element;
            Pair endpoints = graph.getEndpoints(e);
            if (endpoints != null && (isLoop = endpoints.getFirst().equals(endpoints.getSecond()))) {
                return loop.transform(context);
            }
            int index = 1;
            if (this.parallelEdgeIndexFunction != null) {
                index = this.parallelEdgeIndexFunction.getIndex(graph, e);
            }
            float controlY = this.control_offset_increment + this.control_offset_increment * (float)index;
            instance.reset();
            instance.moveTo(0.0f, 0.0f);
            instance.lineTo(0.5f, controlY);
            instance.lineTo(1.0f, 1.0f);
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Line<V, E>
    extends AbstractEdgeShapeTransformer<V, E> {
        private static Line2D instance = new Line2D.Float(0.0f, 0.0f, 1.0f, 0.0f);

        @Override
        public Shape transform(Context<Graph<V, E>, E> context) {
            boolean isLoop;
            Graph graph = (Graph)context.graph;
            Object e = context.element;
            Pair endpoints = graph.getEndpoints(e);
            if (endpoints != null && (isLoop = endpoints.getFirst().equals(endpoints.getSecond()))) {
                return loop.transform(context);
            }
            return instance;
        }
    }
}

