/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import edu.uci.ics.jung.algorithms.scoring.AbstractIterativeScorer;
import edu.uci.ics.jung.algorithms.scoring.VertexScorer;
import edu.uci.ics.jung.graph.Hypergraph;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIterativeScorerWithPriors<V, E, S>
extends AbstractIterativeScorer<V, E, S>
implements VertexScorer<V, S> {
    protected Transformer<V, ? extends S> vertex_priors;
    protected double alpha;

    public AbstractIterativeScorerWithPriors(Hypergraph<V, E> g, Transformer<E, ? extends Number> edge_weights, Transformer<V, ? extends S> vertex_priors, double alpha) {
        super(g, edge_weights);
        this.vertex_priors = vertex_priors;
        this.alpha = alpha;
        this.initialize();
    }

    public AbstractIterativeScorerWithPriors(Hypergraph<V, E> g, Transformer<V, ? extends S> vertex_priors, double alpha) {
        super(g);
        this.vertex_priors = vertex_priors;
        this.alpha = alpha;
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        for (Object v : this.graph.getVertices()) {
            this.setOutputValue(v, this.getVertexPrior(v));
        }
    }

    protected S getVertexPrior(V v) {
        return this.vertex_priors.transform(v);
    }

    public Transformer<V, ? extends S> getVertexPriors() {
        return this.vertex_priors;
    }

    public double getAlpha() {
        return this.alpha;
    }
}

