/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.ContentByteUtils;
import com.itextpdf.text.pdf.parser.LocationAwareTextExtractingPdfContentRenderListener;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.parser.TextProvidingRenderListener;
import java.io.IOException;

public class PdfTextExtractor {
    private final PdfReader reader;
    private final TextProvidingRenderListener renderListener;

    public PdfTextExtractor(PdfReader reader) {
        this(reader, new LocationAwareTextExtractingPdfContentRenderListener());
    }

    public PdfTextExtractor(PdfReader reader, TextProvidingRenderListener renderListener) {
        this.reader = reader;
        this.renderListener = renderListener;
    }

    public String getTextFromPage(int page) throws IOException {
        PdfDictionary pageDic = this.reader.getPageN(page);
        PdfDictionary resourcesDic = pageDic.getAsDict(PdfName.RESOURCES);
        this.renderListener.reset();
        PdfContentStreamProcessor processor = new PdfContentStreamProcessor(this.renderListener);
        processor.processContent(ContentByteUtils.getContentBytesForPage(this.reader, page), resourcesDic);
        return this.renderListener.getResultantText();
    }
}

