/*
 * Decompiled with CFR 0.152.
 */
package org.renci.sequencing.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.renci.sequencing.util.IRegression;

public class LogisticRegression
implements IRegression {
    private List<String> tRowVectorList;
    private List<Float> tCoeffList;
    private List<Integer> tFlaggedList;
    private List<String> tReadFlagVectorList;
    private boolean bScalePhredBy33 = false;
    private int PHRED_SCALE_VALUE = 33;
    private BufferedWriter tDebugWriter;

    private LogisticRegression(List<Float> tCoeffListIn, List<Integer> tFlaggedListIn, boolean bIsPhredScaleBy33) {
        this.tCoeffList = tCoeffListIn;
        this.tFlaggedList = tFlaggedListIn;
        this.tReadFlagVectorList = new ArrayList<String>();
        this.tRowVectorList = new ArrayList<String>();
        this.bScalePhredBy33 = bIsPhredScaleBy33;
    }

    private LogisticRegression(List<Float> tCoeffListIn, List<Integer> tFlaggedListIn, boolean bIsPhredScaleBy33, BufferedWriter tDebugWriterIn) {
        this.tCoeffList = tCoeffListIn;
        this.tFlaggedList = tFlaggedListIn;
        this.tReadFlagVectorList = new ArrayList<String>();
        this.tRowVectorList = new ArrayList<String>();
        this.bScalePhredBy33 = bIsPhredScaleBy33;
        this.tDebugWriter = tDebugWriterIn;
    }

    public static LogisticRegression getInstance(List<Float> tCoeffList, List<Integer> tFlaggedList, boolean bIsPhredScaleBy33) {
        return new LogisticRegression(tCoeffList, tFlaggedList, bIsPhredScaleBy33);
    }

    public static LogisticRegression getInstance(List<Float> tCoeffList, List<Integer> tFlaggedList, boolean bIsPhredScaleBy33, BufferedWriter tDebugWriterIn) {
        return new LogisticRegression(tCoeffList, tFlaggedList, bIsPhredScaleBy33, tDebugWriterIn);
    }

    @Override
    public double runRegression() throws Exception {
        double dZ = this.calculateZ(2, this.tCoeffList);
        double dResult = this.calculateFZ(dZ);
        return dResult;
    }

    public void calcRowVector(int iPhredIn, double iAvgQCIn, char sBaseIn, int iReadPosIn, int iReadFlagIn, boolean bNegativeStrandIn, int iReadLengthIn) {
        this.tRowVectorList.clear();
        this.tRowVectorList.add("1");
        int iLocalPhred = 0;
        iLocalPhred = this.bScalePhredBy33 ? iPhredIn - this.PHRED_SCALE_VALUE : iPhredIn;
        this.tRowVectorList.add(Integer.toString(iLocalPhred));
        int iPhredIsZero = iPhredIn == 0 ? 1 : 0;
        this.tRowVectorList.add(Integer.toString(iPhredIsZero));
        this.tRowVectorList.add(Double.toString(iAvgQCIn));
        this.tRowVectorList.add(Integer.toString(this.getBaseValue(String.valueOf(sBaseIn), "A")));
        this.tRowVectorList.add(Integer.toString(this.getBaseValue(String.valueOf(sBaseIn), "C")));
        this.tRowVectorList.add(Integer.toString(this.getBaseValue(String.valueOf(sBaseIn), "G")));
        if (bNegativeStrandIn) {
            int iReadPos = this.calcReadPos(iReadLengthIn, iReadPosIn);
            if (this.tDebugWriter != null) {
                try {
                    this.tDebugWriter.write(String.valueOf(iPhredIn) + "\t" + iAvgQCIn + "\t" + sBaseIn + "\t" + iReadPos + System.getProperty("line.separator"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.tRowVectorList.add(Integer.toString(iReadPos));
            this.tRowVectorList.addAll(this.getReadFlagVectorList(iReadPos));
        } else {
            if (this.tDebugWriter != null) {
                try {
                    this.tDebugWriter.write(String.valueOf(iPhredIn) + "\t" + iAvgQCIn + "\t" + sBaseIn + "\t" + iReadPosIn + System.getProperty("line.separator"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.tRowVectorList.add(Integer.toString(iReadPosIn));
            this.tRowVectorList.addAll(this.getReadFlagVectorList(iReadPosIn));
        }
    }

    private List<String> getReadFlagVectorList(int iReadPosIn) {
        this.tReadFlagVectorList.clear();
        int iIndexOfFlaggedReadPos = this.tFlaggedList.indexOf(iReadPosIn);
        if (iIndexOfFlaggedReadPos != -1) {
            int ii = 0;
            while (ii < this.tFlaggedList.size()) {
                if (ii == iIndexOfFlaggedReadPos) {
                    this.tReadFlagVectorList.add(String.valueOf(1));
                } else {
                    this.tReadFlagVectorList.add(String.valueOf(0));
                }
                ++ii;
            }
        } else {
            int ii = 0;
            while (ii < this.tFlaggedList.size()) {
                this.tReadFlagVectorList.add(String.valueOf(0));
                ++ii;
            }
        }
        return this.tReadFlagVectorList;
    }

    private int calcReadPos(int iReadLengthIn, int iReadPosIn) {
        int iReadPosCalc = 0;
        iReadPosCalc = ++iReadLengthIn - ++iReadPosIn + 1;
        return iReadPosCalc;
    }

    private int getBaseValue(String sBaseValueIn, String sCompareStringIn) {
        int iReturnValue = 0;
        iReturnValue = sBaseValueIn.equalsIgnoreCase(sCompareStringIn) ? 1 : 0;
        return iReturnValue;
    }

    private double calculateZ(int iBetaIntercept, List<Float> tCoeffListIn) throws Exception {
        double dZValue = 0.0;
        dZValue = this.calcDotProduct(tCoeffListIn, this.tRowVectorList);
        return dZValue;
    }

    private double calculateFZ(double iZValueIn) {
        double iDoubleReturn = 0.0;
        iDoubleReturn = 1.0 / (1.0 + Math.pow(Math.E, -iZValueIn));
        return iDoubleReturn;
    }

    private double calcDotProduct(List<Float> tCoeffListIn, List<String> tGeneratedListIn) throws Exception {
        double dZValue = 0.0;
        if (tCoeffListIn.size() != tGeneratedListIn.size()) {
            this.printError("LogisticRegression::calcDotProduct: Input arrays not of same length: tCoeffListIn: " + tCoeffListIn.toString() + " tGeneratedListIn: " + tGeneratedListIn.toString());
            throw new Exception("LogisticRegression::calcDotProduct: Input arrays not of same length: tCoeffListIn: " + tCoeffListIn.toString() + " tGeneratedListIn: " + tGeneratedListIn.toString());
        }
        int ii = 0;
        while (ii < tGeneratedListIn.size()) {
            dZValue += Double.valueOf(tGeneratedListIn.get(ii)) * (double)tCoeffListIn.get(ii).floatValue();
            ++ii;
        }
        return dZValue;
    }

    public void setPhredScale(boolean bPhredScaleIn) {
        this.bScalePhredBy33 = bPhredScaleIn;
    }

    private void printError(String sErrorMessageIn) {
        System.out.println(sErrorMessageIn);
    }
}

