## ----setup, echo=FALSE---------------------------------------------------
knitr::opts_chunk$set(message=FALSE, fig.path='figures/')

## ----tidy = TRUE, eval = FALSE-------------------------------------------
#  source("http://bioconductor.org/biocLite.R")
#  biocLite("MWASTools")

## ----tidy = TRUE---------------------------------------------------------
library(MWASTools)

## ----tidy = TRUE---------------------------------------------------------
data("metabo_SE")
metabo_SE

## ----tidy = TRUE, results='asis', fig.width = 14, fig.height = 6---------
# PCA model
PCA_model = QC_PCA (metabo_SE, scale = FALSE, center = TRUE)

# Plot PCA scores (PC1 vs PC2 & PC3 vs PC4)
par(mfrow=c(1,2))
QC_PCA_scoreplot (PCA_model, metabo_SE, main = "PC1 vs PC2")
QC_PCA_scoreplot (PCA_model, metabo_SE, px=3, py=4, main="PC3 vs PC4")

## ----tidy = TRUE, eval = TRUE, fig.width = 14, fig.height = 4------------
# CV calculation 
metabo_CV = QC_CV (metabo_SE, plot_hist = FALSE)

# NMR spectrum colored according to CVs
CV_spectrum = QC_CV_specNMR(metabo_SE, ref_sample = "QC1")

## ----tidy = TRUE---------------------------------------------------------
# Filter metabolic-matrix based on a CV cut-off of 0.30
metabo_SE = CV_filter(metabo_SE, metabo_CV, CV_th = 0.30)

## ----tidy = TRUE, tidy.opts=list(indent = 4, width.cutoff = 80)----------
# Run MWAS
MWAS_BMI = MWAS_stats(metabo_SE, disease_id = "BMI", confounder_ids = c("Age","Gender", "T2D"), 
                      assoc_method = "spearman", mt_method = "BH")

## ----tidy = TRUE, fig.width = 14, fig.height = 6-------------------------
# Visualize MWAS results 
skyline = MWAS_skylineNMR(metabo_SE, MWAS_BMI, ref_sample = "QC1")

## ----tidy = TRUE, fig.width = 14, fig.height = 4-------------------------
stocsy = STOCSY_NMR(metabo_SE, ppm_query = 1.04)

