## ----knitr, echo=FALSE, cache = FALSE------------------------------------
library(knitr)
library(rmarkdown)
opts_chunk$set(cache = FALSE)

## ----netrc_req, echo = FALSE---------------------------------------------
# This chunk is only useful for BioConductor checks and shouldn't affect any other setup
ISR_login <- Sys.getenv("ISR_login")
ISR_pwd <- Sys.getenv("ISR_pwd")
if(ISR_login != ""  &  ISR_pwd != ""){
  netrc_file <- tempfile("ImmuneSpaceR_tmp_netrc")
  netrc_string <- paste("machine www.immunespace.org login", ISR_login, "password", ISR_pwd)
  write(x = netrc_string, file = netrc_file)
  labkey.netrc.file <- netrc_file
}

## ----CreateConnection, cache=FALSE, message=FALSE------------------------
library(ImmuneSpaceR)
sdy269 <- CreateConnection(study = "SDY269")
sdy269

## ----getDataset----------------------------------------------------------
sdy269$getDataset("hai")

## ----getDataset-filter, message = FALSE----------------------------------
library(Rlabkey)
myFilter <- makeFilter(c("gender", "EQUAL", "Female"))
hai <- sdy269$getDataset("hai", colFilter = myFilter)

## ----getGEMatrix---------------------------------------------------------
sdy269$getGEMatrix("LAIV_2008")

## ----getGEMatrix-multiple------------------------------------------------
sdy269$getGEMatrix(c("TIV_2008", "LAIV_2008"))

## ----getGEMatrix-summary-------------------------------------------------
gs <- sdy269$getGEMatrix("TIV_2008", summary = TRUE)

## ---- dev='png', fig.width=15--------------------------------------------
sdy269$quick_plot("hai")

sdy269$quick_plot("elisa")

## ---- cross-connection---------------------------------------------------
con <- CreateConnection("")

## ---- cross-connection-print---------------------------------------------
con

## ----cross-connection-qplot, dev='png', fig.align="center"---------------
plotFilter <- makeFilter(c("cohort", "IN", "TIV 2010;TIV Group 2008"))
con$quick_plot("elispot", filter = plotFilter)

## ----sessionInfo---------------------------------------------------------
sessionInfo()

