/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;
import org.cytoscape.equations.LongList;

public class IList
extends AbstractFunction {
    public IList() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.OPT_INTS, "integers", "Zero or more numbers, strings or booleans.")});
    }

    public String getName() {
        return "ILIST";
    }

    public String getFunctionSummary() {
        return "Returns a list of whole numbers (a.k.a. integers).";
    }

    public Class getReturnType() {
        return LongList.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        long[] numbers;
        try {
            numbers = FunctionUtil.getLongs(args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert an argument or a list element to an integer in a call to ILIST()!");
        }
        return new LongList(numbers);
    }
}

