/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBWrapper;

public class SubSequenceDB
extends SequenceDBWrapper {
    private final Set ids;

    public SubSequenceDB(SequenceDB parent, Set ids) throws BioException {
        super(parent);
        this.ids = new HashSet(ids);
        Set pids = parent.ids();
        if (!pids.containsAll(ids)) {
            throw new BioException("IDs must all be contained in the parent database " + parent.getName());
        }
    }

    public String getName() {
        return this.getParent().getName() + " subset " + this.ids.toString();
    }

    public Sequence getSequence(String id) throws BioException {
        if (!this.ids.contains(id)) {
            throw new BioException("No sequence for " + id + " found in database " + this.getName());
        }
        return this.getParent().getSequence(id);
    }

    public Set ids() {
        return Collections.unmodifiableSet(this.ids);
    }
}

