/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.FiniteAlphabet;

public class AlphabetResolver {
    static final int DNA = 0;
    static final int PROTEIN = 1;

    public static FiniteAlphabet resolveAlphabet(String identifier) throws BioException {
        int type = 0;
        if ((identifier = identifier.toUpperCase()).indexOf("TBLASTN") != -1) {
            type = 1;
        } else if (identifier.indexOf("TBLASTX") != -1) {
            type = 1;
        } else if (identifier.indexOf("BLASTN") != -1) {
            type = 0;
        } else if (identifier.indexOf("BLASTP") != -1) {
            type = 1;
        } else if (identifier.indexOf("BLASTX") != -1) {
            type = 1;
        } else if (identifier.indexOf("DNA") != -1) {
            type = 0;
        } else if (identifier.indexOf("PROTEIN") != -1) {
            type = 1;
        } else {
            throw new BioException("Failed to resolve sequence type from identifier '" + identifier + "'");
        }
        switch (type) {
            case 0: {
                return DNATools.getDNA();
            }
            case 1: {
                return ProteinTools.getTAlphabet();
            }
        }
        throw new BioError("Internal error in AlphabetResolver: failed to resolve to either DNA or protein alphabets");
    }
}

