/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.biojava.bio.gui.sequence.CircularRendererContext;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;

public final class GUITools {
    private GUITools() {
    }

    public static Location getVisibleRange(SequenceRenderContext src, Graphics2D g2) {
        int max;
        Rectangle clip = g2.getClipBounds();
        int min = Math.max(src.getRange().getMin(), src.graphicsToSequence(new Point2D.Double(clip.getMinX(), clip.getMinY())) - 1);
        if (min > (max = Math.min(src.getRange().getMax(), src.graphicsToSequence(new Point2D.Double(clip.getMaxX(), clip.getMaxY())) + 1))) {
            return Location.empty;
        }
        return new RangeLocation(min, max);
    }

    public static Rectangle2D createOuterBounds(CircularRendererContext crc, double depth) {
        double outer = crc.getRadius() + depth;
        return new Rectangle2D.Double(-outer, -outer, 2.0 * outer, 2.0 * outer);
    }

    public static Rectangle2D createInnerBounds(CircularRendererContext crc) {
        double outer = crc.getRadius();
        return new Rectangle2D.Double(-outer, -outer, 2.0 * outer, 2.0 * outer);
    }
}

