/*
 * Decompiled with CFR 0.152.
 */
package giny.view;

import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.model.RootGraph;
import giny.view.EdgeView;
import giny.view.GraphViewChangeListener;
import giny.view.NodeView;
import java.awt.Component;
import java.awt.Paint;
import java.util.Iterator;
import java.util.List;

public interface GraphView {
    public static final int NODE_X_POSITION = 0;
    public static final int NODE_Y_POSITION = 1;
    public static final int NODE_SHAPE = 2;
    public static final int NODE_PAINT = 3;
    public static final int NODE_SELECTION_PAINT = 4;
    public static final int NODE_BORDER_PAINT = 5;
    public static final int NODE_BORDER_WIDTH = 6;
    public static final int NODE_WIDTH = 7;
    public static final int NODE_HEIGHT = 8;
    public static final int NODE_LABEL = 9;
    public static final int NODE_Z_POSITION = 10;
    public static final int SOURCE_INDEX = 0;
    public static final int TARGET_INDEX = 1;
    public static final int EDGE_WIDTH = 2;
    public static final int EDGE_LINE_TYPE = 3;
    public static final int EDGE_PAINT = 4;
    public static final int EDGE_SELECTION_PAINT = 5;
    public static final int EDGE_SOURCE_END_TYPE = 6;
    public static final int EDGE_SOURCE_END_PAINT = 7;
    public static final int EDGE_SOURCE_END_SELECTED_PAINT = 8;
    public static final int EDGE_TARGET_END_TYPE = 9;
    public static final int EDGE_TARGET_END_PAINT = 10;
    public static final int EDGE_TARGET_END_SELECTED_PAINT = 11;

    public GraphPerspective getGraphPerspective();

    public boolean nodeSelectionEnabled();

    public boolean edgeSelectionEnabled();

    public void enableNodeSelection();

    public void disableNodeSelection();

    public void enableEdgeSelection();

    public void disableEdgeSelection();

    public int[] getSelectedNodeIndices();

    public List getSelectedNodes();

    public int[] getSelectedEdgeIndices();

    public List getSelectedEdges();

    public void addGraphViewChangeListener(GraphViewChangeListener var1);

    public void removeGraphViewChangeListener(GraphViewChangeListener var1);

    public void setBackgroundPaint(Paint var1);

    public Paint getBackgroundPaint();

    public Component getComponent();

    public NodeView addNodeView(int var1);

    public EdgeView addEdgeView(int var1);

    public EdgeView addEdgeView(String var1, int var2);

    public NodeView addNodeView(String var1, int var2);

    public NodeView addNodeView(int var1, NodeView var2);

    public NodeView removeNodeView(NodeView var1);

    public NodeView removeNodeView(Node var1);

    public NodeView removeNodeView(int var1);

    public EdgeView removeEdgeView(EdgeView var1);

    public EdgeView removeEdgeView(Edge var1);

    public EdgeView removeEdgeView(int var1);

    public String getIdentifier();

    public void setIdentifier(String var1);

    public double getZoom();

    public void setZoom(double var1);

    public void fitContent();

    public void updateView();

    public RootGraph getRootGraph();

    public Iterator getNodeViewsIterator();

    public int getNodeViewCount();

    public int getEdgeViewCount();

    public NodeView getNodeView(Node var1);

    public NodeView getNodeView(int var1);

    public List getEdgeViewsList();

    public List getEdgeViewsList(Node var1, Node var2);

    public List getEdgeViewsList(int var1, int var2, boolean var3);

    public EdgeView getEdgeView(int var1);

    public Iterator getEdgeViewsIterator();

    public EdgeView getEdgeView(Edge var1);

    public int edgeCount();

    public int nodeCount();

    public boolean hideGraphObject(Object var1);

    public boolean showGraphObject(Object var1);

    public boolean hideGraphObjects(List var1);

    public boolean showGraphObjects(List var1);

    public Object[] getContextMethods(String var1, boolean var2);

    public Object[] getContextMethods(String var1, Object[] var2);

    public boolean addContextMethod(String var1, String var2, String var3, Object[] var4, ClassLoader var5);

    public void setAllNodePropertyData(int var1, Object[] var2);

    public Object[] getAllNodePropertyData(int var1);

    public void setAllEdgePropertyData(int var1, Object[] var2);

    public Object[] getAllEdgePropertyData(int var1);

    public Object getNodeObjectProperty(int var1, int var2);

    public boolean setNodeObjectProperty(int var1, int var2, Object var3);

    public Object getEdgeObjectProperty(int var1, int var2);

    public boolean setEdgeObjectProperty(int var1, int var2, Object var3);

    public double getNodeDoubleProperty(int var1, int var2);

    public boolean setNodeDoubleProperty(int var1, int var2, double var3);

    public double getEdgeDoubleProperty(int var1, int var2);

    public boolean setEdgeDoubleProperty(int var1, int var2, double var3);

    public float getNodeFloatProperty(int var1, int var2);

    public boolean setNodeFloatProperty(int var1, int var2, float var3);

    public float getEdgeFloatProperty(int var1, int var2);

    public boolean setEdgeFloatProperty(int var1, int var2, float var3);

    public boolean getNodeBooleanProperty(int var1, int var2);

    public boolean setNodeBooleanProperty(int var1, int var2, boolean var3);

    public boolean getEdgeBooleanProperty(int var1, int var2);

    public boolean setEdgeBooleanProperty(int var1, int var2, boolean var3);

    public int getNodeIntProperty(int var1, int var2);

    public boolean setNodeIntProperty(int var1, int var2, int var3);

    public int getEdgeIntProperty(int var1, int var2);

    public boolean setEdgeIntProperty(int var1, int var2, int var3);
}

