/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import cytoscape.geom.spacial.SpacialEntry2DEnumerator;
import cytoscape.graph.fixed.FixedGraph;
import cytoscape.render.export.ImageImposter;
import cytoscape.render.immed.EdgeAnchors;
import cytoscape.render.immed.GraphGraphics;
import cytoscape.render.stateful.GraphLOD;
import cytoscape.render.stateful.GraphRenderer;
import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.IntHash;
import cytoscape.util.intr.IntStack;
import ding.view.DEdgeView;
import ding.view.DGraphView;
import ding.view.DNodeView;
import ding.view.DingCanvas;
import ding.view.EdgeContextMenuListener;
import ding.view.GraphViewEdgesSelectedEvent;
import ding.view.GraphViewEdgesUnselectedEvent;
import ding.view.GraphViewNodesSelectedEvent;
import ding.view.GraphViewNodesUnselectedEvent;
import ding.view.NodeContextMenuListener;
import ding.view.ViewChangeEdit;
import giny.view.EdgeView;
import giny.view.GraphViewChangeListener;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import phoebe.PhoebeCanvasDropEvent;
import phoebe.PhoebeCanvasDropListener;
import phoebe.PhoebeCanvasDroppable;

public class InnerCanvas
extends DingCanvas
implements MouseListener,
MouseMotionListener,
DropTargetListener,
PhoebeCanvasDroppable,
KeyListener,
MouseWheelListener {
    private static final long serialVersionUID = 6219424955453507079L;
    final double[] m_ptBuff = new double[2];
    final float[] m_extentsBuff2 = new float[4];
    final float[] m_floatBuff1 = new float[2];
    final float[] m_floatBuff2 = new float[2];
    final Line2D.Float m_line = new Line2D.Float();
    final GeneralPath m_path = new GeneralPath();
    final GeneralPath m_path2 = new GeneralPath();
    final IntStack m_stack = new IntStack();
    final IntStack m_stack2 = new IntStack();
    final Object m_lock;
    DGraphView m_view;
    final GraphLOD[] m_lod = new GraphLOD[1];
    final IntHash m_hash;
    GraphGraphics m_grafx;
    double m_xCenter;
    double m_yCenter;
    double m_scaleFactor;
    private int m_lastRenderDetail = 0;
    private Rectangle m_selectionRect = null;
    private ViewChangeEdit m_undoable_edit;
    FontMetrics m_fontMetrics = null;
    private boolean NodeMovement = true;
    private static final String MAC_OS_ID = "mac";
    private final DropTarget dropTarget;
    private boolean selecting = true;
    public Vector listeners = new Vector();
    private Vector transferComponents = new Vector();
    public Vector nodeContextMenuListeners = new Vector();
    public Vector edgeContextMenuListeners = new Vector();
    private int m_currMouseButton = 0;
    private int m_lastXMousePos = 0;
    private int m_lastYMousePos = 0;
    private boolean m_button1NodeDrag = false;

    InnerCanvas(Object lock, DGraphView view) {
        this.m_lock = lock;
        this.m_view = view;
        this.m_lod[0] = new GraphLOD();
        this.m_hash = new IntHash();
        this.m_backgroundColor = Color.white;
        this.m_isVisible = true;
        this.m_isOpaque = false;
        this.m_xCenter = 0.0;
        this.m_yCenter = 0.0;
        this.m_scaleFactor = 1.0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.dropTarget = new DropTarget(this, 1, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width > 0 && height > 0) {
            BufferedImage img = new BufferedImage(width, height, 2);
            GraphGraphics grafx = new GraphGraphics(img, false);
            Object object = this.m_lock;
            synchronized (object) {
                this.m_img = img;
                this.m_grafx = grafx;
                this.m_view.m_viewportChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics g) {
        Object lis;
        if (this.m_grafx == null) {
            return;
        }
        boolean contentChanged = false;
        boolean viewportChanged = false;
        double xCenter = 0.0;
        double yCenter = 0.0;
        double scaleFactor = 1.0;
        this.m_fontMetrics = g.getFontMetrics();
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_view.m_contentChanged || this.m_view.m_viewportChanged) {
                this.renderGraph(this.m_grafx, true, this.m_lod[0]);
                contentChanged = this.m_view.m_contentChanged;
                this.m_view.m_contentChanged = false;
                viewportChanged = this.m_view.m_viewportChanged;
                xCenter = this.m_xCenter;
                yCenter = this.m_yCenter;
                scaleFactor = this.m_scaleFactor;
                this.m_view.m_viewportChanged = false;
            }
        }
        if (this.m_isVisible) {
            g.drawImage(this.m_img, 0, 0, null);
        }
        if (this.m_selectionRect != null && this.isSelecting()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.red);
            g2.draw(this.m_selectionRect);
        }
        if (contentChanged && (lis = this.m_view.m_cLis[0]) != null) {
            lis.contentChanged();
        }
        if (viewportChanged && (lis = this.m_view.m_vLis[0]) != null) {
            lis.viewportChanged(this.getWidth(), this.getHeight(), xCenter, yCenter, scaleFactor);
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void print(Graphics g) {
        this.renderGraph(new GraphGraphics(new ImageImposter(g, this.getWidth(), this.getHeight()), false), false, this.m_view.m_printLOD);
    }

    public void printNoImposter(Graphics g) {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.renderGraph(new GraphGraphics(img, false), false, this.m_view.m_printLOD);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent e) {
        if (!(e.getButton() != 1 || this.isMacPlatform() && e.isControlDown())) {
            if (e.isShiftDown() && this.isAnchorKeyDown(e)) {
                return;
            }
            this.m_undoable_edit = null;
            this.m_currMouseButton = 1;
            this.m_lastXMousePos = e.getX();
            this.m_lastYMousePos = e.getY();
            int[] unselectedNodes = null;
            int[] unselectedEdges = null;
            int chosenNode = 0;
            int chosenEdge = 0;
            int chosenAnchor = -1;
            int chosenNodeSelected = 0;
            int chosenEdgeSelected = 0;
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_view.m_nodeSelection) {
                    this.m_ptBuff[0] = this.m_lastXMousePos;
                    this.m_ptBuff[1] = this.m_lastYMousePos;
                    this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                    this.m_stack.empty();
                    this.m_view.getNodesIntersectingRectangle((float)this.m_ptBuff[0], (float)this.m_ptBuff[1], (float)this.m_ptBuff[0], (float)this.m_ptBuff[1], (this.m_lastRenderDetail & 1) == 0, this.m_stack);
                    int n = chosenNode = this.m_stack.size() > 0 ? this.m_stack.peek() : 0;
                }
                if (this.m_view.m_edgeSelection && chosenNode == 0 && (this.m_lastRenderDetail & 0x20) != 0) {
                    this.m_ptBuff[0] = this.m_lastXMousePos;
                    this.m_ptBuff[1] = this.m_lastYMousePos;
                    this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                    SpacialEntry2DEnumerator hits = this.m_view.m_spacialA.queryOverlap((float)this.m_ptBuff[0], (float)this.m_ptBuff[1], (float)this.m_ptBuff[0], (float)this.m_ptBuff[1], null, 0, false);
                    int n = chosenAnchor = hits.numRemaining() > 0 ? hits.nextInt() : -1;
                }
                if (this.m_view.m_edgeSelection && chosenNode == 0 && chosenAnchor < 0) {
                    this.computeEdgesIntersecting(this.m_lastXMousePos - 1, this.m_lastYMousePos - 1, this.m_lastXMousePos + 1, this.m_lastYMousePos + 1, this.m_stack2);
                    int n = chosenEdge = this.m_stack2.size() > 0 ? this.m_stack2.peek() : 0;
                }
                if (!(e.isShiftDown() || (chosenNode != 0 || chosenEdge != 0 || chosenAnchor >= 0) && (chosenNode != 0 && this.m_view.getNodeView(chosenNode).isSelected() || chosenAnchor >= 0 || chosenEdge != 0 && this.m_view.getEdgeView(chosenEdge).isSelected()))) {
                    if (this.m_view.m_nodeSelection) {
                        unselectedNodes = this.m_view.getSelectedNodeIndices();
                        this.m_view.m_selectedNodes.empty();
                        for (int i = 0; i < unselectedNodes.length; ++i) {
                            ((DNodeView)this.m_view.getNodeView(unselectedNodes[i])).unselectInternal();
                        }
                    } else {
                        unselectedNodes = new int[]{};
                    }
                    if (this.m_view.m_edgeSelection) {
                        unselectedEdges = this.m_view.getSelectedEdgeIndices();
                        this.m_view.m_selectedEdges.empty();
                        for (int i = 0; i < unselectedEdges.length; ++i) {
                            ((DEdgeView)this.m_view.getEdgeView(unselectedEdges[i])).unselectInternal();
                        }
                    } else {
                        unselectedEdges = new int[]{};
                    }
                    if (unselectedNodes.length > 0 || unselectedEdges.length > 0) {
                        this.m_view.m_contentChanged = true;
                    }
                }
                if (chosenNode != 0) {
                    boolean wasSelected = this.m_view.getNodeView(chosenNode).isSelected();
                    if (wasSelected && e.isShiftDown()) {
                        ((DNodeView)this.m_view.getNodeView(chosenNode)).unselectInternal();
                        chosenNodeSelected = -1;
                    } else if (!wasSelected) {
                        ((DNodeView)this.m_view.getNodeView(chosenNode)).selectInternal();
                        chosenNodeSelected = 1;
                    }
                    this.m_button1NodeDrag = true;
                    this.m_view.m_contentChanged = true;
                }
                if (chosenAnchor >= 0) {
                    if (this.isAnchorKeyDown(e)) {
                        int edge = chosenAnchor >>> 6;
                        int anchorInx = chosenAnchor & 0x3F;
                        this.m_undoable_edit = new ViewChangeEdit(this.m_view, ViewChangeEdit.SavedObjs.SELECTED_EDGES, "Remove Edge Handle");
                        ((DEdgeView)this.m_view.getEdgeView(~edge)).removeHandle(anchorInx);
                        this.m_button1NodeDrag = false;
                    } else {
                        boolean wasSelected;
                        boolean bl = wasSelected = this.m_view.m_selectedAnchors.count(chosenAnchor) > 0;
                        if (wasSelected && e.isShiftDown()) {
                            this.m_view.m_selectedAnchors.delete(chosenAnchor);
                        } else if (!wasSelected) {
                            if (!e.isShiftDown()) {
                                this.m_view.m_selectedAnchors.empty();
                            }
                            this.m_view.m_selectedAnchors.insert(chosenAnchor);
                        }
                        this.m_button1NodeDrag = true;
                    }
                    this.m_view.m_contentChanged = true;
                }
                if (chosenEdge != 0) {
                    boolean wasSelected;
                    if (this.isAnchorKeyDown(e) && (this.m_lastRenderDetail & 0x20) != 0) {
                        this.m_view.m_selectedAnchors.empty();
                        this.m_ptBuff[0] = this.m_lastXMousePos;
                        this.m_ptBuff[1] = this.m_lastYMousePos;
                        this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                        this.m_undoable_edit = new ViewChangeEdit(this.m_view, ViewChangeEdit.SavedObjs.SELECTED_EDGES, "Add Edge Handle");
                        int chosenInx = ((DEdgeView)this.m_view.getEdgeView(chosenEdge)).addHandleFoo(new Point2D.Float((float)this.m_ptBuff[0], (float)this.m_ptBuff[1]));
                        this.m_view.m_selectedAnchors.insert(~chosenEdge << 6 | chosenInx);
                    }
                    if ((wasSelected = this.m_view.getEdgeView(chosenEdge).isSelected()) && e.isShiftDown()) {
                        ((DEdgeView)this.m_view.getEdgeView(chosenEdge)).unselectInternal();
                        chosenEdgeSelected = -1;
                    } else if (!wasSelected) {
                        ((DEdgeView)this.m_view.getEdgeView(chosenEdge)).selectInternal(false);
                        chosenEdgeSelected = 1;
                        if ((this.m_lastRenderDetail & 0x20) != 0) {
                            int hit;
                            this.m_ptBuff[0] = this.m_lastXMousePos;
                            this.m_ptBuff[1] = this.m_lastYMousePos;
                            this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                            SpacialEntry2DEnumerator hits = this.m_view.m_spacialA.queryOverlap((float)this.m_ptBuff[0], (float)this.m_ptBuff[1], (float)this.m_ptBuff[0], (float)this.m_ptBuff[1], null, 0, false);
                            if (hits.numRemaining() > 0 && this.m_view.m_selectedAnchors.count(hit = hits.nextInt()) == 0) {
                                this.m_view.m_selectedAnchors.insert(hit);
                            }
                        }
                    }
                    this.m_button1NodeDrag = true;
                    this.m_view.m_contentChanged = true;
                }
                if (chosenNode == 0 && chosenEdge == 0 && chosenAnchor < 0) {
                    this.m_selectionRect = new Rectangle(this.m_lastXMousePos, this.m_lastYMousePos, 0, 0);
                    this.m_button1NodeDrag = false;
                }
            }
            GraphViewChangeListener listener = this.m_view.m_lis[0];
            if (listener != null) {
                if (unselectedNodes != null && unselectedNodes.length > 0) {
                    listener.graphViewChanged(new GraphViewNodesUnselectedEvent(this.m_view, unselectedNodes));
                }
                if (unselectedEdges != null && unselectedEdges.length > 0) {
                    listener.graphViewChanged(new GraphViewEdgesUnselectedEvent(this.m_view, unselectedEdges));
                }
                if (chosenNode != 0) {
                    if (chosenNodeSelected > 0) {
                        listener.graphViewChanged(new GraphViewNodesSelectedEvent(this.m_view, new int[]{chosenNode}));
                    } else if (chosenNodeSelected < 0) {
                        listener.graphViewChanged(new GraphViewNodesUnselectedEvent(this.m_view, new int[]{chosenNode}));
                    }
                }
                if (chosenEdge != 0) {
                    if (chosenEdgeSelected > 0) {
                        listener.graphViewChanged(new GraphViewEdgesSelectedEvent(this.m_view, new int[]{chosenEdge}));
                    } else if (chosenEdgeSelected < 0) {
                        listener.graphViewChanged(new GraphViewEdgesUnselectedEvent(this.m_view, new int[]{chosenEdge}));
                    }
                }
            }
            this.repaint();
        } else if (e.getButton() == 2) {
            this.m_undoable_edit = new ViewChangeEdit(this.m_view, ViewChangeEdit.SavedObjs.NODES, "Move");
            this.m_currMouseButton = 2;
            this.m_lastXMousePos = e.getX();
            this.m_lastYMousePos = e.getY();
        } else if (e.getButton() == 3 || this.isMacPlatform() && e.isControlDown()) {
            this.m_undoable_edit = new ViewChangeEdit(this.m_view, ViewChangeEdit.SavedObjs.NODES, "Move");
            this.m_currMouseButton = 3;
            this.m_lastXMousePos = e.getX();
            this.m_lastYMousePos = e.getY();
            this.processNodeContextMenuEvent(e);
            this.processEdgeContextMenuEvent(e);
        }
        this.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.m_currMouseButton == 1) {
                this.m_currMouseButton = 0;
                if (this.m_selectionRect != null) {
                    int[] selectedNodes = null;
                    int[] selectedEdges = null;
                    Object object = this.m_lock;
                    synchronized (object) {
                        if (this.m_view.m_nodeSelection || this.m_view.m_edgeSelection) {
                            double yMax;
                            double xMax;
                            double yMin;
                            double xMin;
                            if (this.m_view.m_nodeSelection) {
                                int i;
                                this.m_ptBuff[0] = this.m_selectionRect.x;
                                this.m_ptBuff[1] = this.m_selectionRect.y;
                                this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                                xMin = this.m_ptBuff[0];
                                yMin = this.m_ptBuff[1];
                                this.m_ptBuff[0] = this.m_selectionRect.x + this.m_selectionRect.width;
                                this.m_ptBuff[1] = this.m_selectionRect.y + this.m_selectionRect.height;
                                this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                                xMax = this.m_ptBuff[0];
                                yMax = this.m_ptBuff[1];
                                this.m_stack.empty();
                                this.m_view.getNodesIntersectingRectangle((float)xMin, (float)yMin, (float)xMax, (float)yMax, (this.m_lastRenderDetail & 1) == 0, this.m_stack);
                                this.m_stack2.empty();
                                IntEnumerator nodesXSect = this.m_stack.elements();
                                while (nodesXSect.numRemaining() > 0) {
                                    int nodeXSect = nodesXSect.nextInt();
                                    if (this.m_view.m_selectedNodes.count(~nodeXSect) != 0) continue;
                                    this.m_stack2.push(nodeXSect);
                                }
                                selectedNodes = new int[this.m_stack2.size()];
                                IntEnumerator nodes = this.m_stack2.elements();
                                for (i = 0; i < selectedNodes.length; ++i) {
                                    selectedNodes[i] = nodes.nextInt();
                                }
                                for (i = 0; i < selectedNodes.length; ++i) {
                                    ((DNodeView)this.m_view.getNodeView(selectedNodes[i])).selectInternal();
                                }
                                if (selectedNodes.length > 0) {
                                    this.m_view.m_contentChanged = true;
                                }
                            }
                            if (this.m_view.m_edgeSelection) {
                                int i;
                                if ((this.m_lastRenderDetail & 0x20) != 0) {
                                    this.m_ptBuff[0] = this.m_selectionRect.x;
                                    this.m_ptBuff[1] = this.m_selectionRect.y;
                                    this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                                    xMin = this.m_ptBuff[0];
                                    yMin = this.m_ptBuff[1];
                                    this.m_ptBuff[0] = this.m_selectionRect.x + this.m_selectionRect.width;
                                    this.m_ptBuff[1] = this.m_selectionRect.y + this.m_selectionRect.height;
                                    this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                                    xMax = this.m_ptBuff[0];
                                    yMax = this.m_ptBuff[1];
                                    SpacialEntry2DEnumerator hits = this.m_view.m_spacialA.queryOverlap((float)xMin, (float)yMin, (float)xMax, (float)yMax, null, 0, false);
                                    if (hits.numRemaining() > 0) {
                                        this.m_view.m_contentChanged = true;
                                    }
                                    while (hits.numRemaining() > 0) {
                                        int hit = hits.nextInt();
                                        if (this.m_view.m_selectedAnchors.count(hit) != 0) continue;
                                        this.m_view.m_selectedAnchors.insert(hit);
                                    }
                                }
                                this.computeEdgesIntersecting(this.m_selectionRect.x, this.m_selectionRect.y, this.m_selectionRect.x + this.m_selectionRect.width, this.m_selectionRect.y + this.m_selectionRect.height, this.m_stack2);
                                this.m_stack.empty();
                                IntEnumerator edgesXSect = this.m_stack2.elements();
                                while (edgesXSect.numRemaining() > 0) {
                                    int edgeXSect = edgesXSect.nextInt();
                                    if (this.m_view.m_selectedEdges.count(~edgeXSect) != 0) continue;
                                    this.m_stack.push(edgeXSect);
                                }
                                selectedEdges = new int[this.m_stack.size()];
                                IntEnumerator edges = this.m_stack.elements();
                                for (i = 0; i < selectedEdges.length; ++i) {
                                    selectedEdges[i] = edges.nextInt();
                                }
                                for (i = 0; i < selectedEdges.length; ++i) {
                                    ((DEdgeView)this.m_view.getEdgeView(selectedEdges[i])).selectInternal(true);
                                }
                                if (selectedEdges.length > 0) {
                                    this.m_view.m_contentChanged = true;
                                }
                            }
                        }
                    }
                    this.m_selectionRect = null;
                    GraphViewChangeListener listener = this.m_view.m_lis[0];
                    if (listener != null) {
                        if (selectedNodes != null && selectedNodes.length > 0) {
                            listener.graphViewChanged(new GraphViewNodesSelectedEvent(this.m_view, selectedNodes));
                        }
                        if (selectedEdges != null && selectedEdges.length > 0) {
                            listener.graphViewChanged(new GraphViewEdgesSelectedEvent(this.m_view, selectedEdges));
                        }
                    }
                    this.repaint();
                }
            }
            if (this.m_undoable_edit != null) {
                this.m_undoable_edit.post();
            }
        } else if (e.getButton() == 2) {
            if (this.m_currMouseButton == 2) {
                this.m_currMouseButton = 0;
            }
            if (this.m_undoable_edit != null) {
                this.m_undoable_edit.post();
            }
        } else if (e.getButton() == 3) {
            if (this.m_currMouseButton == 3) {
                this.m_currMouseButton = 0;
            }
            if (this.m_undoable_edit != null) {
                this.m_undoable_edit.post();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent e) {
        if (this.m_currMouseButton == 1) {
            if (this.m_button1NodeDrag) {
                if (this.isNodeMovementDisabled()) {
                    return;
                }
                if (this.m_undoable_edit == null) {
                    this.m_undoable_edit = new ViewChangeEdit(this.m_view, ViewChangeEdit.SavedObjs.SELECTED, "Move");
                }
                Object object = this.m_lock;
                synchronized (object) {
                    this.m_ptBuff[0] = this.m_lastXMousePos;
                    this.m_ptBuff[1] = this.m_lastYMousePos;
                    this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                    double oldX = this.m_ptBuff[0];
                    double oldY = this.m_ptBuff[1];
                    this.m_lastXMousePos = e.getX();
                    this.m_lastYMousePos = e.getY();
                    this.m_ptBuff[0] = this.m_lastXMousePos;
                    this.m_ptBuff[1] = this.m_lastYMousePos;
                    this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                    double newX = this.m_ptBuff[0];
                    double newY = this.m_ptBuff[1];
                    double deltaX = newX - oldX;
                    double deltaY = newY - oldY;
                    if (e.isShiftDown()) {
                        double slope = deltaY / deltaX;
                        if (slope > 2.41 || slope < -2.41) {
                            deltaX = 0.0;
                        } else if (slope < 0.41 && slope > -0.41) {
                            deltaY = 0.0;
                        } else {
                            double avg = (Math.abs(deltaX) + Math.abs(deltaY)) / 2.0;
                            deltaX = deltaX < 0.0 ? -avg : avg;
                            deltaY = deltaY < 0.0 ? -avg : avg;
                        }
                    }
                    int[] selectedNodes = this.m_view.getSelectedNodeIndices();
                    for (int i = 0; i < selectedNodes.length; ++i) {
                        NodeView nv = this.m_view.getNodeView(selectedNodes[i]);
                        double oldXPos = nv.getXPosition();
                        double oldYPos = nv.getYPosition();
                        nv.setOffset(oldXPos + deltaX, oldYPos + deltaY);
                    }
                    IntEnumerator anchorsToMove = this.m_view.m_selectedAnchors.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
                    while (anchorsToMove.numRemaining() > 0) {
                        int edgeAndAnchor = anchorsToMove.nextInt();
                        int edge = edgeAndAnchor >>> 6;
                        int anchorInx = edgeAndAnchor & 0x3F;
                        DEdgeView ev = (DEdgeView)this.m_view.getEdgeView(~edge);
                        ev.getHandleInternal(anchorInx, this.m_floatBuff1);
                        ev.moveHandleInternal(anchorInx, (double)this.m_floatBuff1[0] + deltaX, (double)this.m_floatBuff1[1] + deltaY);
                    }
                    if (selectedNodes.length > 0 || this.m_view.m_selectedAnchors.size() > 0) {
                        this.m_view.m_contentChanged = true;
                    }
                }
            }
            if (this.m_selectionRect != null) {
                int x = Math.min(this.m_lastXMousePos, e.getX());
                int y = Math.min(this.m_lastYMousePos, e.getY());
                int w = Math.abs(this.m_lastXMousePos - e.getX());
                int h = Math.abs(this.m_lastYMousePos - e.getY());
                this.m_selectionRect.setBounds(x, y, w, h);
            }
            this.repaint();
        } else if (this.m_currMouseButton == 2) {
            double deltaX = e.getX() - this.m_lastXMousePos;
            double deltaY = e.getY() - this.m_lastYMousePos;
            this.m_lastXMousePos = e.getX();
            this.m_lastYMousePos = e.getY();
            Object object = this.m_lock;
            synchronized (object) {
                this.m_xCenter -= deltaX / this.m_scaleFactor;
                this.m_yCenter -= deltaY / this.m_scaleFactor;
            }
            this.m_view.m_viewportChanged = true;
            this.repaint();
        } else if (this.m_currMouseButton == 3) {
            double deltaY = e.getY() - this.m_lastYMousePos;
            Object object = this.m_lock;
            synchronized (object) {
                this.m_lastXMousePos = e.getX();
                this.m_lastYMousePos = e.getY();
                this.m_scaleFactor *= Math.pow(2.0, -deltaY / 300.0);
            }
            this.m_view.m_viewportChanged = true;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        EdgeView ev;
        NodeView nv = this.m_view.getPickedNodeView(e.getPoint());
        boolean toolTipSet = false;
        if (nv != null) {
            this.setToolTipText(((DNodeView)nv).getToolTip());
            toolTipSet = true;
        } else if ((this.m_lastRenderDetail & 1) != 0 && (ev = this.m_view.getPickedEdgeView(e.getPoint())) != null) {
            this.setToolTipText(((DEdgeView)ev).getToolTip());
            toolTipSet = true;
        }
        if (!toolTipSet) {
            this.setToolTipText(null);
        }
    }

    public void keyPressed(KeyEvent k) {
        int code = k.getKeyCode();
        if (code == 38 || code == 40 || code == 37 || code == 39) {
            double move = 1.0;
            if (k.isShiftDown()) {
                move = 10.0;
            }
            if (this.m_view.m_nodeSelection) {
                int[] selectedNodes = this.m_view.getSelectedNodeIndices();
                for (int i = 0; i < selectedNodes.length; ++i) {
                    DNodeView nv = (DNodeView)this.m_view.getNodeView(selectedNodes[i]);
                    double xPos = nv.getXPosition();
                    double yPos = nv.getYPosition();
                    if (code == 38) {
                        yPos -= move;
                    } else if (code == 40) {
                        yPos += move;
                    } else if (code == 37) {
                        xPos -= move;
                    } else if (code == 39) {
                        xPos += move;
                    }
                    nv.setOffset(xPos, yPos);
                }
                IntEnumerator anchorsToMove = this.m_view.m_selectedAnchors.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
                while (anchorsToMove.numRemaining() > 0) {
                    int edgeAndAnchor = anchorsToMove.nextInt();
                    int edge = edgeAndAnchor >>> 6;
                    int anchorInx = edgeAndAnchor & 0x3F;
                    DEdgeView ev = (DEdgeView)this.m_view.getEdgeView(~edge);
                    ev.getHandleInternal(anchorInx, this.m_floatBuff1);
                    if (code == 38) {
                        ev.moveHandleInternal(anchorInx, this.m_floatBuff1[0], (double)this.m_floatBuff1[1] - move);
                        continue;
                    }
                    if (code == 40) {
                        ev.moveHandleInternal(anchorInx, this.m_floatBuff1[0], (double)this.m_floatBuff1[1] + move);
                        continue;
                    }
                    if (code == 37) {
                        ev.moveHandleInternal(anchorInx, (double)this.m_floatBuff1[0] - move, this.m_floatBuff1[1]);
                        continue;
                    }
                    if (code != 39) continue;
                    ev.moveHandleInternal(anchorInx, (double)this.m_floatBuff1[0] + move, this.m_floatBuff1[1]);
                }
                this.repaint();
            }
        }
    }

    public void keyReleased(KeyEvent k) {
    }

    public void keyTyped(KeyEvent k) {
    }

    final void computeEdgesIntersecting(int xMini, int yMini, int xMaxi, int yMaxi, IntStack stack) {
        this.m_ptBuff[0] = xMini;
        this.m_ptBuff[1] = yMini;
        this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
        double xMin = this.m_ptBuff[0];
        double yMin = this.m_ptBuff[1];
        this.m_ptBuff[0] = xMaxi;
        this.m_ptBuff[1] = yMaxi;
        this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
        double xMax = this.m_ptBuff[0];
        double yMax = this.m_ptBuff[1];
        IntEnumerator edgeNodesEnum = this.m_hash.elements();
        this.m_stack.empty();
        int edgeNodesCount = edgeNodesEnum.numRemaining();
        for (int i = 0; i < edgeNodesCount; ++i) {
            this.m_stack.push(edgeNodesEnum.nextInt());
        }
        this.m_hash.empty();
        edgeNodesEnum = this.m_stack.elements();
        stack.empty();
        FixedGraph graph = (FixedGraph)((Object)this.m_view.m_drawPersp);
        if ((this.m_lastRenderDetail & 1) == 0) {
            for (int i = 0; i < edgeNodesCount; ++i) {
                int node = edgeNodesEnum.nextInt();
                if (!this.m_view.m_spacial.exists(node, this.m_view.m_extentsBuff, 0)) continue;
                float nodeX = (this.m_view.m_extentsBuff[0] + this.m_view.m_extentsBuff[2]) / 2.0f;
                float nodeY = (this.m_view.m_extentsBuff[1] + this.m_view.m_extentsBuff[3]) / 2.0f;
                IntEnumerator touchingEdges = graph.edgesAdjacent(node, true, true, true);
                while (touchingEdges.numRemaining() > 0) {
                    int edge = touchingEdges.nextInt();
                    int otherNode = node ^ graph.edgeSource(edge) ^ graph.edgeTarget(edge);
                    if (this.m_hash.get(otherNode) >= 0) continue;
                    this.m_view.m_spacial.exists(otherNode, this.m_view.m_extentsBuff, 0);
                    float otherNodeX = (this.m_view.m_extentsBuff[0] + this.m_view.m_extentsBuff[2]) / 2.0f;
                    float otherNodeY = (this.m_view.m_extentsBuff[1] + this.m_view.m_extentsBuff[3]) / 2.0f;
                    this.m_line.setLine(nodeX, nodeY, otherNodeX, otherNodeY);
                    if (!this.m_line.intersects(xMin, yMin, xMax - xMin, yMax - yMin)) continue;
                    stack.push(~edge);
                }
                this.m_hash.put(node);
            }
        } else {
            for (int i = 0; i < edgeNodesCount; ++i) {
                int node = edgeNodesEnum.nextInt();
                if (!this.m_view.m_spacial.exists(node, this.m_view.m_extentsBuff, 0)) continue;
                byte nodeShape = this.m_view.m_nodeDetails.shape(node);
                IntEnumerator touchingEdges = graph.edgesAdjacent(node, true, true, true);
                while (touchingEdges.numRemaining() > 0) {
                    EdgeAnchors anchors;
                    float srcArrowSize;
                    float trgArrowSize;
                    byte srcArrow;
                    byte trgArrow;
                    float[] trgExtents;
                    float[] srcExtents;
                    byte trgShape;
                    byte srcShape;
                    int edge = touchingEdges.nextInt();
                    double segThicknessDiv2 = (double)this.m_view.m_edgeDetails.segmentThickness(edge) / 2.0;
                    int otherNode = node ^ graph.edgeSource(edge) ^ graph.edgeTarget(edge);
                    if (this.m_hash.get(otherNode) >= 0) continue;
                    this.m_view.m_spacial.exists(otherNode, this.m_extentsBuff2, 0);
                    byte otherNodeShape = this.m_view.m_nodeDetails.shape(otherNode);
                    if (node == graph.edgeSource(edge)) {
                        srcShape = nodeShape;
                        trgShape = otherNodeShape;
                        srcExtents = this.m_view.m_extentsBuff;
                        trgExtents = this.m_extentsBuff2;
                    } else {
                        srcShape = otherNodeShape;
                        trgShape = nodeShape;
                        srcExtents = this.m_extentsBuff2;
                        trgExtents = this.m_view.m_extentsBuff;
                    }
                    if ((this.m_lastRenderDetail & 8) == 0) {
                        trgArrow = -1;
                        srcArrow = -1;
                        trgArrowSize = 0.0f;
                        srcArrowSize = 0.0f;
                    } else {
                        srcArrow = this.m_view.m_edgeDetails.sourceArrow(edge);
                        trgArrow = this.m_view.m_edgeDetails.targetArrow(edge);
                        srcArrowSize = srcArrow == -1 ? 0.0f : this.m_view.m_edgeDetails.sourceArrowSize(edge);
                        trgArrowSize = trgArrow == -1 ? 0.0f : this.m_view.m_edgeDetails.targetArrowSize(edge);
                    }
                    EdgeAnchors edgeAnchors = anchors = (this.m_lastRenderDetail & 0x20) == 0 ? null : this.m_view.m_edgeDetails.anchors(edge);
                    if (!GraphRenderer.computeEdgeEndpoints(this.m_grafx, srcExtents, srcShape, srcArrow, srcArrowSize, anchors, trgExtents, trgShape, trgArrow, trgArrowSize, this.m_floatBuff1, this.m_floatBuff2)) continue;
                    this.m_grafx.getEdgePath(srcArrow, srcArrowSize, trgArrow, trgArrowSize, this.m_floatBuff1[0], this.m_floatBuff1[1], anchors, this.m_floatBuff2[0], this.m_floatBuff2[1], this.m_path);
                    GraphRenderer.computeClosedPath(this.m_path.getPathIterator(null), this.m_path2);
                    if (!this.m_path2.intersects(xMin - segThicknessDiv2, yMin - segThicknessDiv2, xMax - xMin + segThicknessDiv2 * 2.0, yMax - yMin + segThicknessDiv2 * 2.0)) continue;
                    stack.push(~edge);
                }
                this.m_hash.put(node);
            }
        }
    }

    public void dragEnter(DropTargetDragEvent dte) {
        dte.acceptDrag(1);
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dropActionChanged(DropTargetDragEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dte) {
    }

    public void drop(DropTargetDropEvent dte) {
        dte.acceptDrop(1);
        Transferable t = dte.getTransferable();
        Point pt = dte.getLocation();
        PhoebeCanvasDropEvent event = new PhoebeCanvasDropEvent(this, t, pt);
        this.processPhoebeCanvasDropEvent(event);
        dte.dropComplete(true);
    }

    public void addPhoebeCanvasDropListener(PhoebeCanvasDropListener l) {
        this.listeners.addElement(l);
    }

    public void removePhoebeCanvasDropListener(PhoebeCanvasDropListener l) {
        this.listeners.removeElement(l);
    }

    protected synchronized void processPhoebeCanvasDropEvent(PhoebeCanvasDropEvent event) {
        Enumeration e = this.listeners.elements();
        Transferable t = event.getTransferable();
        for (JComponent jComp : this.transferComponents) {
            TransferHandler th = jComp.getTransferHandler();
            if (th == null) continue;
        }
        while (e.hasMoreElements()) {
            PhoebeCanvasDropListener l = (PhoebeCanvasDropListener)e.nextElement();
            l.itemDropped(event);
        }
    }

    public void addTransferComponent(JComponent comp) {
        if (!this.transferComponents.contains(comp)) {
            this.transferComponents.addElement(comp);
        }
    }

    public void removeTransferComponent(JComponent comp) {
        this.transferComponents.removeElement(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        double factor = 1.0;
        factor = notches < 0 ? 1.1 : 0.9;
        Object object = this.m_lock;
        synchronized (object) {
            this.m_scaleFactor *= factor;
        }
        this.m_view.m_viewportChanged = true;
        this.repaint();
    }

    public void addNodeContextMenuListener(NodeContextMenuListener l) {
        this.nodeContextMenuListeners.addElement(l);
    }

    public void removeNodeContextMenuListener(NodeContextMenuListener l) {
        this.nodeContextMenuListeners.removeElement(l);
    }

    public void addEdgeContextMenuListener(EdgeContextMenuListener l) {
        this.edgeContextMenuListeners.addElement(l);
    }

    public void removeEdgeContextMenuListener(EdgeContextMenuListener l) {
        this.edgeContextMenuListeners.removeElement(l);
    }

    protected synchronized void processNodeContextMenuEvent(MouseEvent event) {
        NodeView nv = this.m_view.getPickedNodeView(event.getPoint());
        if (nv != null) {
            String nodeLabel = nv.getNode().getIdentifier();
            JPopupMenu menu = new JPopupMenu(nodeLabel);
            menu.setLabel(nodeLabel);
            Enumeration e = this.nodeContextMenuListeners.elements();
            while (e.hasMoreElements()) {
                NodeContextMenuListener l = (NodeContextMenuListener)e.nextElement();
                l.addNodeContextMenuItems(nv, menu);
            }
            menu.show(this, event.getX(), event.getY());
        }
    }

    protected synchronized void processEdgeContextMenuEvent(MouseEvent event) {
        EdgeView ev = this.m_view.getPickedEdgeView(event.getPoint());
        if (ev != null) {
            String edgeLabel = ev.getEdge().getIdentifier();
            JPopupMenu menu = new JPopupMenu(edgeLabel);
            menu.setLabel(edgeLabel);
            Enumeration e = this.edgeContextMenuListeners.elements();
            while (e.hasMoreElements()) {
                EdgeContextMenuListener l = (EdgeContextMenuListener)e.nextElement();
                l.addEdgeContextMenuItems(ev, menu);
            }
            menu.show(this, event.getX(), event.getY());
        }
    }

    public int getLastRenderDetail() {
        return this.m_lastRenderDetail;
    }

    public void setSelecting(boolean s) {
        this.selecting = s;
    }

    public boolean isSelecting() {
        return this.selecting;
    }

    public AffineTransform getAffineTransform() {
        return this.m_grafx != null ? this.m_grafx.getTransform() : null;
    }

    private boolean isAnchorKeyDown(MouseEvent e) {
        return !this.isMacPlatform() && e.isControlDown() || this.isMacPlatform() && e.isMetaDown();
    }

    private boolean isMacPlatform() {
        String os = System.getProperty("os.name");
        return os.regionMatches(true, 0, MAC_OS_ID, 0, MAC_OS_ID.length());
    }

    public void enableNodeMovement() {
        this.NodeMovement = true;
    }

    public void disableNodeMovement() {
        this.NodeMovement = false;
    }

    public boolean isNodeMovementDisabled() {
        return !this.NodeMovement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderGraph(GraphGraphics graphics, boolean setLastRenderDetail, GraphLOD lod) {
        int alpha = this.m_isOpaque ? 255 : 0;
        Color backgroundColor = new Color(this.m_backgroundColor.getRed(), this.m_backgroundColor.getGreen(), this.m_backgroundColor.getBlue(), alpha);
        Object object = this.m_lock;
        synchronized (object) {
            int lastRenderDetail = GraphRenderer.renderGraph((FixedGraph)((Object)this.m_view.m_drawPersp), this.m_view.m_spacial, lod, this.m_view.m_nodeDetails, this.m_view.m_edgeDetails, this.m_hash, graphics, backgroundColor, this.m_xCenter, this.m_yCenter, this.m_scaleFactor);
            if (setLastRenderDetail) {
                this.m_lastRenderDetail = lastRenderDetail;
            }
        }
    }
}

