/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import ding.view.ObjectPositionImpl;
import giny.view.Justification;
import giny.view.ObjectPosition;
import giny.view.Position;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;

public class ObjectPlacerGraphic
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -1091948204116900740L;
    protected static final String OBJECT_POSITION_CHANGED = "OBJECT_POSITION_CHANGED";
    private ObjectPosition p;
    private static final int DEFAULT_WINDOW_SIZE = 500;
    private static final double GRAVITY_DISTANCE = 10.0;
    private static final Color transparentRed = new Color(1.0f, 0.0f, 0.0f, 0.1f);
    private static final Color transparentBlue = new Color(0.0f, 0.0f, 1.0f, 0.1f);
    private static final Color transparentMagenta = new Color(0.0f, 0.0f, 1.0f, 0.05f);
    private int xy;
    private int center;
    private float offsetRatio;
    private int nxy;
    private int[] npoints;
    private int lx;
    private int ly;
    private int[] lxpoints;
    private int[] lypoints;
    private int dot;
    private int xPos;
    private int yPos;
    private int bestLabelX = 1;
    private int bestLabelY = 1;
    private int bestNodeX = 1;
    private int bestNodeY = 1;
    private boolean beenDragged = false;
    private boolean canOffsetDrag = false;
    private int xClickOffset = 0;
    private int yClickOffset = 0;
    private int xOffset;
    private int yOffset;
    private Justification justify;
    private boolean renderDetail;
    private String objectLabel = "LABEL";
    private String targetLabel = "NODE";
    private String click = "CLICK 'N DRAG";
    private int labelLen = 0;
    private int clickLen = 0;
    private int ascent = 0;
    private int detailStrokeWidth = 3;
    private int lowStrokeWidth = 1;
    private Stroke detailStroke = new BasicStroke(this.detailStrokeWidth);
    private Stroke lowStroke = new BasicStroke(this.lowStrokeWidth);
    private final Dimension objectSize;
    private final Dimension targetSize;

    public ObjectPlacerGraphic(ObjectPosition pos, Integer windowSize, boolean fullDetail, String objectName, Dimension objectSize, Dimension targetSize) {
        this.objectLabel = objectName;
        this.objectSize = objectSize;
        this.targetSize = targetSize;
        this.p = pos == null ? new ObjectPositionImpl() : pos;
        this.renderDetail = fullDetail;
        if (windowSize == null) {
            this.initSize(500);
        } else {
            this.initSize(windowSize);
        }
        this.setPreferredSize(new Dimension(this.xy, this.xy));
        this.setBackground(Color.white);
        this.addMouseListener(new MouseClickHandler());
        this.addMouseMotionListener(new MouseDragHandler());
        this.applyPosition();
        this.repaint();
    }

    private void initSize(int size) {
        this.xy = size;
        this.center = this.xy / 2;
        this.offsetRatio = (float)this.xy / 500.0f;
        this.nxy = (int)(0.3 * (double)this.xy);
        int[] tnpoints = new int[]{this.center - this.nxy / 2, this.center, this.center + this.nxy / 2};
        this.npoints = tnpoints;
        this.lx = (int)(0.4 * (double)this.xy);
        this.ly = (int)(0.1 * (double)this.xy);
        int[] tlxpoints = new int[]{0, this.lx / 2, this.lx};
        int[] tlypoints = new int[]{0, this.ly / 2, this.ly};
        this.lxpoints = tlxpoints;
        this.lypoints = tlypoints;
        this.xPos = this.dot = (int)(0.02 * (double)this.xy);
        this.yPos = this.dot;
    }

    public void paint(Graphics gin) {
        Graphics2D g = (Graphics2D)gin;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.labelLen <= 0) {
            FontMetrics fm = g.getFontMetrics();
            this.labelLen = fm.stringWidth(this.objectLabel);
            this.clickLen = fm.stringWidth(this.click);
            this.ascent = fm.getMaxAscent();
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, this.xy, this.xy);
        int x = this.center - this.nxy / 2;
        int y = this.center - this.nxy / 2;
        g.setColor(transparentBlue);
        g.fillOval(x, y, this.nxy, this.nxy);
        if (this.renderDetail) {
            g.setStroke(this.detailStroke);
        } else {
            g.setStroke(this.lowStroke);
        }
        g.setColor(Color.blue);
        g.drawLine(x, y, x + this.nxy, y);
        g.drawLine(x + this.nxy, y, x + this.nxy, y + this.nxy);
        g.drawLine(x + this.nxy, y + this.nxy, x, y + this.nxy);
        g.drawLine(x, y + this.nxy, x, y);
        if (this.renderDetail) {
            g.drawString(this.targetLabel, this.center - this.nxy / 12, this.center - this.nxy / 6);
            g.setColor(Color.black);
            int gd = (int)(20.0 + (double)(this.dot / 2));
            for (int i = 0; i < this.npoints.length; ++i) {
                for (int j = 0; j < this.npoints.length; ++j) {
                    g.setColor(transparentMagenta);
                    g.fillOval(this.npoints[i] - gd / 2, this.npoints[j] - gd / 2, gd, gd);
                    if (i == this.bestNodeX && j == this.bestNodeY && !this.beenDragged) {
                        g.setColor(Color.yellow);
                    } else {
                        g.setColor(Color.black);
                    }
                    g.fillOval(this.npoints[i] - this.dot / 2, this.npoints[j] - this.dot / 2, this.dot, this.dot);
                }
            }
        }
        g.setColor(transparentRed);
        g.fillRect(this.xOffset + this.xPos, this.yOffset + this.yPos, this.lx, this.ly);
        g.setColor(Color.red);
        g.drawLine(this.xOffset + this.xPos, this.yOffset + this.yPos, this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos);
        g.drawLine(this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos, this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos + this.ly);
        g.drawLine(this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos + this.ly, this.xOffset + this.xPos, this.yOffset + this.yPos + this.ly);
        g.drawLine(this.xOffset + this.xPos, this.yOffset + this.yPos + this.ly, this.xOffset + this.xPos, this.yOffset + this.yPos);
        if (this.renderDetail) {
            int vspace = (this.ly - this.ascent - this.ascent) / 3;
            if (this.justify == Justification.JUSTIFY_LEFT) {
                g.drawString(this.objectLabel, this.xOffset + this.xPos + this.detailStrokeWidth, this.yOffset + this.yPos + vspace + this.ascent);
                g.drawString(this.click, this.xOffset + this.xPos + this.detailStrokeWidth, this.yOffset + this.yPos + 2 * (vspace + this.ascent));
            } else if (this.justify == Justification.JUSTIFY_RIGHT) {
                g.drawString(this.objectLabel, this.xOffset + this.xPos + (this.lx - this.labelLen), this.yOffset + this.yPos + vspace + this.ascent);
                g.drawString(this.click, this.xOffset + this.xPos + (this.lx - this.clickLen), this.yOffset + this.yPos + 2 * (vspace + this.ascent));
            } else {
                g.drawString(this.objectLabel, this.xOffset + this.xPos + (this.lx - this.labelLen) / 2 - this.detailStrokeWidth, this.yOffset + this.yPos + vspace + this.ascent);
                g.drawString(this.click, this.xOffset + this.xPos + (this.lx - this.clickLen) / 2 - this.detailStrokeWidth, this.yOffset + this.yPos + 2 * (vspace + this.ascent));
            }
        } else {
            g.setColor(Color.gray);
            if (this.justify == Justification.JUSTIFY_LEFT) {
                g.drawLine(this.xOffset + this.xPos + this.lowStrokeWidth, this.yOffset + this.yPos + this.ly / 2, this.xOffset + this.xPos + this.lx / 3, this.yOffset + this.yPos + this.ly / 2);
            } else if (this.justify == Justification.JUSTIFY_RIGHT) {
                g.drawLine(this.xOffset + this.xPos + 2 * this.lx / 3, this.yOffset + this.yPos + this.ly / 2, this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos + this.ly / 2);
            } else {
                g.drawLine(this.xOffset + this.xPos + this.lx / 3, this.yOffset + this.yPos + this.ly / 2, this.xOffset + this.xPos + 2 * this.lx / 3 - this.lowStrokeWidth, this.yOffset + this.yPos + this.ly / 2);
            }
        }
        if (this.renderDetail) {
            g.setColor(Color.black);
            for (int i = 0; i < this.lxpoints.length; ++i) {
                for (int j = 0; j < this.lypoints.length; ++j) {
                    if (i == this.bestLabelX && j == this.bestLabelY && !this.beenDragged) {
                        g.setColor(Color.yellow);
                    }
                    g.fillOval(this.xPos + this.xOffset + this.lxpoints[i] - this.dot / 2, this.yPos + this.yOffset + this.lypoints[j] - this.dot / 2, this.dot, this.dot);
                    if (i != this.bestLabelX || j != this.bestLabelY) continue;
                    g.setColor(Color.black);
                }
            }
        }
    }

    private void applyPosition() {
        Position labelAnchor;
        this.xOffset = (int)(this.p.getOffsetX() * (double)this.offsetRatio);
        this.yOffset = (int)(this.p.getOffsetY() * (double)this.offsetRatio);
        this.justify = this.p.getJustify();
        Position nodeAnchor = this.p.getTargetAnchor();
        if (nodeAnchor != Position.NONE) {
            this.bestNodeX = nodeAnchor.getGinyConstant() % 3;
            this.bestNodeY = nodeAnchor.getGinyConstant() / 3;
        }
        if ((labelAnchor = this.p.getAnchor()) != Position.NONE) {
            this.bestLabelX = labelAnchor.getGinyConstant() % 3;
            this.bestLabelY = labelAnchor.getGinyConstant() / 3;
        }
        if (nodeAnchor != Position.NONE || labelAnchor != Position.NONE) {
            this.xPos = this.npoints[this.bestNodeX] - this.lxpoints[this.bestLabelX];
            this.yPos = this.npoints[this.bestNodeY] - this.lypoints[this.bestLabelY];
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String type = e.getPropertyName();
        if (type.equals(OBJECT_POSITION_CHANGED)) {
            this.p = (ObjectPosition)e.getNewValue();
            this.applyPosition();
            this.repaint();
        }
    }

    private class MouseDragHandler
    extends MouseMotionAdapter {
        private MouseDragHandler() {
        }

        public void mouseDragged(MouseEvent e) {
            if (ObjectPlacerGraphic.this.canOffsetDrag) {
                ObjectPlacerGraphic.this.xPos = e.getX() - ObjectPlacerGraphic.this.xClickOffset;
                ObjectPlacerGraphic.this.yPos = e.getY() - ObjectPlacerGraphic.this.yClickOffset;
                ObjectPlacerGraphic.this.beenDragged = true;
                ObjectPlacerGraphic.this.repaint();
            }
        }
    }

    private class MouseClickHandler
    extends MouseAdapter {
        private MouseClickHandler() {
        }

        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (x >= ObjectPlacerGraphic.this.xPos + ObjectPlacerGraphic.this.xOffset && x <= ObjectPlacerGraphic.this.xPos + ObjectPlacerGraphic.this.xOffset + ObjectPlacerGraphic.this.lx && y >= ObjectPlacerGraphic.this.yPos + ObjectPlacerGraphic.this.yOffset && y <= ObjectPlacerGraphic.this.yPos + ObjectPlacerGraphic.this.yOffset + ObjectPlacerGraphic.this.ly) {
                ObjectPlacerGraphic.this.canOffsetDrag = true;
                ObjectPlacerGraphic.this.xClickOffset = x - ObjectPlacerGraphic.this.xPos;
                ObjectPlacerGraphic.this.yClickOffset = y - ObjectPlacerGraphic.this.yPos;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (ObjectPlacerGraphic.this.beenDragged) {
                int x = e.getX();
                int y = e.getY();
                ObjectPlacerGraphic.this.xPos = x - ObjectPlacerGraphic.this.xClickOffset + ObjectPlacerGraphic.this.xOffset;
                ObjectPlacerGraphic.this.yPos = y - ObjectPlacerGraphic.this.yClickOffset + ObjectPlacerGraphic.this.yOffset;
                double best = Double.POSITIVE_INFINITY;
                double offX = 0.0;
                double offY = 0.0;
                for (int i = 0; i < ObjectPlacerGraphic.this.npoints.length; ++i) {
                    for (int j = 0; j < ObjectPlacerGraphic.this.npoints.length; ++j) {
                        Point nodePoint = new Point(ObjectPlacerGraphic.this.npoints[i] - ObjectPlacerGraphic.this.dot / 2, ObjectPlacerGraphic.this.npoints[j] - ObjectPlacerGraphic.this.dot / 2);
                        for (int a = 0; a < ObjectPlacerGraphic.this.lxpoints.length; ++a) {
                            for (int b = 0; b < ObjectPlacerGraphic.this.lypoints.length; ++b) {
                                Point labelPoint = new Point(ObjectPlacerGraphic.this.xPos + ObjectPlacerGraphic.this.lxpoints[a] - ObjectPlacerGraphic.this.dot / 2, ObjectPlacerGraphic.this.yPos + ObjectPlacerGraphic.this.lypoints[b] - ObjectPlacerGraphic.this.dot / 2);
                                double dist = labelPoint.distance(nodePoint);
                                if (!(dist < best)) continue;
                                best = dist;
                                ObjectPlacerGraphic.this.bestLabelX = a;
                                ObjectPlacerGraphic.this.bestLabelY = b;
                                ObjectPlacerGraphic.this.bestNodeX = i;
                                ObjectPlacerGraphic.this.bestNodeY = j;
                                offX = labelPoint.getX() - nodePoint.getX();
                                offY = labelPoint.getY() - nodePoint.getY();
                            }
                        }
                    }
                }
                ObjectPlacerGraphic.this.xPos = ObjectPlacerGraphic.this.npoints[ObjectPlacerGraphic.this.bestNodeX] - ObjectPlacerGraphic.this.lxpoints[ObjectPlacerGraphic.this.bestLabelX];
                ObjectPlacerGraphic.this.yPos = ObjectPlacerGraphic.this.npoints[ObjectPlacerGraphic.this.bestNodeY] - ObjectPlacerGraphic.this.lypoints[ObjectPlacerGraphic.this.bestLabelY];
                if (Math.sqrt(offX * offX + offY * offY) > 10.0 + (double)(ObjectPlacerGraphic.this.dot / 2)) {
                    ObjectPlacerGraphic.this.xOffset = (int)offX;
                    ObjectPlacerGraphic.this.yOffset = (int)offY;
                } else {
                    ObjectPlacerGraphic.this.xOffset = 0;
                    ObjectPlacerGraphic.this.yOffset = 0;
                }
                ObjectPlacerGraphic.this.p.setOffsetX(ObjectPlacerGraphic.this.xOffset);
                ObjectPlacerGraphic.this.p.setOffsetY(ObjectPlacerGraphic.this.yOffset);
                ObjectPlacerGraphic.this.p.setAnchor(Position.parse(ObjectPlacerGraphic.this.bestLabelX + 3 * ObjectPlacerGraphic.this.bestLabelY));
                ObjectPlacerGraphic.this.p.setTargetAnchor(Position.parse(ObjectPlacerGraphic.this.bestNodeX + 3 * ObjectPlacerGraphic.this.bestNodeY));
                ObjectPlacerGraphic.this.firePropertyChange(ObjectPlacerGraphic.OBJECT_POSITION_CHANGED, null, ObjectPlacerGraphic.this.p);
                ObjectPlacerGraphic.this.repaint();
                ObjectPlacerGraphic.this.beenDragged = false;
                ObjectPlacerGraphic.this.canOffsetDrag = false;
            }
        }
    }
}

