/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.strokes;

import cytoscape.CytoscapeInit;
import cytoscape.util.PropUtil;
import cytoscape.visual.LineStyle;
import cytoscape.visual.strokes.ShapeStroke;
import cytoscape.visual.strokes.WidthStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class SineWaveStroke
extends ShapeStroke {
    public SineWaveStroke(float width) {
        super(new Shape[]{SineWaveStroke.getSineWave(width)}, PropUtil.getFloat(CytoscapeInit.getProperties(), "SineWaveStroke.wavelength", 10.0f), LineStyle.SINEWAVE, width);
    }

    public WidthStroke newInstanceForWidth(float w) {
        return new SineWaveStroke(w);
    }

    private static Shape getSineWave(float width) {
        GeneralPath shape = new GeneralPath();
        float wavelength = PropUtil.getFloat(CytoscapeInit.getProperties(), "SineWaveStroke.wavelength", 10.0f);
        float amplitude = PropUtil.getFloat(CytoscapeInit.getProperties(), "SineWaveStroke.amplitude", 5.0f);
        shape.moveTo(0.0f, 0.0f);
        shape.lineTo(0.0f, width);
        shape.quadTo(0.25f * wavelength, amplitude + width, 0.5f * wavelength, width);
        shape.quadTo(0.75f * wavelength, -amplitude - width, wavelength, width);
        shape.lineTo(wavelength, 0.0f);
        shape.quadTo(0.75f * wavelength, -amplitude - width, 0.5f * wavelength, 0.0f);
        shape.quadTo(0.25f * wavelength, amplitude + width, 0.0f, 0.0f);
        return shape;
    }
}

