/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.LineStyle;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.properties.GTZeroValidator;
import cytoscape.visual.ui.icon.LineTypeIcon;
import giny.view.EdgeView;
import java.awt.Color;
import java.awt.Stroke;
import javax.swing.Icon;

public class EdgeLineWidthProp
extends AbstractVisualProperty {
    public EdgeLineWidthProp() {
        this.validator = new GTZeroValidator();
    }

    public VisualPropertyType getType() {
        return VisualPropertyType.EDGE_LINE_WIDTH;
    }

    public Icon getIcon(Object value) {
        LineTypeIcon icon = new LineTypeIcon();
        icon.setColor(new Color(10, 10, 10, 20));
        icon.setText(value.toString());
        icon.setBottomPadding(-7);
        return icon;
    }

    public void applyToEdgeView(EdgeView ev, Object o, VisualPropertyDependency dep) {
        if (o == null || ev == null) {
            return;
        }
        float width = ((Number)o).floatValue();
        if (ev.getStrokeWidth() != width) {
            Stroke oldStroke = ev.getStroke();
            Stroke newStroke = LineStyle.extractLineStyle(oldStroke).getStroke(width);
            ev.setStroke(newStroke);
            ev.setStrokeWidth(width);
        }
    }

    public Object getDefaultAppearanceObject() {
        return new Float(1.0f);
    }
}

