/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.Cytoscape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.AbstractMapping;
import cytoscape.visual.mappings.RangeValueCalculator;
import cytoscape.visual.parsers.ValueParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Map;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.border.DropShadowBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PassThroughMapping
extends AbstractMapping {
    private static final Font TITLE_FONT = new Font("SansSerif", 1, 14);
    private static final Color TITLE_COLOR = new Color(10, 200, 255);
    private RangeValueCalculator rangeValueCalculator;
    private final Class<?>[] ACCEPTED_CLASS = new Class[]{Object.class};

    @Deprecated
    public PassThroughMapping(Object defaultObj, byte mapType) {
        this(defaultObj, null);
    }

    @Deprecated
    public PassThroughMapping(Object defaultObj) {
        this(defaultObj, null);
    }

    @Deprecated
    public PassThroughMapping(Object defaultObj, String attrName) {
        this(defaultObj.getClass(), attrName);
    }

    public PassThroughMapping(Class<?> rangeClass, String attrName) {
        super(rangeClass, attrName);
        this.acceptedClasses = this.ACCEPTED_CLASS;
    }

    @Override
    public Object clone() {
        PassThroughMapping copy = new PassThroughMapping(this.rangeClass, this.controllingAttrName);
        return copy;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
    }

    @Override
    public Object calculateRangeValue(Map<String, Object> attrBundle) {
        if (attrBundle == null || this.controllingAttrName == null) {
            return null;
        }
        Object attrValue = attrBundle.get(this.controllingAttrName);
        if (attrValue == null) {
            return null;
        }
        if (this.rangeValueCalculator == null) {
            this.rangeValueCalculator = Cytoscape.getVisualMappingManager().getRangeValueCalculatorFactory().getRangeValueCalculator(this.rangeClass);
        }
        if (this.rangeValueCalculator != null) {
            return this.rangeValueCalculator.getRange(attrValue);
        }
        return null;
    }

    @Override
    public void applyProperties(Properties props, String baseKey, ValueParser parser) {
        String contKey = baseKey + ".controller";
        String contValue = props.getProperty(contKey);
        if (contValue != null) {
            this.setControllingAttributeName(contValue);
        }
    }

    @Override
    public Properties getProperties(String baseKey) {
        Properties newProps = new Properties();
        String contKey = baseKey + ".controller";
        String contValue = this.controllingAttrName;
        if (contKey != null && contValue != null) {
            newProps.setProperty(contKey, contValue);
        }
        return newProps;
    }

    @Override
    public JPanel getLegend(VisualPropertyType vpt) {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JLabel title = new JLabel(vpt.getName() + " is displayed as " + this.controllingAttrName);
        title.setFont(TITLE_FONT);
        title.setForeground(TITLE_COLOR);
        title.setHorizontalAlignment(0);
        title.setVerticalAlignment(0);
        title.setHorizontalTextPosition(0);
        title.setVerticalTextPosition(0);
        title.setPreferredSize(new Dimension(200, 50));
        title.setBorder(new DropShadowBorder());
        p.setBackground(Color.white);
        p.add((Component)title, 0);
        return p;
    }
}

