/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.logger.CyLogger;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import cytoscape.visual.parsers.ValueParser;
import java.util.Properties;

public class MappingFactory {
    public static ObjectMapping newMapping(Properties props, String baseKey, ValueParser parser, Object defObj, byte mapType) {
        String typeName = props.getProperty(baseKey + ".type");
        if (typeName == null) {
            CyLogger.getLogger().warn("MappingFactory: no Mapping class specified in properties");
            return null;
        }
        if (typeName.equals("DiscreteMapping")) {
            DiscreteMapping m = new DiscreteMapping(defObj.getClass(), null);
            m.applyProperties(props, baseKey, parser);
            return m;
        }
        if (typeName.equals("ContinuousMapping")) {
            ContinuousMapping m = new ContinuousMapping(defObj.getClass(), null);
            m.applyProperties(props, baseKey, parser);
            return m;
        }
        if (typeName.equals("PassThroughMapping")) {
            PassThroughMapping m = new PassThroughMapping(defObj.getClass(), null);
            m.applyProperties(props, baseKey, parser);
            return m;
        }
        CyLogger.getLogger().warn("MappingFactory: unknown Mapping type: " + typeName);
        return null;
    }

    public static Properties getProperties(ObjectMapping m, String baseKey) {
        if (m == null) {
            return null;
        }
        Properties newProps = m.getProperties(baseKey);
        if (m instanceof DiscreteMapping) {
            newProps.setProperty(baseKey + ".type", "DiscreteMapping");
        } else if (m instanceof ContinuousMapping) {
            newProps.setProperty(baseKey + ".type", "ContinuousMapping");
        } else if (m instanceof PassThroughMapping) {
            newProps.setProperty(baseKey + ".type", "PassThroughMapping");
        } else {
            String c = m.getClass().getName();
            CyLogger.getLogger().warn("MappingFactory: unknown Mapping type: " + c);
            return null;
        }
        return newProps;
    }
}

