/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.customgraphic;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.visual.customgraphic.CustomGraphicsManager;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.customgraphic.ImageUtil;
import cytoscape.visual.customgraphic.NullCustomGraphics;
import cytoscape.visual.customgraphic.SaveImageTask;
import cytoscape.visual.customgraphic.impl.bitmap.URLImageCustomGraphics;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class PersistImageTask
implements Task {
    private File location;
    private TaskMonitor taskMonitor;
    private static final int TIMEOUT = 1000;
    private static final int NUM_THREADS = 4;
    private static final CyLogger logger = CyLogger.getLogger();

    protected PersistImageTask(File location) {
        this.location = location;
    }

    public void run() {
        File[] files;
        this.taskMonitor.setStatus("Saving image library to your local disk.\n\nPlease wait...");
        this.taskMonitor.setPercentCompleted(-1);
        for (File old : files = this.location.listFiles()) {
            old.delete();
        }
        long startTime = System.currentTimeMillis();
        CustomGraphicsManager pool = Cytoscape.getVisualMappingManager().getCustomGraphicsManager();
        ExecutorService exService = Executors.newFixedThreadPool(4);
        for (CyCustomGraphics cg : pool.getAll()) {
            Image img;
            if (cg instanceof NullCustomGraphics || !(cg instanceof URLImageCustomGraphics) || (img = cg.getRenderedImage()) == null) continue;
            try {
                exService.submit(new SaveImageTask(this.location, cg.getIdentifier().toString(), ImageUtil.toBufferedImage(img)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            exService.shutdown();
            exService.awaitTermination(1000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.taskMonitor.setException(e, "Image saving task interrupted.");
        }
        try {
            pool.getMetadata().store(new FileOutputStream(new File(this.location, "image_metadata.props")), "Image Metadata");
        }
        catch (IOException e) {
            this.taskMonitor.setException(e, "Could not save image metadata.");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double sec = (double)(endTime - startTime) / 1000.0;
        logger.info("Image saving process finished in " + sec + " sec.");
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return "Saving Image Library";
    }
}

